/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class ColumnLayout
implements LayoutManager,
Serializable {
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 0;
    public static final int RIGHT = 2;
    private int verticalAlignment;
    private int hgap;
    private int vgap;
    private boolean fillWidth;
    private boolean fillHeight;
    private int horizontalAlignment;
    private Dimension targetSize = new Dimension();

    public ColumnLayout() {
        this(0, 5, 5, false, false);
    }

    public ColumnLayout(int verticalAlignment, int hgap, int vgap, boolean fillWidth, boolean fillHeight) {
        this.verticalAlignment = verticalAlignment;
        this.hgap = hgap;
        this.vgap = vgap;
        this.fillWidth = fillWidth;
        this.fillHeight = fillHeight;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void setVerticalFill(boolean fillHeight) {
        this.fillHeight = fillHeight;
    }

    public boolean getVerticalFill() {
        return this.fillHeight;
    }

    public void setHorizontalFill(boolean fillWidth) {
        this.fillWidth = fillWidth;
    }

    public boolean getHorizontalFill() {
        return this.fillWidth;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container target) {
        this.targetSize.width = 0;
        this.targetSize.height = 0;
        for (int i = 0; i < target.getComponentCount(); ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getPreferredSize();
            this.targetSize.width = Math.max(this.targetSize.width, d.width);
            if (i > 0) {
                this.targetSize.height += this.vgap;
            }
            this.targetSize.height += d.height;
        }
        Insets insets = target.getInsets();
        this.targetSize.width += insets.left + insets.right + this.hgap * 2;
        this.targetSize.height += insets.top + insets.bottom + this.vgap * 2;
        return this.targetSize;
    }

    public Dimension minimumLayoutSize(Container target) {
        this.targetSize.width = 0;
        this.targetSize.height = 0;
        for (int i = 0; i < target.getComponentCount(); ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getMinimumSize();
            this.targetSize.width = Math.max(this.targetSize.width, d.width);
            if (i > 0) {
                this.targetSize.height += this.vgap;
            }
            this.targetSize.height += d.height;
        }
        Insets insets = target.getInsets();
        this.targetSize.width += insets.left + insets.right + this.hgap * 2;
        this.targetSize.height += insets.top + insets.bottom + this.vgap * 2;
        return this.targetSize;
    }

    private void layoutComponents(Container target, int x, int y, int width, int height, int first, int last) {
        Insets insets = target.getInsets();
        if (this.verticalAlignment == 1) {
            y += height / 2;
        }
        if (this.verticalAlignment == 2) {
            y += height;
        }
        for (int i = first; i < last; ++i) {
            Component m = target.getComponent(i);
            Dimension md = m.getSize();
            if (!m.isVisible()) continue;
            int px = this.horizontalAlignment == 0 ? x : (this.horizontalAlignment == 2 ? width - md.width : x + (width - md.width) / 2);
            m.setLocation(px, y);
            y += this.vgap + md.height;
        }
    }

    public void layoutContainer(Container target) {
        Insets insets = target.getInsets();
        int maxheight = target.getSize().height - (insets.top + insets.bottom + this.vgap * 2);
        int maxwidth = target.getSize().width - (insets.left + insets.right + this.hgap * 2);
        int numcomp = target.getComponentCount();
        int x = insets.left + this.hgap;
        int y = 0;
        int colw = 0;
        int start = 0;
        for (int i = 0; i < numcomp; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getPreferredSize();
            if (this.fillHeight && i == numcomp - 1) {
                d.height = Math.max(maxheight - y, m.getPreferredSize().height);
            }
            if (this.fillWidth) {
                m.setSize(maxwidth, d.height);
                d.width = maxwidth;
            } else {
                m.setSize(d.width, d.height);
            }
            if (y + d.height > maxheight) {
                return;
            }
            if (y > 0) {
                y += this.vgap;
            }
            y += d.height;
            colw = Math.max(colw, d.width);
        }
        this.layoutComponents(target, x, insets.top + this.vgap, colw, maxheight - y, start, numcomp);
    }

    static {
        TOP = 0;
        MIDDLE = 1;
        BOTTOM = 2;
        LEFT = 0;
        RIGHT = 2;
    }
}

