/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.DBListModel;
import com.borland.dbswing.Res;
import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.dataset.ValidationException;
import com.borland.dx.dataset.Variant;
import javax.swing.ComboBoxModel;
import javax.swing.JOptionPane;

class DBNavComboBoxModel
extends DBListModel
implements ComboBoxModel,
NavigationListener {
    private boolean ignoreValueChange;
    private boolean ignoreNavigation;
    private int selectedIndex = -1;
    private Object selectedItem;
    private DataRow locateRow;
    private boolean dataSetEventsEnabled = true;

    public DBNavComboBoxModel() {
    }

    public DBNavComboBoxModel(DataSet dataSet, String columnName) {
        super(dataSet, columnName);
    }

    public void setDataSet(DataSet dataSet) {
        if (this.columnAwareSupport.dataSet != null) {
            this.columnAwareSupport.dataSet.removeNavigationListener((NavigationListener)this);
        }
        super.setDataSet(dataSet);
        if (dataSet != null) {
            dataSet.addNavigationListener((NavigationListener)this);
        }
    }

    public void setSelectedItem(Object selectedItem) {
        if (!this.ignoreValueChange) {
            this.selectedItem = selectedItem;
            this.selectedIndex = -1;
            this.columnAwareSupport.lazyOpen();
            if (selectedItem != null && this.columnAwareSupport.isValidDataSetState()) {
                Variant selectedVariantItem = null;
                if (selectedItem instanceof Variant) {
                    selectedVariantItem = (Variant)selectedItem;
                } else {
                    Variant variant = new Variant();
                    try {
                        variant.setAsObject(selectedItem, this.columnAwareSupport.getColumn().getDataType());
                    }
                    catch (Exception e) {
                        try {
                            ValidationException.invalidFormat((Exception)e, (String)this.columnAwareSupport.columnName, (String)Res._InvalidSelectedItem);
                        }
                        catch (ValidationException ex) {
                            DBExceptionHandler.handleException(this.columnAwareSupport.dataSet, (Exception)((Object)ex));
                            return;
                        }
                    }
                    selectedVariantItem = variant;
                }
                try {
                    if (this.locateRow == null) {
                        this.locateRow = new DataRow(this.columnAwareSupport.dataSet, this.getColumnName());
                    }
                    this.locateRow.setVariant(this.getColumnName(), selectedVariantItem);
                    this.ignoreNavigation = true;
                    if (!this.columnAwareSupport.dataSet.locate((ReadRow)this.locateRow, 32)) {
                        this.ignoreNavigation = false;
                        this.selectedIndex = -1;
                        JOptionPane.showMessageDialog(null, Res._NavLocateFailed, null, 1);
                        return;
                    }
                    this.ignoreNavigation = false;
                    this.selectedIndex = this.columnAwareSupport.dataSet.getRow();
                }
                catch (DataSetException e) {
                    DBExceptionHandler.handleException(this.columnAwareSupport.dataSet, (Exception)((Object)e));
                }
            }
            this.ignoreValueChange = true;
            this.fireContentsChanged(this, -1, -1);
            this.ignoreValueChange = false;
        }
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedIndex(int selectedIndex) {
        if (!this.ignoreValueChange) {
            this.selectedItem = null;
            this.selectedIndex = selectedIndex;
            this.columnAwareSupport.lazyOpen();
            if (this.columnAwareSupport.isValidDataSetState()) {
                try {
                    try {
                        this.ignoreNavigation = true;
                        if (!this.columnAwareSupport.dataSet.goToRow(selectedIndex)) {
                            this.ignoreNavigation = false;
                            this.selectedIndex = -1;
                            JOptionPane.showMessageDialog(null, Res._NavMoveFailed, null, 1);
                            Object var4_2 = null;
                            this.ignoreNavigation = false;
                            return;
                        }
                        Object var4_3 = null;
                        this.ignoreNavigation = false;
                    }
                    catch (DataSetException e) {
                        this.selectedIndex = -1;
                        DBExceptionHandler.handleException(this.columnAwareSupport.dataSet, (Exception)((Object)e));
                        Object var4_4 = null;
                        this.ignoreNavigation = false;
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.ignoreNavigation = false;
                    throw throwable;
                }
                this.selectedItem = this.getElementAt(selectedIndex);
            }
            this.ignoreValueChange = true;
            this.fireContentsChanged(this, -1, -1);
            this.ignoreValueChange = false;
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void navigated(NavigationEvent event) {
        if (!this.dataSetEventsEnabled) {
            return;
        }
        if (!this.ignoreNavigation) {
            this.updateSelectedValue();
        }
    }

    protected void updateSelectedValue() {
        Variant value = new Variant();
        this.columnAwareSupport.dataSet.getVariant(this.getColumnName(), value);
        this.setSelectedItem(value.getAsObject());
    }

    public void accessChange(AccessEvent event) {
        if (event.getID() == 1) {
            this.dataSetEventsEnabled = true;
            this.columnAwareSupport.lazyOpen();
            if (this.columnAwareSupport.isValidDataSetState()) {
                Object oldSelectedItem = this.selectedItem;
                int oldIndex = this.selectedIndex;
                this.setSelectedItem(null);
                this.fireContentsChanged(this, 0, this.getSize() - 1);
                if (oldSelectedItem != null && oldIndex == -1) {
                    this.setSelectedItem(oldSelectedItem);
                } else if (oldSelectedItem == null && oldIndex != -1) {
                    this.setSelectedIndex(oldIndex);
                } else {
                    this.setSelectedIndex(this.columnAwareSupport.dataSet.getRow());
                }
            }
        } else {
            if (event.getReason() == 8) {
                this.dataSetEventsEnabled = false;
                return;
            }
            this.setSelectedItem(null);
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    public void dataChanged(DataChangeEvent event) {
        if (!this.dataSetEventsEnabled) {
            return;
        }
        int currentRow = this.columnAwareSupport.dataSet.getRow();
        int affectedRow = event.getRowAffected();
        this.ignoreValueChange = true;
        if (event.getID() == 1 && currentRow == affectedRow) {
            this.setSelectedItem(null);
        } else {
            super.dataChanged(event);
        }
        this.ignoreValueChange = false;
    }
}

