/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBColumnAwareSupport;
import com.borland.dbswing.DBDataBinder;
import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.DBListModel;
import com.borland.dbswing.DBUtilities;
import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.ColumnPaintListener;
import com.borland.dx.dataset.CustomPaintSite;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import com.borland.dx.dataset.PickListDescriptor;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.dataset.ReadWriteRow;
import com.borland.dx.dataset.Variant;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;

public class JdbList
extends JList
implements ListSelectionListener,
AccessListener,
NavigationListener,
DataChangeListener,
PropertyChangeListener,
DBDataBinder,
ColumnAware,
Serializable,
FocusListener {
    private DBListModel dbListModel;
    private DataSetView pickListView;
    private String[] sourceColumns;
    private String[] targetColumns;
    private DBColumnAwareSupport columnAwareSupport = new DBColumnAwareSupport(this);
    private int mode = 0;
    private boolean ignoreValueChange;
    private boolean ignoreModelChange;
    private DataRow locateRow;
    private Object[] items;
    private boolean rebindColumnProperties;
    private boolean rebuildPickListView = true;
    private boolean dataSetEventsEnabled = true;

    public JdbList() {
        this.commonInit();
    }

    public JdbList(ListModel dataModel) {
        super(dataModel);
        this.commonInit();
    }

    public JdbList(Object[] listData) {
        super(listData);
        this.commonInit();
    }

    public JdbList(Vector listData) {
        super(listData);
        this.commonInit();
    }

    protected void commonInit() {
        this.setSelectionMode(0);
        this.setCellRenderer(new DBCellRenderer());
        this.addPropertyChangeListener(this);
    }

    public synchronized void setItems(String[] items) {
        this.setItems((Object[])items);
    }

    public synchronized void setItems(Object[] items) {
        this.items = items;
        if (items == null || items.length == 0) {
            this.setListData(new Object[0]);
        } else {
            this.setListData(items);
        }
    }

    public synchronized String[] getItems() {
        if (this.items == null) {
            return new String[0];
        }
        String[] stringifiedItems = new String[this.getModel().getSize()];
        for (int i = 0; i < stringifiedItems.length; ++i) {
            Object element = this.getModel().getElementAt(i);
            stringifiedItems[i] = element == null ? "" : element.toString();
        }
        return stringifiedItems;
    }

    public void setDataSet(DataSet dataSet) {
        if (this.columnAwareSupport.dataSet != null) {
            this.columnAwareSupport.dataSet.removeNavigationListener((NavigationListener)this);
            this.getSelectionModel().removeListSelectionListener(this);
            this.removeFocusListener(this);
        }
        this.columnAwareSupport.setDataSet(dataSet);
        if (dataSet != null) {
            this.columnAwareSupport.dataSet.addNavigationListener((NavigationListener)this);
            this.getSelectionModel().addListSelectionListener(this);
            this.addFocusListener(this);
        }
        this.bindColumnProperties();
    }

    public DataSet getDataSet() {
        return this.columnAwareSupport.dataSet;
    }

    public void setColumnName(String columnName) {
        this.columnAwareSupport.setColumnName(columnName);
        this.bindColumnProperties();
    }

    public String getColumnName() {
        return this.columnAwareSupport.columnName;
    }

    public void setUnknownDataValueMode(int mode) {
        this.mode = mode;
    }

    public int getUnknownDataValueMode() {
        return this.mode;
    }

    public void valueChanged(ListSelectionEvent e) {
        int index;
        if (!this.ignoreValueChange && !e.getValueIsAdjusting() && (index = this.getSelectedIndex()) > -1 && index < this.getModel().getSize()) {
            this.columnAwareSupport.lazyOpen();
            if (this.columnAwareSupport.isValidDataSetState() && this.columnAwareSupport.getColumn().isEditable()) {
                if (this.items == null && this.pickListView != null) {
                    try {
                        this.pickListView.goToRow(index);
                        ReadRow.copyTo((String[])this.sourceColumns, (ReadRow)this.pickListView, (String[])this.targetColumns, (ReadWriteRow)this.columnAwareSupport.dataSet);
                    }
                    catch (DataSetException x) {
                        DBExceptionHandler.handleException((DataSet)this.pickListView, this, (Exception)((Object)x));
                    }
                } else {
                    this.columnAwareSupport.setObject(this.getModel().getElementAt(index));
                }
            }
        }
    }

    public void navigated(NavigationEvent event) {
        if (!this.dataSetEventsEnabled) {
            return;
        }
        this.updateSelectedListValue();
    }

    private void updateSelectedListValue() {
        int newIndex = -1;
        if (this.items == null && this.pickListView != null) {
            try {
                if (this.locateRow == null) {
                    this.locateRow = new DataRow((DataSet)this.pickListView, this.sourceColumns);
                }
                ReadRow.copyTo((String[])this.targetColumns, (ReadRow)this.columnAwareSupport.dataSet, (String[])this.sourceColumns, (ReadWriteRow)this.locateRow);
                if (this.pickListView.locate((ReadRow)this.locateRow, 32)) {
                    newIndex = this.pickListView.getRow();
                }
            }
            catch (DataSetException e) {
                DBExceptionHandler.handleException((DataSet)this.pickListView, this, (Exception)((Object)e));
            }
        } else {
            int lastRow = this.getModel().getSize();
            Object locateValue = this.columnAwareSupport.getVariant().getAsObject();
            for (int index = 0; index < lastRow; ++index) {
                if (!this.getModel().getElementAt(index).equals(locateValue)) continue;
                newIndex = index;
                break;
            }
        }
        this.ignoreValueChange = true;
        if (newIndex == -1) {
            if (this.mode == 2 && !this.columnAwareSupport.isNull()) {
                this.columnAwareSupport.lazyOpen();
                this.columnAwareSupport.resetValue();
            } else if (this.mode == 1) {
                this.setEnabled(false);
            } else {
                this.getSelectionModel().clearSelection();
            }
        } else {
            if (this.mode == 1 && !this.isEnabled()) {
                this.setEnabled(true);
            }
            this.getSelectionModel().setSelectionInterval(newIndex, newIndex);
            this.ensureIndexIsVisible(newIndex);
        }
        this.ignoreValueChange = false;
    }

    public void dataChanged(DataChangeEvent event) {
        boolean affectedOurRow;
        if (!this.dataSetEventsEnabled) {
            return;
        }
        int affectedRow = event.getRowAffected();
        boolean bl = affectedOurRow = affectedRow == this.columnAwareSupport.dataSet.getRow() || affectedRow == -1;
        if (affectedOurRow) {
            this.updateSelectedListValue();
        }
    }

    public void postRow(DataChangeEvent event) throws Exception {
    }

    public void accessChange(AccessEvent event) {
        if (event.getSource() == this.columnAwareSupport.getDataSet()) {
            if (event.getID() == 2) {
                if (event.getReason() == 8) {
                    this.dataSetEventsEnabled = false;
                    return;
                }
                this.getSelectionModel().clearSelection();
                if (event.getReason() == 9) {
                    this.rebindColumnProperties = true;
                }
            } else {
                this.dataSetEventsEnabled = true;
                if (event.getReason() == 1 || this.rebindColumnProperties || event.getReason() == 2) {
                    this.bindColumnProperties();
                }
            }
        } else if (event.getSource() == this.pickListView) {
            if (event.getID() == 2) {
                this.rebuildPickListView = true;
                if (event.getReason() == 9) {
                    this.rebuildPickListView = false;
                }
            } else if (this.rebuildPickListView) {
                this.rebuildPickListView = false;
                this.setPickListModel(this.pickListView);
            }
        }
    }

    private void setPrototype(int charWidth) {
        StringBuffer sb = new StringBuffer(charWidth);
        for (int index = 0; index < charWidth; ++index) {
            sb.append('M');
        }
        this.setPrototypeCellValue(sb.toString());
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("ancestor")) {
            this.bindColumnProperties();
        } else if (e.getPropertyName().equals("selectionModel")) {
            if (e.getOldValue() != null) {
                ((ListSelectionModel)e.getOldValue()).removeListSelectionListener(this);
            }
            if (e.getNewValue() != null) {
                ((ListSelectionModel)e.getNewValue()).addListSelectionListener(this);
            }
        } else if (e.getPropertyName().equals("model") && !this.ignoreModelChange) {
            this.setPickListModel(null);
        }
    }

    private boolean isDefaultProperty(Object property) {
        return property == null || property instanceof UIResource;
    }

    private void bindColumnProperties() {
        if (this.isDisplayable()) {
            this.rebindColumnProperties = false;
            this.columnAwareSupport.lazyOpen();
            if (this.columnAwareSupport.isValidDataSetState()) {
                DataSet pickListDataSet;
                PickListDescriptor pickList;
                Column column = this.columnAwareSupport.getColumn();
                if (this.isDefaultProperty(this.getBackground()) && column.getBackground() != null) {
                    this.setBackground(column.getBackground());
                }
                if (this.isDefaultProperty(this.getForeground()) && column.getForeground() != null) {
                    this.setForeground(column.getForeground());
                }
                if (this.isDefaultProperty(this.getFont()) && column.getFont() != null) {
                    this.setFont(column.getFont());
                }
                if (column.getItemPainter() instanceof ListCellRenderer) {
                    this.setCellRenderer((ListCellRenderer)column.getItemPainter());
                }
                if (this.items == null && (pickList = this.columnAwareSupport.getColumn().getPickList()) != null && (pickListDataSet = pickList.getPickListDataSet()) != null) {
                    try {
                        if (!pickListDataSet.isOpen()) {
                            pickListDataSet.open();
                        }
                        this.setPickListModel(pickListDataSet.cloneDataSetView());
                    }
                    catch (DataSetException e) {
                        DBExceptionHandler.handleException(pickListDataSet, this, (Exception)((Object)e));
                        this.setPickListModel(null);
                    }
                }
                if (this.isEnabled()) {
                    this.setEnabled(column.isEditable());
                }
                this.updateSelectedListValue();
            }
        }
    }

    private void setPickListModel(DataSetView pickListView) {
        block10: {
            Column column;
            PickListDescriptor pickList;
            if (this.pickListView != null) {
                this.pickListView.removeAccessListener((AccessListener)this);
                if (this.pickListView != pickListView) {
                    try {
                        this.pickListView.close();
                        this.locateRow = null;
                    }
                    catch (DataSetException e) {
                        DBExceptionHandler.handleException((DataSet)this.pickListView, this, (Exception)((Object)e));
                    }
                }
                if (this.dbListModel != null) {
                    this.dbListModel.setDataSet(null);
                    this.dbListModel.setColumnName(null);
                }
            }
            this.pickListView = pickListView;
            if (!this.columnAwareSupport.isValidDataSetState() || (pickList = this.columnAwareSupport.getColumn().getPickList()) == null || pickListView == null) break block10;
            pickListView.addAccessListener((AccessListener)this);
            if (this.dbListModel == null) {
                this.dbListModel = new DBListModel();
            }
            this.dbListModel.setDataSet((DataSet)pickListView);
            String[] displayColumns = pickList.getPickListDisplayColumns();
            this.sourceColumns = pickList.getPickListColumns();
            this.targetColumns = pickList.getDestinationColumns();
            if (displayColumns.length > 0) {
                this.dbListModel.setColumnName(displayColumns[0]);
            } else if (this.sourceColumns.length > 0) {
                this.dbListModel.setColumnName(this.sourceColumns[0]);
            }
            if (this.dbListModel.getColumnName() != null && (column = pickListView.hasColumn(this.dbListModel.getColumnName())) != null) {
                this.setPrototype(column.getWidth());
            }
            this.ignoreModelChange = true;
            this.setModel(this.dbListModel);
            this.ignoreModelChange = false;
        }
    }

    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        if (ps == null || ps.width < 5 || ps.height < 5) {
            ps = ps != null ? ps : new Dimension(100, 100);
            ps.width = ps.width > 100 ? ps.width : 100;
            ps.height = ps.height > 100 ? ps.height : 100;
        }
        return ps;
    }

    public void focusGained(FocusEvent e) {
        DBUtilities.updateCurrentDataSet(this, this.columnAwareSupport.dataSet);
    }

    public void focusLost(FocusEvent e) {
    }

    public static class DBCellRenderer
    extends JLabel
    implements ListCellRenderer,
    CustomPaintSite,
    Serializable {
        private int alignment;
        private Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private int defaultAlignment;
        private Color defaultForeground;
        private Color defaultBackground;
        private Font defaultFont;
        private Border defaultBorder;

        public DBCellRenderer() {
            this.setOpaque(true);
            this.setBorder(this.noFocusBorder);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setDefaultForeground(list.getSelectionForeground());
                this.setDefaultBackground(list.getSelectionBackground());
            } else {
                this.setDefaultForeground(list.getForeground());
                this.setDefaultBackground(list.getBackground());
            }
            this.setDefaultFont(list.getFont());
            this.setDefaultBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : this.noFocusBorder);
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
            } else if (list.getModel() instanceof DBListModel) {
                DBListModel listModel = (DBListModel)list.getModel();
                Variant variantValue = listModel.getVariantElementAt(index);
                if (variantValue != null) {
                    Variant variantCopy = (Variant)variantValue.clone();
                    this.setDefaultAlignment(listModel.columnAwareSupport.getColumn().getAlignment());
                    this.setText(listModel.columnAwareSupport.getColumn().format(variantValue));
                    ColumnPaintListener columnPaintListener = listModel.columnAwareSupport.getColumn().getColumnPaintListener();
                    if (columnPaintListener != null) {
                        columnPaintListener.painting(listModel.getDataSet(), listModel.columnAwareSupport.getColumn(), index, variantValue, (CustomPaintSite)this);
                        if (!variantValue.equals(variantCopy)) {
                            this.setText(listModel.columnAwareSupport.getColumn().format(variantValue));
                        }
                        if (isSelected) {
                            this.setForeground(list.getSelectionForeground());
                            this.setBackground(list.getSelectionBackground());
                        }
                    }
                }
            } else {
                this.setText(value == null ? "" : value.toString());
            }
            this.setEnabled(list.isEnabled());
            return this;
        }

        public void setDefaultForeground(Color foreground) {
            this.defaultForeground = foreground;
            this.setForeground(foreground);
        }

        public void setDefaultBackground(Color background) {
            this.defaultBackground = background;
            this.setBackground(background);
        }

        public void setDefaultAlignment(int alignment) {
            this.defaultAlignment = alignment;
            this.convertAlignment(alignment);
        }

        private void convertAlignment(int alignment) {
            this.setHorizontalAlignment(DBUtilities.convertJBCLToSwingAlignment(alignment, true));
            this.setVerticalAlignment(DBUtilities.convertJBCLToSwingAlignment(alignment, false));
        }

        public void setDefaultFont(Font font) {
            this.defaultFont = font;
            this.setFont(font);
        }

        public void setDefaultBorder(Border border) {
            this.defaultBorder = border;
            this.setBorder(border);
        }

        public void reset() {
            this.setForeground(this.defaultForeground);
            this.setBackground(this.defaultBackground);
            this.setFont(this.defaultFont);
            this.convertAlignment(this.defaultAlignment);
            this.setBorder(this.defaultBorder);
        }

        public void setAlignment(int alignment) {
            this.alignment = alignment;
            this.convertAlignment(alignment);
        }

        public void setItemMargins(Insets margins) {
            this.setBorder(new EmptyBorder(margins));
        }

        public boolean isTransparent() {
            return false;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public Insets getItemMargins() {
            return this.getBorder().getBorderInsets(this);
        }

        public Component getSiteComponent() {
            return this;
        }
    }
}

