/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class RepeatButton
extends JButton
implements PropertyChangeListener,
FocusListener,
ActionListener,
Serializable {
    private boolean defaultButton;
    private String textWithMnemonic;
    private boolean alreadyRootPaneListener = false;
    private JButton focusEventSource = null;
    private boolean repeat = true;
    private int repeatDelay = 200;
    private int initialDelay = 400;
    private Timer repeatTimer;
    private boolean mouseOverButton = true;

    public RepeatButton() {
        this(null, null);
    }

    public RepeatButton(Icon icon) {
        this(null, icon);
    }

    public RepeatButton(String text) {
        this(text, null);
    }

    public RepeatButton(String text, Icon icon) {
        super(DBUtilities.excludeMnemonicSymbol(text), icon);
        if (DBUtilities.containsMnemonic(text)) {
            this.setTextWithMnemonic(text);
        }
    }

    public void setDefaultButton(boolean defaultButton) {
        boolean oldDefaultButton = this.defaultButton;
        if (oldDefaultButton != defaultButton) {
            this.defaultButton = defaultButton;
            this.makeDefaultButton();
            this.firePropertyChange("defaultButton", oldDefaultButton, defaultButton);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.makeDefaultButton();
    }

    private void makeDefaultButton() {
        JRootPane rootPane = SwingUtilities.getRootPane(this);
        if (rootPane != null && this.defaultButton && !this.alreadyRootPaneListener) {
            this.alreadyRootPaneListener = true;
            rootPane.addPropertyChangeListener(this);
        }
        if (this.alreadyRootPaneListener) {
            if (this.defaultButton) {
                if (!this.isDefaultCapable()) {
                    this.setDefaultCapable(true);
                }
                rootPane.setDefaultButton(this);
            } else if (rootPane.getDefaultButton() == this) {
                rootPane.setDefaultButton(null);
            }
        }
        if (!this.defaultButton && this.alreadyRootPaneListener) {
            if (this.focusEventSource != null) {
                this.focusEventSource.removeFocusListener(this);
                this.focusEventSource = null;
            }
            this.alreadyRootPaneListener = false;
            rootPane.removePropertyChangeListener(this);
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.makeDefaultButton();
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("defaultButton")) {
            JButton newDefaultButton = (JButton)e.getNewValue();
            JButton oldDefaultButton = (JButton)e.getOldValue();
            if (oldDefaultButton != null) {
                oldDefaultButton.removeFocusListener(this);
            }
            if (newDefaultButton != null) {
                newDefaultButton.addFocusListener(this);
                this.focusEventSource = newDefaultButton;
            }
        }
    }

    public void setTextWithMnemonic(String text) {
        String oldText = this.textWithMnemonic;
        if (oldText != text) {
            this.textWithMnemonic = text;
            this.setText(DBUtilities.excludeMnemonicSymbol(text));
            this.setMnemonic(DBUtilities.extractMnemonicChar(text));
            this.firePropertyChange("textWithMnemonic", oldText, text);
        }
    }

    public String getTextWithMnemonic() {
        return this.textWithMnemonic;
    }

    public void setRepeat(boolean repeat) {
        boolean oldRepeat = this.repeat;
        if (oldRepeat != repeat) {
            this.repeat = repeat;
            if (this.repeatTimer != null) {
                this.repeatTimer.stop();
            }
            this.firePropertyChange("repeat", oldRepeat, repeat);
        }
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public void setRepeatDelay(int repeatDelay) {
        int oldDelay = this.repeatDelay;
        this.repeatDelay = repeatDelay;
        if (this.repeatTimer != null) {
            this.repeatTimer.setDelay(repeatDelay);
        }
        this.firePropertyChange("repeatDelay", oldDelay, repeatDelay);
    }

    public int getRepeatDelay() {
        return this.repeatDelay;
    }

    public void setInitialDelay(int initialDelay) {
        int oldDelay = this.initialDelay;
        this.initialDelay = initialDelay;
        if (this.repeatTimer != null) {
            this.repeatTimer.setInitialDelay(initialDelay);
        }
        this.firePropertyChange("initialDelay", oldDelay, initialDelay);
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    protected void processMouseEvent(MouseEvent e) {
        if (this.repeat) {
            if (this.repeatTimer == null) {
                this.repeatTimer = new Timer(this.repeatDelay, this);
                this.repeatTimer.setInitialDelay(this.initialDelay);
            }
            int id = e.getID();
            switch (id) {
                case 501: {
                    this.mouseOverButton = true;
                    this.repeatTimer.stop();
                    this.repeatTimer.start();
                    break;
                }
                case 502: {
                    this.repeatTimer.stop();
                    break;
                }
                case 504: {
                    this.mouseOverButton = true;
                    break;
                }
                case 505: {
                    this.mouseOverButton = false;
                }
            }
        }
        super.processMouseEvent(e);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.mouseOverButton) {
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }
    }
}

