/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;

public class TextIcon
extends Component
implements Icon {
    private String text;
    private int horizontalAlignment = 2;
    private int verticalAlignment = 0;
    private Insets margins = new Insets(0, 0, 0, 0);
    private Dimension size = new Dimension();
    private Font font;
    private int iconWidth;
    private int iconHeight;
    private boolean update;

    public TextIcon() {
    }

    public TextIcon(String text) {
        this.setText(text);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.updateMetrics();
        Font oldFont = g.getFont();
        Color oldColor = g.getColor();
        g.setFont(this.getFont());
        FontMetrics fm = g.getFontMetrics(this.getFont());
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        g.setColor(c.getBackground());
        g.fillRect(0, 0, width, height);
        if (this.text != null && this.text.length() > 0) {
            int xOffset;
            switch (this.horizontalAlignment) {
                default: {
                    xOffset = this.margins.left;
                    break;
                }
                case 0: {
                    xOffset = (width - fm.stringWidth(this.text)) / 2;
                    break;
                }
                case 4: {
                    xOffset = width - fm.stringWidth(this.text) - this.margins.right;
                }
            }
            switch (this.verticalAlignment) {
                default: {
                    int yOffset = this.margins.top;
                    break;
                }
                case 0: {
                    int yOffset = (height - fm.getHeight()) / 2;
                    break;
                }
                case 3: {
                    int yOffset = height - fm.getHeight() - this.margins.bottom;
                }
            }
            g.setColor(c.getForeground());
            g.drawString(this.text, xOffset, yOffset += fm.getLeading() + fm.getAscent());
        }
        g.setFont(oldFont);
        g.setColor(oldColor);
    }

    public int getIconWidth() {
        this.updateMetrics();
        return this.iconWidth;
    }

    public int getIconHeight() {
        this.updateMetrics();
        return this.iconHeight;
    }

    public Font getFont() {
        if (this.font == null) {
            Font f = super.getFont();
            this.font = f == null ? new Font("Dialog", 0, 12) : f;
        }
        return this.font;
    }

    private void updateMetrics() {
        if (this.update) {
            if (this.text == null || this.text.length() == 0) {
                this.iconWidth = this.margins.left + this.margins.right;
                this.iconHeight = this.margins.bottom + this.margins.top;
            } else {
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                this.iconWidth = fontMetrics.stringWidth(this.text) + this.margins.left + this.margins.right;
                this.iconHeight = fontMetrics.getHeight() + this.margins.bottom + this.margins.top;
            }
            this.update = false;
        }
    }

    public Dimension getPreferredSize() {
        this.size.height = this.getIconHeight();
        this.size.width = this.getIconWidth();
        return this.size;
    }

    public Dimension getSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics g) {
        this.paintIcon(this, g, 0, 0);
    }

    public void setText(String text) {
        this.text = text;
        this.update = true;
    }

    public String getText() {
        return this.text;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setMargins(Insets margins) {
        this.margins = margins;
    }

    public Insets getMargins() {
        return this.margins;
    }
}

