/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing.plaf.basic;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class BasicJdbComboBoxEditor
implements ComboBoxEditor,
FocusListener,
Serializable {
    protected ComboBoxTextField editor;
    protected JComboBox comboBox;

    public BasicJdbComboBoxEditor(JComboBox comboBox) {
        this(comboBox, null);
    }

    public BasicJdbComboBoxEditor(JComboBox comboBox, Border border) {
        this.comboBox = comboBox;
        this.editor = new ComboBoxTextField(this, "", 9, comboBox);
        this.editor.addFocusListener(this);
        if (border != null) {
            this.editor.setBorder(border);
        }
    }

    public Component getEditorComponent() {
        return this.editor;
    }

    public void setItem(Object anObject) {
        if (anObject != null) {
            this.editor.setText(anObject.toString());
        } else {
            this.editor.setText("");
        }
    }

    public Object getItem() {
        return this.editor.getText();
    }

    public int getIndex() {
        return this.editor.getIndex();
    }

    public void selectAll() {
        this.editor.selectAll();
        this.editor.requestFocus();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (!e.isTemporary()) {
            this.editor.postActionEvent();
        }
    }

    public void addActionListener(ActionListener l) {
        this.editor.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.editor.removeActionListener(l);
    }

    class BasicComboBoxDocument
    extends PlainDocument
    implements PropertyChangeListener {
        protected JComboBox comboBox;
        protected ComboBoxModel comboBoxModel;
        protected int lastIndex = 0;
        protected JTextField textField;

        public BasicComboBoxDocument(BasicJdbComboBoxEditor this$0, JComboBox comboBox, JTextField textField) {
            this.comboBox = comboBox;
            comboBox.addPropertyChangeListener(this);
            this.textField = textField;
            this.comboBoxModel = comboBox.getModel();
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("model")) {
                this.comboBoxModel = (ComboBoxModel)e.getNewValue();
            }
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            super.insertString(offs, str, a);
            String searchText = this.getText(0, this.getLength());
            int size = this.comboBoxModel.getSize();
            for (int i = 0; i < size; ++i) {
                String value = this.comboBoxModel.getElementAt(i).toString();
                if (!value.toUpperCase().startsWith(searchText.toUpperCase())) continue;
                this.remove(0, this.getLength());
                super.insertString(0, value, null);
                this.textField.setCaretPosition(searchText.length());
                this.textField.moveCaretPosition(this.getLength());
                this.lastIndex = i;
                return;
            }
        }

        public int getIndex() {
            return this.lastIndex;
        }
    }

    class ComboBoxTextField
    extends JTextField {
        private BasicComboBoxDocument document;

        public ComboBoxTextField(BasicJdbComboBoxEditor this$0, String value, int n, JComboBox comboBox) {
            super(value, n);
            super.setBorder(null);
            BasicJdbComboBoxEditor basicJdbComboBoxEditor = this$0;
            basicJdbComboBoxEditor.getClass();
            this.document = new BasicComboBoxDocument(basicJdbComboBoxEditor, comboBox, this);
            this.setDocument(this.document);
        }

        public int getIndex() {
            return this.document.getIndex();
        }
    }
}

