/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing.plaf.basic;

import com.borland.dbswing.TableScrollPane;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.Timer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class BasicJdbTableScrollBarUI
extends BasicScrollBarUI {
    private int speedUpCounter1 = 1;
    private int speedUpCounter2 = 1;
    private TableScrollPane.TableScrollBar tableScrollBar;
    private TableScrollPane tableScrollPane;

    public static ComponentUI createUI(JComponent c) {
        return new BasicJdbTableScrollBarUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.tableScrollBar = (TableScrollPane.TableScrollBar)c;
    }

    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new TableTrackListener();
    }

    protected BasicScrollBarUI.ScrollListener createScrollListener() {
        return new TableScrollListener();
    }

    protected BasicScrollBarUI.ArrowButtonListener createArrowButtonListener() {
        return new TableArrowButtonListener();
    }

    protected boolean isDragging() {
        return this.isDragging;
    }

    protected JScrollBar getScrollBar() {
        return this.scrollbar;
    }

    protected void setThumbBounds(int x, int y, int width, int height) {
        super.setThumbBounds(x, y, width, height);
    }

    protected Rectangle getThumbBounds() {
        return this.thumbRect;
    }

    protected JButton getDecrButton() {
        return this.decrButton;
    }

    protected JButton getIncrButton() {
        return this.incrButton;
    }

    protected Rectangle getTrackBounds() {
        return this.trackRect;
    }

    protected void scrollByUnit(int direction) {
        JScrollBar jScrollBar = this.scrollbar;
        synchronized (jScrollBar) {
            int delta = direction > 0 ? this.scrollbar.getUnitIncrement(direction) : -this.scrollbar.getUnitIncrement(direction);
            int newValue = delta + this.scrollbar.getValue();
            if (delta != 0) {
                newValue -= newValue % delta;
            }
            this.scrollbar.setValue(newValue);
        }
    }

    protected void scrollByBlock(int direction) {
        JScrollBar jScrollBar = this.scrollbar;
        synchronized (jScrollBar) {
            int oldValue = this.scrollbar.getValue();
            int blockIncrement = this.scrollbar.getBlockIncrement(direction);
            int delta = blockIncrement * (direction > 0 ? 1 : -1);
            int newValue = oldValue + delta;
            if (this.scrollbar.getUnitIncrement(direction) != 0) {
                newValue -= newValue % this.scrollbar.getUnitIncrement(direction);
            }
            this.scrollbar.setValue(newValue);
            this.trackHighlight = direction > 0 ? 2 : 1;
            Rectangle dirtyRect = this.getTrackBounds();
            this.scrollbar.repaint(dirtyRect.x, dirtyRect.y, dirtyRect.width, dirtyRect.height);
        }
    }

    protected BasicScrollBarUI.TrackListener getTrackListener() {
        return this.trackListener;
    }

    protected class TableArrowButtonListener
    extends BasicScrollBarUI.ArrowButtonListener {
        protected TableArrowButtonListener() {
            super(BasicJdbTableScrollBarUI.this);
        }

        public void mouseReleased(MouseEvent e) {
            BasicJdbTableScrollBarUI.this.speedUpCounter1 = 1;
            BasicJdbTableScrollBarUI.this.speedUpCounter2 = 1;
            super.mouseReleased(e);
        }
    }

    protected class TableScrollListener
    extends BasicScrollBarUI.ScrollListener {
        protected int direction = 1;
        protected boolean useBlockIncrement;

        public TableScrollListener() {
            this(1, false);
        }

        public TableScrollListener(int dir, boolean block) {
            super(BasicJdbTableScrollBarUI.this);
            this.direction = dir;
            this.useBlockIncrement = block;
        }

        public void setDirection(int direction) {
            this.direction = direction;
        }

        public int getDirection() {
            return this.direction;
        }

        public void setScrollByBlock(boolean block) {
            this.useBlockIncrement = block;
        }

        public boolean isScrollByBlock() {
            return this.useBlockIncrement;
        }

        public void actionPerformed(ActionEvent e) {
            if (BasicJdbTableScrollBarUI.this.tableScrollBar.isAutoScrollSpeedUp()) {
                int sum = BasicJdbTableScrollBarUI.this.speedUpCounter1 + BasicJdbTableScrollBarUI.this.speedUpCounter2;
                BasicJdbTableScrollBarUI.this.speedUpCounter1 = BasicJdbTableScrollBarUI.this.speedUpCounter2;
                BasicJdbTableScrollBarUI.this.speedUpCounter2 = sum;
            }
            for (int i = 0; i < BasicJdbTableScrollBarUI.this.speedUpCounter1; ++i) {
                if (this.isScrollByBlock()) {
                    BasicJdbTableScrollBarUI.this.scrollByBlock(this.direction);
                    if (BasicJdbTableScrollBarUI.this.getScrollBar().getOrientation() == 1) {
                        if (this.direction > 0) {
                            if (BasicJdbTableScrollBarUI.this.getThumbBounds().y + BasicJdbTableScrollBarUI.this.getThumbBounds().height >= ((TableTrackListener)BasicJdbTableScrollBarUI.this.getTrackListener()).getCurrentMouseY()) {
                                ((Timer)e.getSource()).stop();
                                break;
                            }
                        } else if (BasicJdbTableScrollBarUI.this.getThumbBounds().y <= ((TableTrackListener)BasicJdbTableScrollBarUI.this.getTrackListener()).getCurrentMouseY()) {
                            ((Timer)e.getSource()).stop();
                            break;
                        }
                    } else if (this.direction > 0) {
                        if (BasicJdbTableScrollBarUI.this.getThumbBounds().x + BasicJdbTableScrollBarUI.this.getThumbBounds().width >= ((TableTrackListener)BasicJdbTableScrollBarUI.this.getTrackListener()).getCurrentMouseX()) {
                            ((Timer)e.getSource()).stop();
                            break;
                        }
                    } else if (BasicJdbTableScrollBarUI.this.getThumbBounds().x <= ((TableTrackListener)BasicJdbTableScrollBarUI.this.getTrackListener()).getCurrentMouseX()) {
                        ((Timer)e.getSource()).stop();
                        break;
                    }
                } else {
                    BasicJdbTableScrollBarUI.this.scrollByUnit(this.direction);
                }
                if (this.direction > 0 && BasicJdbTableScrollBarUI.this.getScrollBar().getValue() + BasicJdbTableScrollBarUI.this.getScrollBar().getVisibleAmount() >= BasicJdbTableScrollBarUI.this.getScrollBar().getMaximum()) {
                    ((Timer)e.getSource()).stop();
                    break;
                }
                if (this.direction >= 0 || BasicJdbTableScrollBarUI.this.getScrollBar().getValue() > BasicJdbTableScrollBarUI.this.getScrollBar().getMinimum()) continue;
                ((Timer)e.getSource()).stop();
                break;
            }
        }
    }

    protected class TableTrackListener
    extends BasicScrollBarUI.TrackListener {
        int lastDraggedY;

        protected TableTrackListener() {
            super(BasicJdbTableScrollBarUI.this);
        }

        public int getCurrentMouseY() {
            return this.currentMouseY;
        }

        public int getCurrentMouseX() {
            return this.currentMouseX;
        }

        public void mouseDragged(MouseEvent e) {
            int thumbPos;
            int thumbMax;
            int thumbMin;
            if (!BasicJdbTableScrollBarUI.this.getScrollBar().isEnabled() || !BasicJdbTableScrollBarUI.this.isDragging()) {
                return;
            }
            BoundedRangeModel model = BasicJdbTableScrollBarUI.this.getScrollBar().getModel();
            Rectangle thumbR = BasicJdbTableScrollBarUI.this.getThumbBounds();
            if (BasicJdbTableScrollBarUI.this.getScrollBar().getOrientation() == 1) {
                thumbMin = BasicJdbTableScrollBarUI.this.getDecrButton().getY() + BasicJdbTableScrollBarUI.this.getDecrButton().getHeight();
                thumbMax = BasicJdbTableScrollBarUI.this.getIncrButton().getY() - BasicJdbTableScrollBarUI.this.getThumbBounds().height;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, e.getY() - this.offset));
                BasicJdbTableScrollBarUI.this.setThumbBounds(thumbR.x, thumbPos, thumbR.width, thumbR.height);
                float trackLength = BasicJdbTableScrollBarUI.this.getTrackBounds().height;
            } else {
                thumbMin = BasicJdbTableScrollBarUI.this.getDecrButton().getX() + BasicJdbTableScrollBarUI.this.getDecrButton().getWidth();
                thumbMax = BasicJdbTableScrollBarUI.this.getIncrButton().getX() - BasicJdbTableScrollBarUI.this.getThumbBounds().width;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, e.getX() - this.offset));
                BasicJdbTableScrollBarUI.this.setThumbBounds(thumbPos, thumbR.y, thumbR.width, thumbR.height);
                float trackLength = BasicJdbTableScrollBarUI.this.getTrackBounds().width;
            }
            if (thumbPos == thumbMax) {
                if (BasicJdbTableScrollBarUI.this.tableScrollBar.isPaintDuringDrag()) {
                    BasicJdbTableScrollBarUI.this.getScrollBar().setValue(model.getMaximum() - model.getExtent());
                } else {
                    this.lastDraggedY = model.getMaximum() - model.getExtent();
                }
            } else {
                float valueMax = model.getMaximum() - model.getExtent();
                float valueRange = valueMax - (float)model.getMinimum();
                float thumbValue = thumbPos - thumbMin;
                float thumbRange = thumbMax - thumbMin;
                this.lastDraggedY = (int)(0.5 + (double)(thumbValue / thumbRange * valueRange));
                if (BasicJdbTableScrollBarUI.this.tableScrollBar.isPaintDuringDrag()) {
                    BasicJdbTableScrollBarUI.this.getScrollBar().setValue(this.lastDraggedY + model.getMinimum());
                } else if (BasicJdbTableScrollBarUI.this.getScrollBar().getUnitIncrement(1) != 0) {
                    this.lastDraggedY -= this.lastDraggedY % BasicJdbTableScrollBarUI.this.getScrollBar().getUnitIncrement(1);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (!BasicJdbTableScrollBarUI.this.getScrollBar().isEnabled()) {
                return;
            }
            if (BasicJdbTableScrollBarUI.this.isDragging() && !BasicJdbTableScrollBarUI.this.tableScrollBar.isPaintDuringDrag()) {
                BasicJdbTableScrollBarUI.this.getScrollBar().setValue(this.lastDraggedY);
            }
            BasicJdbTableScrollBarUI.this.speedUpCounter1 = 1;
            BasicJdbTableScrollBarUI.this.speedUpCounter2 = 1;
            super.mouseReleased(e);
        }
    }
}

