/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBColumnAwareSupport;
import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.DBUtilities;
import com.borland.dbswing.Res;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.Variant;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class DBLabelSupport
extends DBColumnAwareSupport
implements Serializable {
    String columnNameIcon;
    int columnOrdinalIcon = -1;

    public DBLabelSupport(ColumnAware columnAwareObject) {
        super(columnAwareObject);
    }

    public void setColumnNameIcon(String columnNameIcon) {
        if (this.columnNameIcon == null || !this.columnNameIcon.equals(columnNameIcon)) {
            String oldColumnNameIcon = this.columnNameIcon;
            this.columnNameIcon = columnNameIcon;
            this.columnChanged = true;
            if (this.liveProperties) {
                this.lazyOpen();
            }
        }
    }

    public String getColumnNameIcon() {
        return this.columnNameIcon;
    }

    protected void lazyOpen() {
        this.liveProperties = true;
        if (this.dataSetChanged || this.columnChanged) {
            if (this.dataSetChanged && this.dataSet != null) {
                try {
                    if (!this.dataSet.isOpen()) {
                        this.dataSet.open();
                    }
                }
                catch (DataSetException e) {
                    this.columnOrdinal = -1;
                    this.columnOrdinalIcon = -1;
                    this.dataSetChanged = false;
                    DBExceptionHandler.handleException(this.dataSet, (Exception)((Object)e));
                    return;
                }
            }
            if (this.dataSetChanged || this.columnChanged) {
                this.columnOrdinal = -1;
                this.columnOrdinalIcon = -1;
                if (this.dataSet != null) {
                    if (this.columnName != null) {
                        try {
                            this.columnOrdinal = this.dataSet.getColumn(this.columnName).getOrdinal();
                        }
                        catch (DataSetException e) {
                            this.columnChanged = false;
                            DBExceptionHandler.handleException(this.dataSet, (Exception)((Object)e));
                            return;
                        }
                    }
                    if (this.columnNameIcon != null) {
                        try {
                            this.columnOrdinalIcon = this.dataSet.getColumn(this.columnNameIcon).getOrdinal();
                            if (this.dataSet.getColumn(this.columnNameIcon).getDataType() != 12 && this.dataSet.getColumn(this.columnNameIcon).getDataType() != 17) {
                                throw new IllegalArgumentException(Res._InvalidIconColumnType);
                            }
                        }
                        catch (DataSetException e) {
                            this.dataSetChanged = false;
                            DBExceptionHandler.handleException(this.dataSet, (Exception)((Object)e));
                            return;
                        }
                    }
                }
                this.columnChanged = false;
            }
            this.dataSetChanged = false;
        }
    }

    public boolean isValidDataSetState() {
        return this.dataSet != null && this.dataSet.isOpen() && (this.columnOrdinal != -1 || this.columnOrdinalIcon != -1);
    }

    public void putIcon(InputStream inputStream) {
        try {
            if (this.isValidDataSetState() && this.columnOrdinalIcon != -1) {
                this.dataSet.setInputStream(this.columnOrdinalIcon, (InputStream)new ByteArrayInputStream(DBUtilities.getByteArrayFromStream(inputStream)));
            }
        }
        catch (DataSetException e) {
            DBExceptionHandler.handleException(this.dataSet, (Exception)((Object)e));
        }
    }

    public Icon getIcon() {
        try {
            if (this.isValidDataSetState() && this.columnOrdinalIcon != -1) {
                Variant v = new Variant();
                this.dataSet.getVariant(this.columnNameIcon, v);
                if (v.getType() == 12) {
                    InputStream inputStream = v.getInputStream();
                    inputStream.reset();
                    Image bmpImage = DBUtilities.makeBMPImage(inputStream);
                    if (bmpImage != null) {
                        ImageIcon imageIcon = new ImageIcon(bmpImage);
                        return imageIcon;
                    }
                    byte[] bytes = DBUtilities.getByteArrayFromStream(inputStream);
                    if (bytes == null) {
                        Icon icon = null;
                        return icon;
                    }
                    ImageIcon imageIcon = new ImageIcon(bytes);
                    return imageIcon;
                }
                if (v.getType() == 17) {
                    Object object = v.getObject();
                    if (object instanceof Image) {
                        ImageIcon imageIcon = new ImageIcon((Image)object);
                        return imageIcon;
                    }
                    if (object instanceof Icon) {
                        Icon icon = (Icon)object;
                        return icon;
                    }
                }
            }
        }
        catch (Exception e) {
            DBExceptionHandler.handleException(this.dataSet, e);
        }
        return null;
    }
}

