/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBPasswordDialog;
import com.borland.dbswing.Res;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.sql.dataset.ConnectionDescriptor;
import com.borland.dx.sql.dataset.Database;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;

public class DBPasswordPrompter
implements ActionListener,
Serializable {
    private Frame frame;
    private String title;
    private String userName;
    private String password;
    private Database database;
    private ConnectionDescriptor descriptor;
    private boolean validPassword = false;
    private DBPasswordDialog dialog;
    private boolean promptPasswordState;
    private int maxAttempts = 3;
    private int attempts = 0;
    private boolean userNameRequired = true;
    private boolean passwordRequired = true;

    public DBPasswordPrompter() {
    }

    public DBPasswordPrompter(Frame frame, String title, Database database) {
        this.setFrame(frame);
        this.setTitle(title);
        this.setDatabase(database);
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setUserNameRequired(boolean userNameRequired) {
        this.userNameRequired = userNameRequired;
    }

    public boolean isUserNameRequired() {
        return this.userNameRequired;
    }

    public void setPasswordRequired(boolean passwordRequired) {
        this.passwordRequired = passwordRequired;
    }

    public boolean isPasswordRequired() {
        return this.passwordRequired;
    }

    public void show() {
        this.showDialog();
    }

    public boolean showDialog() {
        if (this.database == null) {
            throw new IllegalStateException(Res._PassPrmptNoDatabase);
        }
        this.attempts = 0;
        if (this.database != null) {
            this.descriptor = this.database.getConnection();
            if (this.userName == null) {
                this.userName = this.descriptor.getUserName();
            }
            this.promptPasswordState = this.descriptor.isPromptPassword();
            if (this.promptPasswordState) {
                this.descriptor.setPromptPassword(false);
            }
            if (this.title == null) {
                this.title = this.descriptor.getConnectionURL();
            }
        }
        this.dialog = new DBPasswordDialog(this.frame, this.title);
        this.dialog.getOkButton().addActionListener(this);
        this.dialog.getCancelButton().addActionListener(this);
        this.dialog.setUserName(this.userName);
        this.dialog.setUserNameRequired(this.userNameRequired);
        this.dialog.setPassword(this.password);
        this.dialog.setPasswordRequired(this.passwordRequired);
        this.dialog.setAutoDispose(false);
        this.dialog.setLocationRelativeTo(this.frame);
        this.dialog.show();
        this.dialog.getOkButton().removeActionListener(this);
        this.dialog.getCancelButton().removeActionListener(this);
        this.dialog.dispose();
        this.descriptor.setPromptPassword(this.promptPasswordState);
        return this.validPassword && this.attempts < this.maxAttempts;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.dialog.getOkButton()) {
            ++this.attempts;
            try {
                this.userName = this.dialog.getUserName();
                this.password = this.dialog.getPassword();
                this.descriptor.setUserName(this.userName);
                this.descriptor.setPassword(this.password);
                this.database.setConnection(this.descriptor);
                this.database.openConnection();
                if (!this.database.isOpen()) {
                    return;
                }
            }
            catch (DataSetException ex) {
                if (this.attempts >= this.maxAttempts) {
                    this.dialog.setVisible(false);
                }
                return;
            }
            this.validPassword = true;
        }
        this.dialog.setVisible(false);
    }
}

