/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.JdbNavToolBar;
import com.borland.dbswing.JdbStatusLabel;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetAware;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class DBUtilities {
    private static char mnemonicChar = '\u0000';
    private static String lastMnemonicText = null;
    private static final char ampSymbol = '&';
    private static boolean is1pt3;
    static /* synthetic */ Class class$com$borland$dbswing$JdbNavToolBar;
    static /* synthetic */ Class class$com$borland$dbswing$JdbStatusLabel;
    static /* synthetic */ Class class$javax$swing$JComponent;

    public static String excludeMnemonicSymbol(String text) {
        if (text == null) {
            return null;
        }
        lastMnemonicText = text;
        int ampPos = 0;
        mnemonicChar = '\u0000';
        while ((ampPos = text.indexOf(38, ampPos)) != -1 && ampPos > 0 && text.charAt(ampPos - 1) == '\\' && (ampPos = text.indexOf(38, ampPos + 1)) != -1) {
        }
        if (ampPos != -1 && ampPos < text.length() - 1) {
            mnemonicChar = text.charAt(ampPos + 1);
            text = ampPos == 0 ? text.substring(1) : String.valueOf(String.valueOf(text.substring(0, ampPos))).concat(String.valueOf(String.valueOf(text.substring(ampPos + 1))));
        }
        return text;
    }

    public static char extractMnemonicChar(String text) {
        if (text == null) {
            return '\u0000';
        }
        if (text != lastMnemonicText && !text.equals(lastMnemonicText)) {
            DBUtilities.excludeMnemonicSymbol(text);
        }
        return mnemonicChar;
    }

    public static void updateCurrentDataSet(Component component, DataSet dataSet) {
        Container container = (Container)SwingUtilities.getRoot(component);
        if (container != null) {
            ArrayList toolBarList = DBUtilities.findComponents(container, class$com$borland$dbswing$JdbNavToolBar == null ? (class$com$borland$dbswing$JdbNavToolBar = DBUtilities.class$("com.borland.dbswing.JdbNavToolBar")) : class$com$borland$dbswing$JdbNavToolBar);
            block0: for (int i = 0; i < toolBarList.size(); ++i) {
                JdbNavToolBar toolBar = (JdbNavToolBar)toolBarList.get(i);
                if (toolBar.isAutoDetect()) {
                    toolBar.updateCurrentDataSet(dataSet);
                    continue;
                }
                if (toolBar.getDataSetAwareComponents() == null) continue;
                for (int j = 0; j < toolBar.getDataSetAwareComponents().length; ++j) {
                    if (component != toolBar.getDataSetAwareComponents()[j] || !(component instanceof DataSetAware)) continue;
                    toolBar.updateCurrentDataSet(((DataSetAware)component).getDataSet());
                    continue block0;
                }
            }
            ArrayList statusLabelList = DBUtilities.findComponents(container, class$com$borland$dbswing$JdbStatusLabel == null ? (class$com$borland$dbswing$JdbStatusLabel = DBUtilities.class$("com.borland.dbswing.JdbStatusLabel")) : class$com$borland$dbswing$JdbStatusLabel);
            block2: for (int i = 0; i < statusLabelList.size(); ++i) {
                JdbStatusLabel statusLabel = (JdbStatusLabel)statusLabelList.get(i);
                if (statusLabel.isAutoDetect()) {
                    statusLabel.updateCurrentDataSet(dataSet);
                    continue;
                }
                if (statusLabel.getDataSetAwareComponents() == null) continue;
                for (int j = 0; j < statusLabel.getDataSetAwareComponents().length; ++j) {
                    if (component != statusLabel.getDataSetAwareComponents()[j] || !(component instanceof DataSetAware)) continue;
                    statusLabel.updateCurrentDataSet(((DataSetAware)component).getDataSet());
                    continue block2;
                }
            }
        }
    }

    private static ArrayList findComponents(Container container, Class clazz) {
        ArrayList<Component> list = new ArrayList<Component>();
        int componentCount = container.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Component component = container.getComponent(i);
            if (clazz.isAssignableFrom(component.getClass())) {
                list.add(component);
                continue;
            }
            if (!(component instanceof Container)) continue;
            list.addAll(DBUtilities.findComponents((Container)component, clazz));
        }
        return list;
    }

    public static boolean containsMnemonic(String text) {
        return text != null && text.indexOf(38) != -1;
    }

    public static DataSetAware[] findDataAwareComponents(Component component) {
        return DBUtilities.findDataAwareChildren((Container)SwingUtilities.getRoot(component));
    }

    public static DataSetAware[] findDataAwareChildren(Container container) {
        if (container != null) {
            HashSet componentCollection = new HashSet();
            DBUtilities.getDataAwareChildComponents(container, componentCollection);
            DataSetAware[] components = new DataSetAware[componentCollection.size()];
            Iterator iterator = componentCollection.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                components[index] = (DataSetAware)iterator.next();
                ++index;
            }
            return components;
        }
        return new DataSetAware[0];
    }

    private static void getDataAwareChildComponents(Container container, HashSet componentCollection) {
        Component[] children = container.getComponents();
        for (int childNo = 0; childNo < children.length; ++childNo) {
            Component child = children[childNo];
            if (child instanceof DataSetAware) {
                componentCollection.add(child);
                continue;
            }
            if (!(child instanceof Container)) continue;
            DBUtilities.getDataAwareChildComponents((Container)child, componentCollection);
        }
    }

    public static int convertJBCLToSwingAlignment(int jbclAlignment, boolean horizontal) {
        if (horizontal) {
            switch (jbclAlignment & 0xF) {
                case 1: {
                    return 2;
                }
                case 3: {
                    return 4;
                }
            }
            return 0;
        }
        switch (jbclAlignment & 0xF0) {
            case 16: {
                return 1;
            }
            case 48: {
                return 3;
            }
        }
        return 0;
    }

    public static Frame getFrame(Component component) {
        if (component instanceof Frame) {
            return (Frame)component;
        }
        for (Container frame = component.getParent(); frame != null; frame = frame.getParent()) {
            if (!(frame instanceof Frame)) continue;
            return (Frame)frame;
        }
        return null;
    }

    public static Dialog getDialog(Component component) {
        if (component instanceof Dialog) {
            return (Dialog)component;
        }
        for (Container dialog = component.getParent(); dialog != null; dialog = dialog.getParent()) {
            if (!(dialog instanceof Dialog)) continue;
            return (Dialog)dialog;
        }
        return null;
    }

    public static String[] getWrappedText(String text) {
        return DBUtilities.getWrappedText(text, 60);
    }

    public static String[] getWrappedText(String text, int width) {
        return DBUtilities.getWrappedText(text, width, Locale.getDefault());
    }

    public static String[] getWrappedText(String text, int width, Locale locale) {
        Vector<String> words = new Vector<String>();
        try {
            BreakIterator textBoundary = BreakIterator.getWordInstance(locale);
            textBoundary.setText(text);
            int start = textBoundary.first();
            int end = textBoundary.next();
            while (end != -1) {
                words.addElement(text.substring(start, end));
                start = end;
                end = textBoundary.next();
            }
        }
        catch (Throwable t) {
            String[] start = new String[]{text};
            return start;
        }
        String[] lines = new String[words.size()];
        int[] length = new int[words.size()];
        int lineCount = 0;
        boolean l = false;
        int curLine = 0;
        int iWidth = 0;
        Enumeration enumeration = words.elements();
        while (enumeration.hasMoreElements()) {
            boolean isLF;
            String w = (String)enumeration.nextElement();
            int wl = w.length();
            int newLength = length[curLine] + wl;
            boolean isCR = w.charAt(0) == '\r';
            boolean bl = isLF = w.charAt(0) == '\n';
            if (isCR) continue;
            if (!isLF && newLength <= width) {
                if (lines[curLine] == null) {
                    lines[curLine] = w;
                    length[curLine] = wl;
                    l = false;
                    ++lineCount;
                    if (newLength <= iWidth) continue;
                    iWidth = newLength;
                    continue;
                }
                lines[curLine] = String.valueOf(String.valueOf(lines[curLine])).concat(String.valueOf(String.valueOf(w)));
                length[curLine] = newLength;
                if (newLength <= iWidth) continue;
                iWidth = newLength;
                continue;
            }
            if (isLF) {
                wl = 0;
                w = w.substring(1);
            }
            if (wl > iWidth) {
                iWidth = wl;
            }
            if (length[curLine] == 0) {
                lines[curLine] = w;
                length[curLine] = wl;
                ++lineCount;
                ++curLine;
            } else {
                ++lineCount;
                lines[++curLine] = w;
                length[curLine] = wl;
            }
            l = false;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] == null) continue;
            list.add(lines[i]);
        }
        return list.toArray(new String[list.size()]);
    }

    public static byte[] getByteArrayFromStream(InputStream inputStream) {
        try {
            byte[] bytes;
            int bytesRead;
            int totalBytes = inputStream.available();
            if (totalBytes > 0 && (bytesRead = inputStream.read(bytes = new byte[totalBytes])) > 0) {
                byte[] byArray = bytes;
                return byArray;
            }
        }
        catch (IOException e) {
            DBExceptionHandler.handleException(e);
        }
        return null;
    }

    public static boolean isGIForJPGFile(InputStream inputStream) {
        try {
            inputStream.mark(4);
            int c1 = inputStream.read();
            int c2 = inputStream.read();
            int c3 = inputStream.read();
            int c4 = inputStream.read();
            inputStream.reset();
            if (c1 == 71 && c2 == 73 && c3 == 70 && c4 == 56 || c1 == 255 && c2 == 216 && c3 == 255 && (c4 == 224 || c4 == 238)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isBMPFile(InputStream inputStream) {
        try {
            inputStream.mark(6);
            int c1 = inputStream.read();
            int c2 = inputStream.read();
            int c3 = inputStream.read();
            int c4 = inputStream.read();
            int c5 = inputStream.read();
            int c6 = inputStream.read();
            inputStream.reset();
            int size = c3 & 0xFF | (c4 & 0xFF) << 8 | (c5 & 0xFF) << 16 | (c6 & 0xFF) << 24;
            if (c1 == 66 && c2 == 77 && size == inputStream.available()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static Image makeBMPImage(InputStream inputStream) {
        if (DBUtilities.isBMPFile(inputStream)) {
            int colorsUsed;
            int imageSize;
            int bitsPerPixel;
            int height;
            int width;
            byte[] bytes = DBUtilities.getByteArrayFromStream(inputStream);
            int bitmapHeaderSize = DBUtilities.extractDWORD(bytes, 14);
            int pixelBase = DBUtilities.extractDWORD(bytes, 24);
            int compression = 0;
            boolean os2ColorTable = false;
            boolean useColorTable = true;
            if (bitmapHeaderSize < 40) {
                if (bitmapHeaderSize == 12) {
                    os2ColorTable = true;
                }
                width = DBUtilities.extractWORD(bytes, 18);
                height = DBUtilities.extractWORD(bytes, 20);
                bitsPerPixel = DBUtilities.extractWORD(bytes, 24);
                imageSize = width * height;
                colorsUsed = 1 << bitsPerPixel;
            } else {
                width = DBUtilities.extractDWORD(bytes, 18);
                height = DBUtilities.extractDWORD(bytes, 22);
                bitsPerPixel = DBUtilities.extractWORD(bytes, 28);
                compression = DBUtilities.extractDWORD(bytes, 30);
                if (compression != 0) {
                    return null;
                }
                imageSize = DBUtilities.extractDWORD(bytes, 34);
                if (imageSize == 0) {
                    imageSize = width * height;
                }
                if ((colorsUsed = DBUtilities.extractDWORD(bytes, 46)) == 0) {
                    if (bitsPerPixel >= 16) {
                        useColorTable = false;
                    }
                    colorsUsed = 1 << bitsPerPixel;
                }
            }
            if (bitsPerPixel > 8 && bitsPerPixel != 24) {
                return null;
            }
            int[] pixels = new int[width * height];
            if (useColorTable) {
                int paletteBase;
                int[] palette = new int[colorsUsed];
                int paletteOffset = paletteBase = 14 + bitmapHeaderSize;
                int bytesPerEntry = os2ColorTable ? 3 : 4;
                for (int i = 0; i < colorsUsed; ++i) {
                    palette[i] = bytes[paletteOffset] & 0xFF | (bytes[paletteOffset + 1] & 0xFF) << 8 | (bytes[paletteOffset + 2] & 0xFF) << 16 | 0xFF000000;
                    paletteOffset += bytesPerEntry;
                }
                int pixelOffset = paletteOffset;
                if (bitsPerPixel == 1) {
                    int remainder;
                    int bitIndex = 0;
                    int padding = 0;
                    int byteWidth = width / 8;
                    if (byteWidth * 8 != width) {
                        ++byteWidth;
                    }
                    if ((remainder = byteWidth % 4) != 0) {
                        padding = 4 - remainder;
                    }
                    for (int row = height - 1; row >= 0; --row) {
                        int base = row * width;
                        for (int bit = 0; bit < width; ++bit) {
                            bitIndex = bit % 8;
                            if (bitIndex == 0 && bit > 0) {
                                ++pixelOffset;
                            }
                            pixels[base + bit] = palette[(bytes[pixelOffset] & 1 << 7 - bitIndex) == 0 ? 0 : 1];
                        }
                        ++pixelOffset;
                        pixelOffset += padding;
                    }
                } else if (bitsPerPixel == 4) {
                    int remainder;
                    int nibbleIndex = 0;
                    int padding = 0;
                    int byteWidth = width / 2;
                    if (byteWidth * 2 != width) {
                        ++byteWidth;
                    }
                    if ((remainder = byteWidth % 4) != 0) {
                        padding = 4 - remainder;
                    }
                    for (int row = height - 1; row >= 0; --row) {
                        int base = row * width;
                        for (int nibble = 0; nibble < width; ++nibble) {
                            nibbleIndex = nibble % 2;
                            if (nibbleIndex == 0 && nibble > 0) {
                                ++pixelOffset;
                            }
                            pixels[base + nibble] = palette[(bytes[pixelOffset] & 240 >> 4 * nibbleIndex) >> 4 * (1 - nibbleIndex)];
                        }
                        ++pixelOffset;
                        pixelOffset += padding;
                    }
                } else if (bitsPerPixel == 8) {
                    int padding = 0;
                    int remainder = width % 4;
                    if (remainder != 0) {
                        padding = 4 - remainder;
                    }
                    for (int row = height - 1; row >= 0; --row) {
                        int base = row * width;
                        for (int column = 0; column < width; ++column) {
                            pixels[base + column] = palette[bytes[pixelOffset++] & 0xFF];
                        }
                        pixelOffset += padding;
                    }
                }
            } else {
                int padding = width % 4;
                int pixelOffset = 14 + bitmapHeaderSize;
                for (int row = height - 1; row >= 0; --row) {
                    int base = row * width;
                    for (int column = 0; column < width; ++column) {
                        if (row == 0) {
                            // empty if block
                        }
                        pixels[base + column] = bytes[pixelOffset++] & 0xFF | (bytes[pixelOffset++] & 0xFF) << 8 | (bytes[pixelOffset++] & 0xFF) << 16 | 0xFF000000;
                        if (row != 0) continue;
                    }
                    pixelOffset += padding;
                }
            }
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(width, height, pixels, 0, width));
        }
        return null;
    }

    private static int extractDWORD(byte[] bytes, int offset) {
        return bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 3] & 0xFF) << 24;
    }

    private static int extractWORD(byte[] bytes, int offset) {
        return bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8;
    }

    public static int yearMaskPos(String mask) {
        boolean inLiteral = false;
        for (int pos = 0; pos < mask.length(); ++pos) {
            if (mask.charAt(pos) == '\'') {
                if (pos != 0 && (pos <= 0 || mask.charAt(pos - 1) == '\\')) continue;
                inLiteral = !inLiteral;
                continue;
            }
            if (inLiteral || mask.charAt(pos) != 'y') continue;
            return pos;
        }
        return -1;
    }

    public static boolean is1pt3() {
        return is1pt3;
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        ampSymbol = (char)38;
        is1pt3 = true;
        try {
            Method method = (class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = DBUtilities.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).getMethod("getInputVerifier", null);
            is1pt3 = method != null;
        }
        catch (NoSuchMethodException e) {
            is1pt3 = false;
        }
    }
}

