/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBUtilities;
import com.borland.dbswing.ImageFileFilter;
import com.borland.dbswing.ImagePreviewer;
import com.borland.dbswing.IntlSwingSupport;
import com.borland.dbswing.JdbTable;
import com.borland.dbswing.Res;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public class TableImageEditor
extends JLabel
implements TableCellEditor,
Runnable,
Serializable {
    private Frame frame;
    private JFileChooser dialog;
    private EventListenerList listenerList = new EventListenerList();
    private transient ChangeEvent changeEvent = new ChangeEvent(this);
    private ImagePreviewer imagePreviewer;
    private static IntlSwingSupport intlSwingSupport = new IntlSwingSupport();
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;

    public TableImageEditor() {
        this.setHorizontalAlignment(0);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Icon icon = null;
        if (value != null && value instanceof Icon) {
            icon = (Icon)value;
            this.setIcon(icon);
        }
        if (this.dialog == null) {
            this.frame = DBUtilities.getFrame(table);
            this.dialog = new JFileChooser();
            this.imagePreviewer = new ImagePreviewer(this.dialog, this.frame);
            this.dialog.setAccessory(this.imagePreviewer);
            this.dialog.setApproveButtonText(Res._OKBtn);
            this.dialog.setDialogTitle(Res._LoadImageFile);
            this.dialog.setFileFilter(new ImageFileFilter());
        }
        this.dialog.setSelectedFile(null);
        this.imagePreviewer.setIcon(icon);
        new Thread(this).start();
        return this;
    }

    public Object getCellEditorValue() {
        if (this.imagePreviewer != null) {
            return this.imagePreviewer.getInputStream();
        }
        return null;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return eventObject instanceof MouseEvent && ((MouseEvent)eventObject).getClickCount() >= 2 || eventObject != null && eventObject.getSource() instanceof JdbTable.StartEditAction;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        return true;
    }

    public void cancelCellEditing() {
    }

    public void run() {
        if (this.dialog.showDialog(this.frame, null) == 0) {
            this.dialog.setPreferredSize(this.dialog.getSize());
            this.fireEditingStopped();
        } else {
            this.dialog.setPreferredSize(this.dialog.getSize());
            this.fireEditingCanceled();
        }
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = TableImageEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = TableImageEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, l);
    }

    private void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$CellEditorListener == null ? TableImageEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) continue;
            ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
        }
    }

    private void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$CellEditorListener == null ? TableImageEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) continue;
            ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

