/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class ToolBarLayout
extends FlowLayout {
    int orientation = 0;

    public ToolBarLayout() {
    }

    public ToolBarLayout(int orientation) {
        this.orientation = orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public Dimension preferredLayoutSize(Container target) {
        if (this.orientation == 0) {
            Dimension d = super.preferredLayoutSize(target);
            return d;
        }
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                dim.width = Math.max(dim.width, d.width);
                if (i > 0) {
                    dim.height += this.getVgap();
                }
                dim.height += d.height;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.getHgap() * 2;
            dim.height += insets.top + insets.bottom + this.getVgap() * 2;
            Dimension dimension = dim;
            return dimension;
        }
    }

    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            int maxwidth = target.getWidth() - (insets.left + insets.right + hgap * 2);
            int maxheight = target.getHeight() - (insets.top + insets.bottom + vgap * 2);
            int nmembers = target.getComponentCount();
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            if (this.orientation == 0) {
                int x = 0;
                int y = insets.top + vgap;
                int rowh = 0;
                int start = 0;
                for (int i = 0; i < nmembers; ++i) {
                    Component m = target.getComponent(i);
                    if (!m.isVisible()) continue;
                    Dimension d = m.getPreferredSize();
                    m.setSize(d.width, d.height);
                    if (x == 0 || x + d.width <= maxwidth) {
                        if (x > 0) {
                            x += hgap;
                        }
                        x += d.width;
                        rowh = Math.max(rowh, d.height);
                        continue;
                    }
                    this.doGridLayout(target);
                    return;
                }
                this.moveComponentsX(target, insets.left + hgap, y, maxwidth - x, rowh, start, nmembers, ltr);
            } else {
                int y = 0;
                int x = insets.left + hgap;
                int colw = 0;
                int start = 0;
                for (int i = 0; i < nmembers; ++i) {
                    Component m = target.getComponent(i);
                    if (!m.isVisible()) continue;
                    Dimension d = m.getPreferredSize();
                    m.setSize(d.width, d.height);
                    if (y == 0 || y + d.height <= maxheight) {
                        if (y > 0) {
                            y += vgap;
                        }
                        y += d.height;
                        colw = Math.max(colw, d.width);
                        continue;
                    }
                    this.doGridLayout(target);
                    return;
                }
                this.moveComponentsY(target, x, insets.top + vgap, colw, maxheight - y, start, nmembers, ltr);
            }
        }
    }

    private void doGridLayout(Container target) {
        int ncols;
        int nrows;
        int visibleComponents = 0;
        int ncomponents = target.getComponentCount();
        Insets insets = target.getInsets();
        int hgap = this.getHgap();
        int vgap = this.getVgap();
        for (int i = 0; i < ncomponents; ++i) {
            if (!target.getComponent(i).isVisible()) continue;
            ++visibleComponents;
        }
        if (visibleComponents == 0) {
            return;
        }
        if (this.orientation == 0) {
            nrows = 1;
            ncols = visibleComponents;
        } else {
            nrows = visibleComponents;
            ncols = 1;
        }
        int w = target.getWidth() - (insets.left + insets.right);
        int h = target.getHeight() - (insets.top + insets.bottom);
        w = (w - (ncols - 1) * hgap) / ncols;
        h = (h - (nrows - 1) * vgap) / nrows;
        if (this.orientation == 0) {
            int y = insets.top + vgap;
            int x = insets.left;
            int i = 0;
            block1: for (int c = 0; c < ncols; ++c) {
                while (i < ncomponents) {
                    Component comp;
                    if ((comp = target.getComponent(i++)).isVisible()) {
                        comp.setBounds(x, y, w, comp.getPreferredSize().height);
                        x += w + hgap;
                        continue block1;
                    }
                    comp.setBounds(-1, -1, 0, 0);
                }
            }
        } else {
            int x = insets.left + hgap;
            int y = insets.top;
            int i = 0;
            block3: for (int c = 0; c < nrows; ++c) {
                while (i < ncomponents) {
                    Component comp;
                    if ((comp = target.getComponent(i++)).isVisible()) {
                        comp.setBounds(x, y, comp.getPreferredSize().width, h);
                        y += h + vgap;
                        continue block3;
                    }
                    comp.setBounds(-1, -1, 0, 0);
                }
            }
        }
    }

    private void moveComponentsX(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr) {
        int hgap = this.getHgap();
        int vgap = this.getVgap();
        int align = this.getAlignment();
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (align) {
                case 0: {
                    x += ltr ? 0 : width;
                    break;
                }
                case 1: {
                    x += width / 2;
                    break;
                }
                case 2: {
                    x += ltr ? width : 0;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    x += width;
                }
            }
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                if (ltr) {
                    m.setLocation(x, y + (height - m.getSize().height) / 2);
                } else {
                    m.setLocation(target.getWidth() - x - m.getSize().width, y + (height - m.getSize().height) / 2);
                }
                x += m.getSize().width + hgap;
            }
        }
    }

    private void moveComponentsY(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr) {
        int hgap = this.getHgap();
        int vgap = this.getVgap();
        int align = this.getAlignment();
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (align) {
                case 0: {
                    y = 0;
                    break;
                }
                case 1: {
                    y += height / 2;
                    break;
                }
                case 2: {
                    y = height;
                }
            }
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                m.setLocation(x + (width - m.getSize().width) / 2, y);
                y += m.getSize().height + vgap;
            }
        }
    }
}

