/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing.plaf.metal;

import com.borland.dbswing.JdbComboBox;
import com.borland.dbswing.JdbTable;
import com.borland.dbswing.TableScrollPane;
import com.borland.dbswing.plaf.basic.BasicJdbComboBoxEditor;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.PickListDescriptor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.TableModel;

public class MetalJdbComboBoxUI
extends MetalComboBoxUI {
    protected static Insets editorBorderInsets = new Insets(2, 2, 2, 0);
    private boolean useLookAheadComboBoxEditor = true;
    private int fixedCellHeight = -1;
    private int dropDownWidth = -1;
    private int initialIndex = -1;

    public static ComponentUI createUI(JComponent c) {
        return new MetalJdbComboBoxUI();
    }

    protected ComboPopup createPopup() {
        MetalJdbComboPopup popup = new MetalJdbComboPopup(this.comboBox);
        popup.getAccessibleContext().setAccessibleParent(this.comboBox);
        return popup;
    }

    public ComboPopup getPopup() {
        return this.popup;
    }

    public void setUseLookAheadComboBoxEditor(boolean useLookAheadComboBoxEditor) {
        this.useLookAheadComboBoxEditor = useLookAheadComboBoxEditor;
    }

    public boolean isUseLookAheadComboBoxEditor() {
        return this.useLookAheadComboBoxEditor;
    }

    protected ComboBoxEditor createEditor() {
        if (this.useLookAheadComboBoxEditor) {
            return new BasicJdbComboBoxEditor(this.comboBox, new EditorBorder(this));
        }
        return super.createEditor();
    }

    protected boolean isShowTable() {
        return this.comboBox.getModel() instanceof JdbComboBox.DBComboBoxModel;
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new JdbPropertyChangeHandler();
    }

    protected Dimension getDisplaySize() {
        Dimension size = this.fixedCellHeight == -1 || this.dropDownWidth == -1 ? super.getDisplaySize() : new Dimension();
        if (this.fixedCellHeight != -1) {
            size.height = this.fixedCellHeight;
        }
        if (this.dropDownWidth != -1) {
            size.width = this.dropDownWidth;
        }
        return size;
    }

    public class JdbPropertyChangeHandler
    extends BasicComboBoxUI.PropertyChangeHandler {
        public JdbPropertyChangeHandler() {
            super(MetalJdbComboBoxUI.this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("fixedCellHeight")) {
                MetalJdbComboBoxUI.this.fixedCellHeight = (Integer)e.getNewValue();
            } else if (e.getPropertyName().equals("dropDownWidth")) {
                MetalJdbComboBoxUI.this.dropDownWidth = (Integer)e.getNewValue();
            } else {
                super.propertyChange(e);
            }
        }
    }

    public class MetalJdbComboPopup
    extends MetalComboBoxUI.MetalComboPopup {
        protected JdbTable table;
        protected Timer autoScrollTimer;
        protected boolean hasEntered = false;
        protected boolean isAutoScrolling = false;
        protected int scrollDirection = 0;
        protected int scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");

        public MetalJdbComboPopup(JComboBox cBox) {
            super(MetalJdbComboBoxUI.this, cBox);
        }

        public void show() {
            Dimension popupSize = this.comboBox.getSize();
            int popupWidth = popupSize.width;
            if (MetalJdbComboBoxUI.this.dropDownWidth != -1) {
                popupWidth = MetalJdbComboBoxUI.this.dropDownWidth;
            } else if (MetalJdbComboBoxUI.this.isShowTable()) {
                this.table.createDefaultColumnsFromModel();
                popupWidth = this.table.getColumnModel().getTotalColumnWidth();
                Insets insets = this.scroller.getInsets();
                popupWidth += insets.left + insets.right + this.scrollBarWidth;
            }
            popupSize.setSize(popupWidth, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
            Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
            this.scroller.setMaximumSize(popupBounds.getSize());
            this.scroller.setPreferredSize(popupBounds.getSize());
            this.scroller.setMinimumSize(popupBounds.getSize());
            this.syncListSelectionWithComboBoxSelection();
            this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
            MetalJdbComboBoxUI.this.initialIndex = this.comboBox.getSelectedIndex();
            this.show(this.comboBox, popupBounds.x, popupBounds.y);
        }

        void syncListSelectionWithComboBoxSelection() {
            int selectedIndex = this.comboBox.getSelectedIndex();
            if (selectedIndex == -1) {
                if (MetalJdbComboBoxUI.this.isShowTable()) {
                    this.table.getSelectionModel().clearSelection();
                } else {
                    this.getJList().clearSelection();
                }
            } else if (MetalJdbComboBoxUI.this.isShowTable()) {
                this.table.invalidate();
                this.table.setRowSelectionInterval(selectedIndex, selectedIndex);
                this.table.ensureRowIsVisible(selectedIndex);
            } else {
                this.getJList().invalidate();
                this.getJList().setSelectedIndex(selectedIndex);
                this.getJList().ensureIndexIsVisible(this.getJList().getSelectedIndex());
            }
        }

        protected int getPopupHeightForRowCount(int maxRowCount) {
            int currentSize = this.comboBox.getModel().getSize();
            if (MetalJdbComboBoxUI.this.fixedCellHeight != -1 && currentSize > 0) {
                int rowMargin = 0;
                if (MetalJdbComboBoxUI.this.isShowTable()) {
                    this.table.setRowHeight(MetalJdbComboBoxUI.this.fixedCellHeight);
                    rowMargin = this.table.getRowMargin();
                } else {
                    this.getJList().setFixedCellHeight(MetalJdbComboBoxUI.this.fixedCellHeight);
                }
                if (maxRowCount < currentSize) {
                    return (MetalJdbComboBoxUI.this.fixedCellHeight + rowMargin) * maxRowCount + 2;
                }
                return (MetalJdbComboBoxUI.this.fixedCellHeight + rowMargin) * currentSize + 2;
            }
            if (currentSize > 0) {
                int height = MetalJdbComboBoxUI.this.isShowTable() ? this.table.getRowHeight() + this.table.getRowMargin() : this.getJList().getCellBounds((int)0, (int)0).height;
                if (maxRowCount < currentSize) {
                    return height * maxRowCount + 2;
                }
                return height * currentSize + 2;
            }
            return 100;
        }

        protected void configureTable() {
            this.table.setFont(this.comboBox.getFont());
            this.table.setForeground(this.comboBox.getForeground());
            this.table.setBackground(this.comboBox.getBackground());
            this.table.setSelectionForeground(UIManager.getColor("ComboBox.selectionForeground"));
            this.table.setSelectionBackground(UIManager.getColor("ComboBox.selectionBackground"));
            this.table.setRowHeaderVisible(false);
            this.table.setColumnHeaderVisible(false);
            this.table.setRowSelectionAllowed(true);
            this.table.setAutoSelection(false);
            this.table.setBorder(null);
            this.table.setPopupMenuEnabled(false);
            this.table.setShowHorizontalLines(false);
            this.table.setRequestFocusEnabled(false);
            this.table.setSelectionMode(0);
            this.syncListSelectionWithComboBoxSelection();
            JdbComboBox.DBComboBoxModel tableModel = (JdbComboBox.DBComboBoxModel)this.table.getModel();
            PickListDescriptor pickList = tableModel.getPickListDescriptor();
            DataSet pickListDataSet = pickList.getPickListDataSet();
            String[] displayColumns = pickList.getPickListDisplayColumns();
            boolean[] visibleColumns = new boolean[tableModel.getColumnCount()];
            int visibleColumnCount = 0;
            block0: for (int colNo = 0; colNo < visibleColumns.length; ++colNo) {
                String columnName = tableModel.getColumn(colNo).getColumnName();
                for (int i = 0; i < displayColumns.length; ++i) {
                    if (!displayColumns[i].equalsIgnoreCase(columnName)) continue;
                    visibleColumns[colNo] = true;
                    ++visibleColumnCount;
                    continue block0;
                }
            }
            int[] hiddenColumns = new int[visibleColumns.length - visibleColumnCount];
            int hiddenColumnIndex = 0;
            for (int colNo = 0; colNo < visibleColumns.length; ++colNo) {
                if (visibleColumns[colNo]) continue;
                hiddenColumns[hiddenColumnIndex++] = colNo;
            }
            this.table.setHiddenColumns(hiddenColumns);
            this.installTableListeners();
        }

        protected void installTableListeners() {
            this.table.getSelectionModel().removeListSelectionListener(this.listSelectionListener);
            this.table.removeMouseMotionListener(this.listMouseMotionListener);
            this.table.removeMouseListener(this.listMouseListener);
            this.table.getSelectionModel().addListSelectionListener(this.listSelectionListener);
            this.table.addMouseMotionListener(this.listMouseMotionListener);
            this.table.addMouseListener(this.listMouseListener);
        }

        protected void setValueIsAdjusting(boolean valueIsAdjusting) {
            this.valueIsAdjusting = valueIsAdjusting;
        }

        protected boolean isValueIsAdjusting() {
            return this.valueIsAdjusting;
        }

        protected void jdbDelegateFocus(MouseEvent e) {
            if (this.getComboBox().isEditable()) {
                this.getComboBox().getEditor().getEditorComponent().requestFocus();
            } else {
                this.getComboBox().requestFocus();
            }
        }

        protected void jdbTogglePopup() {
            if (this.isVisible()) {
                this.hide();
            } else {
                this.show();
            }
        }

        protected MouseEvent convertMouseEvent(MouseEvent e) {
            Point convertedPoint = MetalJdbComboBoxUI.this.isShowTable() ? SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this.table) : SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this.list);
            MouseEvent newEvent = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), convertedPoint.x, convertedPoint.y, e.getModifiers(), e.isPopupTrigger());
            return newEvent;
        }

        protected MouseListener createMouseListener() {
            return new JdbInvocationMouseHandler();
        }

        protected MouseMotionListener createMouseMotionListener() {
            return new JdbInvocationMouseMotionHandler();
        }

        protected KeyListener createKeyListener() {
            return new JdbInvocationKeyHandler();
        }

        protected ListSelectionListener createListSelectionListener() {
            return new JdbSelectionHandler();
        }

        protected MouseListener createListMouseListener() {
            return new JdbMouseHandler();
        }

        protected MouseMotionListener createListMouseMotionListener() {
            return new JdbMouseMotionHandler();
        }

        protected PropertyChangeListener createPropertyChangeListener() {
            return new JdbComboPopupPropertyChangeHandler();
        }

        protected ItemListener createItemListener() {
            return new JdbItemHandler();
        }

        protected void updateListBoxSelectionForEvent(MouseEvent anEvent, boolean shouldScroll) {
            Point location = anEvent.getPoint();
            int index = 0;
            if (MetalJdbComboBoxUI.this.isShowTable()) {
                if (this.table == null) {
                    return;
                }
                index = this.table.rowAtPoint(location);
            } else {
                if (this.getJList() == null) {
                    return;
                }
                index = this.getJList().locationToIndex(location);
            }
            if (index == -1) {
                index = location.y < 0 ? 0 : this.getComboBox().getModel().getSize() - 1;
            }
            if (MetalJdbComboBoxUI.this.isShowTable()) {
                if (this.table.getSelectedRow() != index) {
                    this.table.setRowSelectionInterval(index, index);
                    if (shouldScroll) {
                        this.table.ensureRowIsVisible(index);
                    }
                }
                this.table.repaint();
            } else if (this.getJList().getSelectedIndex() != index) {
                this.getJList().setSelectedIndex(index);
                if (shouldScroll) {
                    this.getJList().ensureIndexIsVisible(index);
                }
            }
        }

        protected void startAutoScrolling(int direction) {
            if (this.isAutoScrolling) {
                this.autoScrollTimer.stop();
            }
            this.isAutoScrolling = true;
            if (direction == 0) {
                this.scrollDirection = 0;
                if (MetalJdbComboBoxUI.this.isShowTable()) {
                    Point convertedPoint = SwingUtilities.convertPoint(this.scroller, new Point(1, 1), this.table);
                    int top = this.table.rowAtPoint(convertedPoint);
                    this.setValueIsAdjusting(true);
                    this.table.setRowSelectionInterval(top, top);
                    this.setValueIsAdjusting(false);
                } else {
                    Point convertedPoint = SwingUtilities.convertPoint(this.scroller, new Point(1, 1), this.list);
                    int top = this.getJList().locationToIndex(convertedPoint);
                    this.setValueIsAdjusting(true);
                    this.getJList().setSelectedIndex(top);
                    this.setValueIsAdjusting(false);
                }
                AbstractAction timerAction = new AbstractAction(this){
                    private final /* synthetic */ MetalJdbComboPopup this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent e) {
                        this.this$1.autoScrollUp();
                    }

                    public boolean isEnabled() {
                        return true;
                    }
                };
                this.autoScrollTimer = new Timer(100, timerAction);
            } else if (direction == 1) {
                Point convertedPoint;
                this.scrollDirection = 1;
                Dimension size = this.scroller.getSize();
                if (MetalJdbComboBoxUI.this.isShowTable()) {
                    convertedPoint = SwingUtilities.convertPoint(this.scroller, new Point(1, size.height - 1 - 2), this.list);
                    int bottom = this.table.rowAtPoint(convertedPoint);
                    this.setValueIsAdjusting(true);
                    this.table.setRowSelectionInterval(bottom, bottom);
                    this.setValueIsAdjusting(false);
                } else {
                    convertedPoint = SwingUtilities.convertPoint(this.scroller, new Point(1, size.height - 1 - 2), this.list);
                    int bottom = this.getJList().locationToIndex(convertedPoint);
                    this.setValueIsAdjusting(true);
                    this.getJList().setSelectedIndex(bottom);
                    this.setValueIsAdjusting(false);
                }
                AbstractAction timerAction = new AbstractAction(this){
                    private final /* synthetic */ MetalJdbComboPopup this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent e) {
                        this.this$1.autoScrollDown();
                    }

                    public boolean isEnabled() {
                        return true;
                    }
                };
                this.autoScrollTimer = new Timer(100, timerAction);
            }
            this.autoScrollTimer.start();
        }

        protected void stopAutoScrolling() {
            this.isAutoScrolling = false;
            if (this.autoScrollTimer != null) {
                this.autoScrollTimer.stop();
                this.autoScrollTimer = null;
            }
        }

        protected void autoScrollUp() {
            if (MetalJdbComboBoxUI.this.isShowTable()) {
                int index = this.table.getSelectedRow();
                if (index > 0) {
                    this.setValueIsAdjusting(true);
                    this.table.setRowSelectionInterval(index - 1, index - 1);
                    this.setValueIsAdjusting(false);
                    this.table.ensureRowIsVisible(index - 1);
                }
            } else {
                int index = this.getJList().getSelectedIndex();
                if (index > 0) {
                    this.setValueIsAdjusting(true);
                    this.getJList().setSelectedIndex(index - 1);
                    this.setValueIsAdjusting(false);
                    this.getJList().ensureIndexIsVisible(index - 1);
                }
            }
        }

        protected void autoScrollDown() {
            if (MetalJdbComboBoxUI.this.isShowTable()) {
                int lastItem;
                int index = this.table.getSelectedRow();
                if (index < (lastItem = this.getJList().getModel().getSize() - 1)) {
                    this.setValueIsAdjusting(true);
                    this.table.setRowSelectionInterval(index + 1, index + 1);
                    this.setValueIsAdjusting(false);
                    this.table.ensureRowIsVisible(index + 1);
                }
            } else {
                int lastItem;
                int index = this.getJList().getSelectedIndex();
                if (index < (lastItem = this.getJList().getModel().getSize() - 1)) {
                    this.setValueIsAdjusting(true);
                    this.getJList().setSelectedIndex(index + 1);
                    this.setValueIsAdjusting(false);
                    this.getJList().ensureIndexIsVisible(index + 1);
                }
            }
        }

        public JdbTable getTable() {
            return this.table;
        }

        protected JComboBox getComboBox() {
            return this.comboBox;
        }

        protected JList getJList() {
            return this.list;
        }

        protected void replaceScroller(JScrollPane scroller) {
            this.remove(this.scroller);
            this.scroller = scroller;
            this.add(scroller);
        }

        public class JdbComboPopupPropertyChangeHandler
        extends BasicComboPopup.PropertyChangeHandler {
            public JdbComboPopupPropertyChangeHandler() {
                super(MetalJdbComboPopup.this);
            }

            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                if (propertyName.equals("model") && (ComboBoxModel)e.getNewValue() instanceof JdbComboBox.DBComboBoxModel) {
                    if (MetalJdbComboPopup.this.table == null) {
                        MetalJdbComboPopup.this.table = new JdbTable();
                        MetalJdbComboPopup.this.table.setEditable(false);
                    }
                    MetalJdbComboPopup.this.table.setModel((TableModel)((Object)MetalJdbComboPopup.this.getComboBox().getModel()));
                    MetalJdbComboPopup.this.configureTable();
                    MetalJdbComboPopup.this.replaceScroller(new TableScrollPane(MetalJdbComboPopup.this.table, 20, 30));
                }
                super.propertyChange(e);
            }
        }

        public class JdbInvocationKeyHandler
        extends KeyAdapter {
            boolean lightNav = false;

            public JdbInvocationKeyHandler() {
                Object keyNav = MetalJdbComboPopup.this.getComboBox().getClientProperty("JComboBox.lightweightKeyboardNavigation");
                if (keyNav != null && keyNav.equals("Heavyweight")) {
                    this.lightNav = false;
                }
            }

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38 && !e.isAltDown()) {
                    if (MetalJdbComboPopup.this.isVisible()) {
                        MetalJdbComboPopup.this.autoScrollUp();
                    } else if (MetalJdbComboBoxUI.this.isShowTable()) {
                        if (MetalJdbComboPopup.this.table.getSelectedRow() > 0) {
                            MetalJdbComboPopup.this.getComboBox().setSelectedIndex(MetalJdbComboPopup.this.table.getSelectedRow() - 1);
                        }
                    } else if (MetalJdbComboPopup.this.getJList().getSelectedIndex() > 0) {
                        MetalJdbComboPopup.this.getComboBox().setSelectedIndex(MetalJdbComboPopup.this.getJList().getSelectedIndex() - 1);
                    }
                    e.consume();
                } else if (e.getKeyCode() == 40 && !e.isAltDown()) {
                    if (MetalJdbComboPopup.this.isVisible()) {
                        MetalJdbComboPopup.this.autoScrollDown();
                    } else if (MetalJdbComboBoxUI.this.isShowTable()) {
                        if (MetalJdbComboPopup.this.table.getSelectedRow() < MetalJdbComboPopup.this.table.getRowCount() - 1) {
                            MetalJdbComboPopup.this.getComboBox().setSelectedIndex(MetalJdbComboPopup.this.table.getSelectedRow() + 1);
                        }
                    } else if (MetalJdbComboPopup.this.getJList().getSelectedIndex() < MetalJdbComboPopup.this.getJList().getModel().getSize() - 1) {
                        MetalJdbComboPopup.this.getComboBox().setSelectedIndex(MetalJdbComboPopup.this.getJList().getSelectedIndex() + 1);
                    }
                    e.consume();
                }
            }

            public void keyReleased(KeyEvent e) {
                if (!MetalJdbComboPopup.this.comboBox.isEditable() && MetalJdbComboPopup.this.isVisible()) {
                    if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
                        if (this.lightNav) {
                            if (MetalJdbComboBoxUI.this.isShowTable()) {
                                MetalJdbComboPopup.this.getComboBox().setSelectedIndex(MetalJdbComboPopup.this.table.getSelectedRow());
                            } else {
                                MetalJdbComboPopup.this.getComboBox().setSelectedIndex(MetalJdbComboPopup.this.getJList().getSelectedIndex());
                            }
                        } else {
                            if (MetalJdbComboBoxUI.this.isShowTable()) {
                                MetalJdbComboPopup.this.getComboBox().setSelectedIndex(MetalJdbComboPopup.this.table.getSelectedRow());
                            } else {
                                MetalJdbComboPopup.this.getComboBox().setSelectedIndex(MetalJdbComboPopup.this.getJList().getSelectedIndex());
                            }
                            MetalJdbComboPopup.this.hide();
                            e.consume();
                        }
                        MetalJdbComboBoxUI.this.initialIndex = -1;
                    }
                } else if (e.isAltDown() && e.getKeyCode() != 18) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                        if (MetalJdbComboPopup.this.isVisible()) {
                            MetalJdbComboBoxUI.this.initialIndex = -1;
                            if (MetalJdbComboBoxUI.this.isShowTable()) {
                                MetalJdbComboPopup.this.getComboBox().setSelectedIndex(MetalJdbComboPopup.this.table.getSelectedRow());
                            } else {
                                MetalJdbComboPopup.this.getComboBox().setSelectedIndex(MetalJdbComboPopup.this.getJList().getSelectedIndex());
                            }
                            MetalJdbComboPopup.this.hide();
                        } else {
                            MetalJdbComboPopup.this.show();
                        }
                    }
                } else if (e.getKeyCode() == 27) {
                    if (MetalJdbComboBoxUI.this.initialIndex != -1) {
                        MetalJdbComboPopup.this.getComboBox().setSelectedIndex(MetalJdbComboBoxUI.this.initialIndex);
                        MetalJdbComboPopup.this.syncListSelectionWithComboBoxSelection();
                        MetalJdbComboBoxUI.this.initialIndex = -1;
                    }
                    if (MetalJdbComboPopup.this.isVisible()) {
                        MetalJdbComboPopup.this.hide();
                    }
                    e.consume();
                } else if (MetalJdbComboPopup.this.comboBox.isEditable() && !MetalJdbComboPopup.this.isVisible() && (e.getKeyCode() == 38 || e.getKeyCode() == 40)) {
                    MetalJdbComboPopup.this.show();
                }
            }
        }

        protected class JdbInvocationMouseMotionHandler
        extends MouseMotionAdapter {
            protected JdbInvocationMouseMotionHandler() {
            }

            public void mouseDragged(MouseEvent e) {
                if (MetalJdbComboPopup.this.isVisible()) {
                    MouseEvent newEvent = MetalJdbComboPopup.this.convertMouseEvent(e);
                    Rectangle r = new Rectangle();
                    if (MetalJdbComboBoxUI.this.isShowTable()) {
                        MetalJdbComboPopup.this.table.computeVisibleRect(r);
                    } else {
                        MetalJdbComboPopup.this.getJList().computeVisibleRect(r);
                    }
                    if (newEvent.getPoint().y >= r.y && newEvent.getPoint().y <= r.y + r.height - 1) {
                        Point location;
                        MetalJdbComboPopup.this.hasEntered = true;
                        if (MetalJdbComboPopup.this.isAutoScrolling) {
                            MetalJdbComboPopup.this.stopAutoScrolling();
                        }
                        if (r.contains(location = newEvent.getPoint())) {
                            MetalJdbComboPopup.this.setValueIsAdjusting(true);
                            MetalJdbComboPopup.this.updateListBoxSelectionForEvent(newEvent, false);
                            MetalJdbComboPopup.this.setValueIsAdjusting(false);
                        }
                    } else if (MetalJdbComboPopup.this.hasEntered) {
                        int directionToScroll;
                        int n = directionToScroll = newEvent.getPoint().y < r.y ? 0 : 1;
                        if (MetalJdbComboPopup.this.isAutoScrolling && MetalJdbComboPopup.this.scrollDirection != directionToScroll) {
                            MetalJdbComboPopup.this.stopAutoScrolling();
                            MetalJdbComboPopup.this.startAutoScrolling(directionToScroll);
                        } else if (!MetalJdbComboPopup.this.isAutoScrolling) {
                            MetalJdbComboPopup.this.startAutoScrolling(directionToScroll);
                        }
                    } else if (e.getPoint().y < 0) {
                        MetalJdbComboPopup.this.hasEntered = true;
                        MetalJdbComboPopup.this.startAutoScrolling(0);
                    }
                }
            }
        }

        protected class JdbInvocationMouseHandler
        extends MouseAdapter {
            protected JdbInvocationMouseHandler() {
            }

            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                if (!MetalJdbComboPopup.this.getComboBox().isEnabled()) {
                    return;
                }
                MetalJdbComboPopup.this.jdbDelegateFocus(e);
                MetalJdbComboPopup.this.jdbTogglePopup();
            }

            public void mouseReleased(MouseEvent e) {
                Component source = (Component)e.getSource();
                Dimension size = source.getSize();
                Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
                if (!bounds.contains(e.getPoint())) {
                    MouseEvent newEvent = MetalJdbComboPopup.this.convertMouseEvent(e);
                    Point location = newEvent.getPoint();
                    Rectangle r = new Rectangle();
                    if (MetalJdbComboBoxUI.this.isShowTable()) {
                        MetalJdbComboPopup.this.table.computeVisibleRect(r);
                    } else {
                        MetalJdbComboPopup.this.getJList().computeVisibleRect(r);
                    }
                    if (r.contains(location)) {
                        MetalJdbComboPopup.this.updateListBoxSelectionForEvent(newEvent, false);
                        if (MetalJdbComboBoxUI.this.isShowTable()) {
                            MetalJdbComboPopup.this.getComboBox().setSelectedIndex(MetalJdbComboPopup.this.table.getSelectedRow());
                        } else {
                            MetalJdbComboPopup.this.getComboBox().setSelectedIndex(MetalJdbComboPopup.this.getJList().getSelectedIndex());
                        }
                    }
                    MetalJdbComboBoxUI.this.initialIndex = -1;
                    MetalJdbComboPopup.this.hide();
                }
                MetalJdbComboPopup.this.hasEntered = false;
                MetalJdbComboPopup.this.stopAutoScrolling();
            }
        }

        protected class JdbItemHandler
        implements ItemListener {
            protected JdbItemHandler() {
            }

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && !MetalJdbComboPopup.this.isValueIsAdjusting()) {
                    MetalJdbComboPopup.this.setValueIsAdjusting(true);
                    MetalJdbComboPopup.this.syncListSelectionWithComboBoxSelection();
                    MetalJdbComboPopup.this.setValueIsAdjusting(false);
                }
            }
        }

        protected class JdbMouseMotionHandler
        extends MouseMotionAdapter {
            protected JdbMouseMotionHandler() {
            }

            public void mouseMoved(MouseEvent anEvent) {
                Point location = anEvent.getPoint();
                Rectangle r = new Rectangle();
                if (MetalJdbComboBoxUI.this.isShowTable()) {
                    MetalJdbComboPopup.this.table.computeVisibleRect(r);
                } else {
                    MetalJdbComboPopup.this.getJList().computeVisibleRect(r);
                }
                if (r.contains(location)) {
                    MetalJdbComboPopup.this.setValueIsAdjusting(true);
                    MetalJdbComboPopup.this.updateListBoxSelectionForEvent(anEvent, false);
                    MetalJdbComboPopup.this.setValueIsAdjusting(false);
                }
            }
        }

        protected class JdbMouseHandler
        extends MouseAdapter {
            protected JdbMouseHandler() {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent anEvent) {
                if (MetalJdbComboBoxUI.this.isShowTable()) {
                    MetalJdbComboPopup.this.getComboBox().setSelectedIndex(MetalJdbComboPopup.this.table.getSelectedRow());
                } else {
                    MetalJdbComboPopup.this.getComboBox().setSelectedIndex(MetalJdbComboPopup.this.getJList().getSelectedIndex());
                }
                MetalJdbComboBoxUI.this.initialIndex = -1;
                MetalJdbComboPopup.this.hide();
            }
        }

        protected class JdbSelectionHandler
        extends BasicComboPopup.ListSelectionHandler {
            boolean lightNav = false;

            public JdbSelectionHandler() {
                super(MetalJdbComboPopup.this);
                Object keyNav = MetalJdbComboPopup.this.getComboBox().getClientProperty("JComboBox.lightweightKeyboardNavigation");
                if (keyNav != null && keyNav.equals("Heavyweight")) {
                    this.lightNav = false;
                }
            }

            public void valueChanged(ListSelectionEvent e) {
                if (MetalJdbComboBoxUI.this.isShowTable()) {
                    if (!(this.lightNav || MetalJdbComboPopup.this.isValueIsAdjusting() || e.getValueIsAdjusting() || MetalJdbComboPopup.this.table.getSelectedRow() == MetalJdbComboPopup.this.getComboBox().getSelectedIndex() || MetalJdbComboPopup.this.table.getSelectedRow() >= MetalJdbComboPopup.this.getComboBox().getItemCount() || MetalJdbComboPopup.this.table.getSelectedRow() < -1)) {
                        MetalJdbComboPopup.this.setValueIsAdjusting(true);
                        MetalJdbComboPopup.this.getComboBox().setSelectedIndex(MetalJdbComboPopup.this.table.getSelectedRow());
                        MetalJdbComboPopup.this.table.ensureRowIsVisible(MetalJdbComboPopup.this.table.getSelectedRow());
                        MetalJdbComboPopup.this.setValueIsAdjusting(false);
                    }
                } else {
                    super.valueChanged(e);
                }
            }
        }
    }

    class EditorBorder
    extends AbstractBorder {
        EditorBorder(MetalJdbComboBoxUI this$0) {
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 0, 0, h - 2);
            g.drawLine(0, h - 2, w - 1, h - 2);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(1, 1, w - 1, 1);
            g.drawLine(1, 1, 1, h - 1);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.setColor(MetalLookAndFeel.getControl());
            g.drawLine(1, h - 2, 1, h - 2);
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            return editorBorderInsets;
        }
    }
}

