/*
 * Decompiled with CFR 0.152.
 */
package GuiTool.Global;

import GuiTool.Global.LvgCommand;
import GuiTool.Gui.InputOptionDialog;
import GuiTool.Gui.InputPanel;
import GuiTool.Gui.MutatePanel;
import GuiTool.Gui.OutputPanel;
import gov.nih.nlm.nls.lvg.Api.LvgLexItemApi;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.LvgOutputOption;
import gov.nih.nlm.nls.lvg.Lib.OutputFilter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public class LvgGlobal {
    public static LvgCommand cmd_ = new LvgCommand();
    private static Vector outputLexItems_ = new Vector();
    private static Vector outputStrs_ = new Vector();
    private static String outputStr_ = new String();
    public static Configuration config_ = new Configuration("data.config.lvg", true);
    public static LvgLexItemApi lvg_ = new LvgLexItemApi();
    public static boolean inputFromScreen_ = true;
    public static boolean outputToScreen_ = true;
    private static String curDir_ = System.getProperty("user.dir");
    public static File inFile_ = new File(curDir_ + "/in.data");
    public static File outFile_ = new File(curDir_ + "/out.data");
    public static File confFile_ = new File(curDir_);
    public static boolean outAppendFlag_ = false;
    public static LvgOutputOption outputOption_ = new LvgOutputOption();
    public static boolean mutateFlag_ = false;
    public static boolean detailsFlag_ = false;
    public static String separator_ = GlobalBehavior.GetFieldSeparator();

    private LvgGlobal() {
    }

    public static void SetConfig(String string) {
        config_ = new Configuration(string, false);
        lvg_ = new LvgLexItemApi("", string);
    }

    public static Vector GetOutputLexItems() {
        return outputLexItems_;
    }

    public static Vector GetOutputStrings() {
        return outputStrs_;
    }

    public static void LvgMutate() {
        if (inputFromScreen_) {
            LvgGlobal.LvgMutate(InputPanel.GetLexItem(), InputPanel.GetInLine());
        } else if (outputToScreen_) {
            LvgGlobal.LvgMutate(inFile_);
        } else if (!outputToScreen_) {
            LvgGlobal.LvgMutate(inFile_, outFile_);
        }
    }

    private static void LvgMutate(LexItem lexItem, String string) {
        outputLexItems_.removeAllElements();
        outputLexItems_ = LvgGlobal.Process(lexItem);
        LvgGlobal.UpdateOutputStrings(outputLexItems_, string, false);
        if (outputToScreen_) {
            OutputPanel.UpdateResult();
        } else {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(outFile_.getPath(), outAppendFlag_));
                bufferedWriter.write(outputStr_);
                bufferedWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            OutputPanel.SetOutputMessage();
        }
    }

    private static void LvgMutate(File file) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = null;
            boolean bl = true;
            outputLexItems_.removeAllElements();
            LvgGlobal.ResetOutputStrings();
            while ((string = bufferedReader.readLine()) != null) {
                bl = true;
                if (true) {
                    MutatePanel.SetNormLuiNormWordInd(string);
                    bl = false;
                }
                LexItem lexItem = LvgGlobal.SetLexItem(string);
                Vector vector = LvgGlobal.Process(lexItem);
                LvgGlobal.UpdateOutputStrings(vector, string, true);
                outputLexItems_.addAll(vector);
                OutputPanel.UpdateResult();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("** Error: incorrect input file, " + exception.getMessage());
        }
    }

    private static void LvgMutate(File file, File file2) {
        try {
            String string = null;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(outFile_.getPath(), outAppendFlag_));
            boolean bl = true;
            outputLexItems_.removeAllElements();
            while ((string = bufferedReader.readLine()) != null) {
                bl = true;
                if (true) {
                    MutatePanel.SetNormLuiNormWordInd(string);
                    bl = false;
                }
                LexItem lexItem = LvgGlobal.SetLexItem(string);
                Vector vector = LvgGlobal.Process(lexItem);
                LvgGlobal.UpdateOutputStrings(vector, string, true);
                bufferedWriter.write(outputStr_);
                LvgGlobal.ResetOutputStrings();
            }
            bufferedReader.close();
            bufferedWriter.close();
            OutputPanel.SetOutputMessage();
        }
        catch (Exception exception) {
            System.out.println("** Error: incorrect input file, " + exception.getMessage());
        }
    }

    private static void ResetOutputs() {
        outputLexItems_.removeAllElements();
        outputStrs_.removeAllElements();
        outputStr_ = new String();
    }

    private static LexItem SetLexItem(String string) {
        String string2 = separator_;
        int n = InputOptionDialog.GetTermFieldNum();
        String string3 = InputFilter.GetInputTerm(string, string2, n);
        LexItem lexItem = new LexItem(string3);
        int n2 = InputOptionDialog.GetCategoryFieldNum();
        if (n2 > 0) {
            long l = InputFilter.GetInputCategory(string, string2, n2);
            lexItem.SetSourceCategory(l);
        } else {
            lexItem.SetSourceCategory(2047L);
        }
        int n3 = InputOptionDialog.GetInflectionFieldNum();
        if (n3 > 0) {
            long l = InputFilter.GetInputInflection(string, string2, n3);
            lexItem.SetSourceInflection(l);
        } else {
            lexItem.SetSourceInflection(0xFFFFFFL);
        }
        return lexItem;
    }

    public static void UpdateCmdStr() {
        cmd_.UpdateCmdStr();
        MutatePanel.SetCommand(cmd_.GetCmdStr());
    }

    private static Vector Process(LexItem lexItem) {
        Vector vector = new Vector();
        lvg_.SetOption(cmd_.GetCmdStr());
        try {
            vector = lvg_.ProcessLexItem(lexItem);
        }
        catch (Exception exception) {
            System.out.println("** Error: " + exception.toString());
        }
        return vector;
    }

    private static void ResetOutputStrings() {
        outputStr_ = new String();
        outputStrs_.removeAllElements();
    }

    public static void UpdateOutputStrings(Vector vector, String string, boolean bl) {
        if (!bl) {
            LvgGlobal.ResetOutputStrings();
        }
        String string2 = OutputFilter.ExecuteOutputFilter(vector, mutateFlag_, detailsFlag_, separator_, string, outputOption_);
        outputStr_ = outputStr_ + string2;
        String string3 = System.getProperty("line.separator").toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        while (stringTokenizer.hasMoreTokens()) {
            outputStrs_.addElement(stringTokenizer.nextToken());
        }
    }
}

