/*
 * Decompiled with CFR 0.152.
 */
package GuiTool.Gui;

import GuiTool.Global.LvgGlobal;
import GuiTool.Gui.FlowSetupDialog;
import GuiTool.Gui.InputOptionDialog;
import GuiTool.Gui.InputPanel;
import GuiTool.Gui.LvgMenu;
import GuiTool.Gui.LvgPopupMenu;
import GuiTool.Gui.MainPanel;
import GuiTool.Gui.MutateOptionDialog;
import GuiTool.Gui.MutatePanel;
import GuiTool.Gui.OutputOptionDialog;
import GuiTool.Gui.OutputPanel;
import GuiTool.GuiLib.LibCloseableFrame;
import GuiTool.GuiLib.LvgHtmlBrowser;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LvgFrame
extends LibCloseableFrame
implements ActionListener {
    private static boolean showCmd_ = true;
    private static boolean setCmdEditable_ = false;
    private static boolean bold_ = false;
    private static boolean italic_ = false;
    private static String style_ = "Dialog";
    private static int size_ = 12;
    private static MainPanel mainPanel_ = null;
    private static JFrame lvgFrame_ = null;
    private static LvgHtmlBrowser helpDoc_ = null;

    public LvgFrame() {
        lvgFrame_ = this;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n = dimension.height;
        int n2 = dimension.width;
        this.setTitle("Lexical Tool");
        this.setSize(520, 650);
        this.setLocation(5, 10);
        this.setResizable(true);
        Image image = toolkit.getImage("/export/www/apache_1.3.9/htdocs/lvg/image/lvg.jpg");
        this.setIconImage(image);
        LvgPopupMenu.AddPopupMenu(this);
        LvgMenu.AddMenu(this);
        mainPanel_ = new MainPanel(this);
        this.getContentPane().add(mainPanel_);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Exit")) {
            if (LvgGlobal.lvg_ != null) {
                LvgGlobal.lvg_.CleanUp();
            }
            System.exit(0);
        } else if (string.equals("Input File")) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setSelectedFile(LvgGlobal.inFile_);
            jFileChooser.setDialogTitle("Choose the input file");
            jFileChooser.setMultiSelectionEnabled(false);
            if (jFileChooser.showDialog(this, "Select") == 0) {
                LvgGlobal.inFile_ = jFileChooser.getSelectedFile();
                InputPanel.SetFile(LvgGlobal.inFile_.getPath());
            }
        } else if (string.equals("Output File")) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setSelectedFile(LvgGlobal.outFile_);
            jFileChooser.setDialogTitle("Choose the output file");
            jFileChooser.setMultiSelectionEnabled(false);
            if (jFileChooser.showDialog(this, "Select") == 0) {
                LvgGlobal.outFile_ = jFileChooser.getSelectedFile();
                OutputOptionDialog.SetOutputFile(LvgGlobal.outFile_);
            }
        } else if (string.equals("Flow Setup")) {
            FlowSetupDialog.ShowDialog(this);
        } else if (string.equals("Input Options")) {
            InputOptionDialog.ShowDialog(lvgFrame_);
        } else if (string.equals("Mutate Options")) {
            MutateOptionDialog.ShowDialog(lvgFrame_);
        } else if (string.equals("Output Options")) {
            OutputOptionDialog.ShowDialog(lvgFrame_);
        } else if (string.equals("Show Commands")) {
            showCmd_ = !showCmd_;
            MutatePanel.SetShowCommand(showCmd_);
        } else if (string.equals("Set Commands Editable")) {
            setCmdEditable_ = !setCmdEditable_;
            MutatePanel.SetCommandEditable(setCmdEditable_);
        } else if (string.equals("Serif") || string.equals("SansSerif") || string.equals("Monospaced") || string.equals("Dialog") || string.equals("DialogInput")) {
            style_ = string;
            this.UpdateFont();
        } else if (string.equals("Bold")) {
            bold_ = !bold_;
            this.UpdateFont();
        } else if (string.equals("Italic")) {
            italic_ = !italic_;
            this.UpdateFont();
        } else if (string.equals("8") || string.equals("10") || string.equals("12") || string.equals("14") || string.equals("16") || string.equals("18") || string.equals("20") || string.equals("24") || string.equals("28") || string.equals("32")) {
            size_ = Integer.parseInt(string);
            this.UpdateFont();
        } else if (string.equals("Metal")) {
            String string2 = "javax.swing.plaf.metal.MetalLookAndFeel";
            this.UpdateLookAndFeel(string2, this);
        } else if (string.equals("Motif")) {
            String string3 = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            this.UpdateLookAndFeel(string3, this);
        } else if (string.equals("Window")) {
            String string4 = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
            this.UpdateLookAndFeel(string4, this);
        } else if (string.equals("About")) {
            JOptionPane.showMessageDialog(this, "Lvg 2003", "About Lexical Tool", 1);
        } else if (string.equals("Documents")) {
            String string5 = LvgGlobal.config_.GetConfiguration("LVG_DIR");
            String string6 = "file:" + string5 + "docs/designDoc/UDF/gui/index.html";
            if (helpDoc_ == null) {
                String string7 = "Lexical GUI Tool Documents";
                String string8 = "file:" + string5 + "docs/designDoc/UDF/gui/index.html";
                helpDoc_ = new LvgHtmlBrowser(this, string7, 600, 800, string8, string6);
            } else {
                helpDoc_.SetPage(string6);
            }
            helpDoc_.setVisible(true);
        }
        SwingUtilities.updateComponentTreeUI(this);
    }

    public static boolean GetShowCmd() {
        return showCmd_;
    }

    public static boolean GetSetCmdEditable() {
        return setCmdEditable_;
    }

    private void UpdateFont() {
        Font font = new Font(style_, (bold_ ? 1 : 0) + (italic_ ? 2 : 0), size_);
        InputPanel.GetTermField().setFont(font);
        MutatePanel.GetCmdField().setFont(font);
        OutputPanel.GetOutputList().setFont(font);
        this.repaint();
    }

    private void UpdateLookAndFeel(String string, JFrame jFrame) {
        try {
            UIManager.setLookAndFeel(string);
            SwingUtilities.updateComponentTreeUI(jFrame);
        }
        catch (Exception exception) {
            System.out.println("-- This platform does not support: " + string);
        }
    }
}

