/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.example;

import gov.nih.nlm.kss.api.KSSRetriever;
import gov.nih.nlm.kss.models.meta.concept.ConceptId;
import gov.nih.nlm.kss.models.meta.concept.ConceptIdVector;
import gov.nih.nlm.kss.util.DatabaseException;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Vector;

public class Client {
    private static final int CO = 1;
    private static final int RE = 2;
    private static final int SA = 3;
    private static final int ST = 4;
    private static final int DE = 5;
    private static final int CX = 6;
    private static final int CC = 7;
    private static final int LO = 8;
    private static final int BC = 9;
    private static final int CV = 10;
    private static final int VE = 11;
    private static final int AE = 12;
    private static final int SV = 13;
    private static final int LS = 14;
    private static PrintStream out;
    private static Client instance;

    private static int outputMenu(BufferedReader br) {
        System.out.println("\nUMLSKS Client Menu:");
        String tab = "    ";
        System.out.println(tab + " 1) Retrieve Concept");
        System.out.println(tab + " 2) Retrieve Basic Concept");
        System.out.println(tab + " 3) Retrieve Terminology");
        System.out.println(tab + " 4) Retrieve Definition(s)");
        System.out.println(tab + " 5) Retrieve Semantic Type(s)");
        System.out.println(tab + " 6) Retrieve Context");
        System.out.println(tab + " 7) Retrieve CUI");
        System.out.println(tab + " 8) Retrieve Concept Name");
        System.out.println(tab + " 9) Retrieve Associated Expressions");
        System.out.println(tab + "10) Retrieve Cooccurrences");
        System.out.println(tab + "11) Retrieve Relations");
        System.out.println(tab + "12) Retrieve String Attributes");
        System.out.println(tab + "13) Retrieve MeSH Entries");
        System.out.println(tab + "14) Retrieve Locator");
        System.out.println(tab + "15) Retrieve MeSH Terms");
        System.out.println(tab + "16) Retrieve ASCII Table Records");
        System.out.println(tab + "17) Show Current UMLS Release Version");
        System.out.println(tab + "18) List UMLS Release Versions Supported");
        System.out.println(tab + "19) Show UMLSKS Software Version");
        System.out.println(tab + "'q' to Quit client");
        System.out.println();
        System.out.print("Selection: ");
        String select = Client.getString(br);
        select = select.toLowerCase();
        if (select.equals("q")) {
            System.out.println();
            return 0;
        }
        Integer i = null;
        try {
            i = new Integer(select);
        }
        catch (NumberFormatException ex) {
            System.out.println("Either 'q' or a number must be entered");
            return Client.outputMenu(br);
        }
        int selection = i;
        if (selection < 1 || selection > 19) {
            System.out.println("Either 'q' or a number must be entered");
            return Client.outputMenu(br);
        }
        return selection;
    }

    public static void main(String[] args) {
        KSSRetriever retriever = null;
        if (args.length == 0) {
            System.out.println(" Call syntax:  Client <server host> <server name>");
            System.out.print(" Example:      Client umlsks.nlm.nih.gov ");
            System.out.println("KSSRetriever");
            return;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        try {
            String host = args[0];
            String name = "//" + host + "/" + args[1];
            retriever = (KSSRetriever)Naming.lookup(name);
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            return;
        }
        catch (NotBoundException nbex) {
            System.err.println("NotBoundException: " + nbex.getMessage());
            return;
        }
        catch (MalformedURLException mfurl) {
            System.err.println("MalformedURLException: " + mfurl.getMessage());
            return;
        }
        boolean done = false;
        while (!done) {
            int menuChoice = Client.outputMenu(br);
            switch (menuChoice) {
                case 0: {
                    done = true;
                    break;
                }
                case 1: {
                    Client.requestConcept(br, retriever, 7, "concept");
                    break;
                }
                case 2: {
                    Client.requestConcept(br, retriever, 9, "concept");
                    break;
                }
                case 3: {
                    Client.requestTerms(br, retriever);
                    break;
                }
                case 4: {
                    Client.request(br, retriever, 5, "definitions", "getDefinitions");
                    break;
                }
                case 5: {
                    Client.request(br, retriever, 4, "semantic types", "getSemanticTypes");
                    break;
                }
                case 6: {
                    Client.request(br, retriever, 6, "context", "getContext");
                    break;
                }
                case 7: {
                    Client.requestCUI(br, retriever);
                    break;
                }
                case 8: {
                    Client.requestConceptName(br, retriever);
                    break;
                }
                case 9: {
                    Client.request(br, retriever, 12, "associated expressions", "getAssocExprs");
                    break;
                }
                case 10: {
                    Client.requestParmed(br, retriever, 1, "cooccurrences", "getCooccurrences");
                    break;
                }
                case 11: {
                    Client.requestParmed(br, retriever, 2, "relations", "getRelations");
                    break;
                }
                case 12: {
                    Client.requestParmed(br, retriever, 3, "string attributes", "getStringAttrs");
                    break;
                }
                case 13: {
                    Client.requestMeSH(br, retriever);
                    break;
                }
                case 14: {
                    Client.request(br, retriever, 8, "locator", "getLocator");
                    break;
                }
                case 15: {
                    Client.requestMeSHTerms(br, retriever);
                    break;
                }
                case 16: {
                    Client.requestRawRecords(br, retriever);
                    break;
                }
                case 17: {
                    Client.requestNoArg(br, retriever, 10);
                    break;
                }
                case 18: {
                    Client.requestNoArg(br, retriever, 11);
                    break;
                }
                case 19: {
                    Client.requestNoArg(br, retriever, 13);
                    break;
                }
                default: {
                    done = true;
                }
            }
        }
        Object var1_1 = null;
    }

    private ClientEntry obtainDetails(BufferedReader br, String promptVal) {
        String prompt = "Request ";
        prompt = prompt + promptVal + " using 1) CUI, 2) Term Name";
        prompt = prompt + " 3) Abort. Selection: ";
        System.out.print(prompt);
        String val = Client.getString(br);
        val = val.toLowerCase();
        if (val.equals("1")) {
            return this.obtainDetails(br, false);
        }
        if (val.equals("2")) {
            return this.obtainDetails(br, true);
        }
        return null;
    }

    private ClientEntry obtainDetails(BufferedReader br, boolean terms) {
        ClientEntry entry = new ClientEntry();
        System.out.print("Enter UMLS Release Year: ");
        entry.dbYear = Client.getString(br);
        String prompt = "";
        if (terms) {
            prompt = "Enter Terms (eg:AIDS), one per line; empty line to end:";
            entry.cuisOrConNames = Client.multiValPrompt(br, prompt);
            if (entry.cuisOrConNames.size() == 0) {
                return null;
            }
            entry.operator = Client.getOperator(br);
            entry.cuiEntered = false;
        } else {
            prompt = "Enter CUIs (eg:C0001175), one per line; empty line to end:";
            entry.cuisOrConNames = Client.multiValPrompt(br, prompt);
            if (entry.cuisOrConNames.size() == 0) {
                return null;
            }
            entry.cuiEntered = true;
        }
        entry.sabs = Client.multiValPrompt(br, "Enter Root SABs (eg:MSH), one per line; empty line to end:");
        System.out.print("Enter the language (empty for no retriction): ");
        entry.language = Client.getString(br);
        System.out.print("Output contents to 1) the screen or 2) a file: ");
        String output = Client.getString(br);
        output = output.toLowerCase();
        if (output.equals("2")) {
            entry.screenOutput = false;
            System.out.print("Enter output file name: ");
            entry.outputFileName = Client.getString(br);
        } else {
            entry.screenOutput = true;
        }
        return entry;
    }

    private static Vector determineCUIs(KSSRetriever retriever, ClientEntry entry) {
        if (entry.cuiEntered) {
            return entry.cuisOrConNames;
        }
        Vector<String> cuis = new Vector<String>();
        Iterator iter = entry.cuisOrConNames.iterator();
        while (iter.hasNext()) {
            String termName = (String)iter.next();
            Vector termCUIs = Client.doRetrieveCUI(retriever, termName, entry);
            Iterator termIter = termCUIs.iterator();
            while (termIter.hasNext()) {
                String termCUI = (String)termIter.next();
                cuis.add(termCUI);
            }
        }
        return cuis;
    }

    private static void requestConcept(BufferedReader br, KSSRetriever retriever, int cmdOpt, String prompt) {
        block12: {
            ClientEntry entry = Client.getInstance().obtainDetails(br, prompt);
            if (entry == null) {
                return;
            }
            String cmdString = "";
            try {
                Iterator iter = entry.cuisOrConNames.iterator();
                StringBuffer buffer = new StringBuffer(50000);
                while (iter.hasNext()) {
                    char[] result;
                    String cuiOrCon = (String)iter.next();
                    long start = System.currentTimeMillis();
                    if (entry.cuiEntered) {
                        if (cmdOpt == 9) {
                            result = retriever.getBasicConceptProperties(entry.dbYear, cuiOrCon, entry.sabs, entry.language);
                            cmdString = "getBasicConceptProperties";
                        } else {
                            result = retriever.getConceptProperties(entry.dbYear, cuiOrCon, entry.sabs, entry.language);
                            cmdString = "getConceptProperties";
                        }
                    } else if (cmdOpt == 9) {
                        result = retriever.findBasicConcept(entry.dbYear, cuiOrCon, entry.sabs, entry.language, entry.operator);
                        cmdString = "findBasicConcept";
                    } else {
                        result = retriever.findConcept(entry.dbYear, cuiOrCon, entry.sabs, entry.language, entry.operator);
                        cmdString = "findConcept";
                    }
                    long end = System.currentTimeMillis();
                    long interval = end - start;
                    System.out.println();
                    System.out.println("\t" + cmdString + " in XML took " + interval + " milliseconds");
                    String xml = new String(result);
                    buffer.append(xml);
                }
                if (entry.screenOutput) {
                    out.println(buffer.toString());
                    break block12;
                }
                Client.writeFile(entry.outputFileName, buffer.toString());
            }
            catch (DatabaseException ex) {
                System.err.println(cmdString + ": DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println(cmdString + ": RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void request(BufferedReader br, KSSRetriever retriever, int cmdOpt, String prompt, String cmdString) {
        ClientEntry entry = Client.getInstance().obtainDetails(br, prompt);
        if (entry == null) {
            return;
        }
        Vector cuisToProcess = Client.determineCUIs(retriever, entry);
        Iterator iter = cuisToProcess.iterator();
        while (iter.hasNext()) {
            String cui = (String)iter.next();
            Client.doRetrieveVal(retriever, cmdOpt, cui, entry, cmdString);
        }
    }

    private static void requestMeSH(BufferedReader br, KSSRetriever retriever) {
        block5: {
            System.out.print("Enter UMLS Release Year: ");
            String dbYear = Client.getString(br);
            System.out.print("Enter MeSH Entry term name: ");
            String termName = Client.getString(br);
            System.out.print("Output contents to 1) the screen or 2) a file: ");
            String output = Client.getString(br);
            output = output.toLowerCase();
            boolean screenOutput = true;
            String outputFileName = "";
            if (output.equals("2")) {
                screenOutput = false;
                System.out.print("Enter output file name: ");
                outputFileName = Client.getString(br);
            }
            try {
                long start = System.currentTimeMillis();
                char[] result = retriever.getMeSHEntries(dbYear, termName);
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\tgetMeSHEntries for '" + termName + "' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (screenOutput) {
                    out.println(xml);
                    break block5;
                }
                Client.writeFile(outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println("getMeSHEntries: DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println("getMeSHEntries: RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void requestMeSHTerms(BufferedReader br, KSSRetriever retriever) {
        block5: {
            System.out.print("Enter UMLS Release Year: ");
            String dbYear = Client.getString(br);
            System.out.print("Enter MeSH term DUI: ");
            String dui = Client.getString(br);
            System.out.print("Output contents to 1) the screen or 2) a file: ");
            String output = Client.getString(br);
            output = output.toLowerCase();
            boolean screenOutput = true;
            String outputFileName = "";
            if (output.equals("2")) {
                screenOutput = false;
                System.out.print("Enter output file name: ");
                outputFileName = Client.getString(br);
            }
            try {
                long start = System.currentTimeMillis();
                char[] result = retriever.getMeSHInfo(dbYear, dui);
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\tgetMeSHInfo for '" + dui + "' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (screenOutput) {
                    out.println(xml);
                    break block5;
                }
                Client.writeFile(outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println("getMeSHInfo: DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println("getMeSHInfo: RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void requestTerms(BufferedReader br, KSSRetriever retriever) {
        block13: {
            System.out.print("Enter UMLS Release Year: ");
            String dbYear = Client.getString(br);
            String prompt = "Request MeSH term using 1) CUI, 2) Term Name";
            prompt = prompt + " 3) Abort. Selection: ";
            System.out.print(prompt);
            String val = Client.getString(br);
            val = val.toLowerCase();
            boolean cui = true;
            if (val.equals("1")) {
                cui = true;
            } else if (val.equals("2")) {
                cui = false;
            } else {
                return;
            }
            if (cui) {
                System.out.print("Enter CUI: ");
            } else {
                System.out.print("Enter MeSH term name: ");
            }
            String term = Client.getString(br);
            Vector sabs = Client.multiValPrompt(br, "Enter Root SABs (eg:MSH), one per line; empty line to end:");
            System.out.print("Enter the language (empty for no retriction): ");
            String language = Client.getString(br);
            System.out.print("Output contents to 1) the screen or 2) a file: ");
            String output = Client.getString(br);
            output = output.toLowerCase();
            boolean screenOutput = true;
            String outputFileName = "";
            if (output.equals("2")) {
                screenOutput = false;
                System.out.print("Enter output file name: ");
                outputFileName = Client.getString(br);
            }
            String cmdName = "getTerminology";
            try {
                long start = System.currentTimeMillis();
                char[] result = null;
                if (cui) {
                    result = retriever.getTerminology(dbYear, term, sabs, language);
                } else {
                    cmdName = "getTerms";
                    result = retriever.getTerms(dbYear, term, sabs, language);
                }
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\tgetTerms for '" + term + "' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (screenOutput) {
                    out.println(xml);
                    break block13;
                }
                Client.writeFile(outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void requestNoArg(BufferedReader br, KSSRetriever retriever, int option) {
        block11: {
            System.out.print("Output contents to 1) the screen or 2) a file: ");
            String output = Client.getString(br);
            output = output.toLowerCase();
            boolean screenOutput = true;
            String outputFileName = "";
            if (output.equals("2")) {
                screenOutput = false;
                System.out.print("Enter output file name: ");
                outputFileName = Client.getString(br);
            }
            String cmdName = "getCurrentUMLSVersion";
            try {
                char[] result;
                long start = System.currentTimeMillis();
                switch (option) {
                    case 10: {
                        String resstr = retriever.getCurrentUMLSVersion();
                        result = resstr.toCharArray();
                        break;
                    }
                    case 11: {
                        Vector resvec = retriever.getUMLSVersions();
                        StringBuffer buf = new StringBuffer(1000);
                        Iterator iter = resvec.iterator();
                        while (iter.hasNext()) {
                            buf.append((String)iter.next());
                            if (!iter.hasNext()) continue;
                            buf.append(", ");
                        }
                        result = buf.toString().toCharArray();
                        cmdName = "getUMLSVersions";
                        break;
                    }
                    case 13: {
                        String res = retriever.getSWVersion();
                        result = res.toCharArray();
                        cmdName = "getSWVersion";
                        break;
                    }
                    default: {
                        return;
                    }
                }
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\t'" + cmdName + "' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (screenOutput) {
                    out.println(xml);
                    break block11;
                }
                Client.writeFile(outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void writeFile(String outputFileName, String xml) {
        try {
            PrintStream fos = new PrintStream((OutputStream)new FileOutputStream(outputFileName), true, "UTF-8");
            fos.println(xml);
            fos.close();
        }
        catch (IOException ex) {
            System.out.println("IOException: " + ex.getMessage());
        }
    }

    private static void requestCUI(BufferedReader br, KSSRetriever retriever) {
        block6: {
            ClientEntry entry = Client.getInstance().obtainDetails(br, true);
            if (entry == null) {
                return;
            }
            try {
                Iterator iter = entry.cuisOrConNames.iterator();
                StringBuffer buffer = new StringBuffer(4000);
                while (iter.hasNext()) {
                    String termName = (String)iter.next();
                    long start = System.currentTimeMillis();
                    char[] result = retriever.findCUI(entry.dbYear, termName, entry.sabs, entry.language, entry.operator);
                    long end = System.currentTimeMillis();
                    long interval = end - start;
                    System.out.println();
                    System.out.println("\tfindCUI for '" + termName + "' in XML took " + interval + " milliseconds");
                    String xml = new String(result);
                    buffer.append(xml);
                }
                if (entry.screenOutput) {
                    out.println(buffer.toString());
                    break block6;
                }
                Client.writeFile(entry.outputFileName, buffer.toString());
            }
            catch (DatabaseException ex) {
                System.err.println("findCUI: DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println("findCUI: RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void requestConceptName(BufferedReader br, KSSRetriever retriever) {
        block6: {
            ClientEntry entry = Client.getInstance().obtainDetails(br, false);
            if (entry == null) {
                return;
            }
            try {
                Iterator iter = entry.cuisOrConNames.iterator();
                StringBuffer buffer = new StringBuffer(10000);
                while (iter.hasNext()) {
                    String cui = (String)iter.next();
                    long start = System.currentTimeMillis();
                    char[] result = retriever.getConceptName(entry.dbYear, cui, entry.sabs, entry.language);
                    long end = System.currentTimeMillis();
                    long interval = end - start;
                    System.out.println();
                    System.out.println("\tgetConceptName for '" + cui + "' in XML took " + interval + " milliseconds");
                    String xml = new String(result);
                    buffer.append(xml);
                }
                if (entry.screenOutput) {
                    out.println(buffer.toString());
                    break block6;
                }
                Client.writeFile(entry.outputFileName, buffer.toString());
            }
            catch (DatabaseException ex) {
                System.err.println("getConceptName: DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println("getConceptName: RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void requestParmed(BufferedReader br, KSSRetriever retriever, int cmdOpt, String prompt, String cmdName) {
        ClientEntry entry = Client.getInstance().obtainDetails(br, prompt);
        if (entry == null) {
            return;
        }
        System.out.print("Enter the ");
        System.out.print(prompt);
        System.out.print(" name: ");
        String arg = Client.getString(br);
        Vector cuisToProcess = Client.determineCUIs(retriever, entry);
        Iterator iter = cuisToProcess.iterator();
        while (iter.hasNext()) {
            String cui = (String)iter.next();
            Client.doRetrieveVal(retriever, cmdOpt, cui, entry, arg, cmdName);
        }
    }

    private static void requestRawRecords(BufferedReader br, KSSRetriever retriever) {
        block5: {
            System.out.print("Enter UMLS Release Year: ");
            String dbYear = Client.getString(br);
            System.out.print("Enter the table name whose raw records are to be returned: ");
            String tableName = Client.getString(br);
            System.out.print("Enter the CUI to obtain the raw ");
            System.out.print(tableName);
            System.out.print(" records: ");
            String cui = Client.getString(br);
            System.out.print("Enter the language (empty for no retriction): ");
            String lat = Client.getString(br);
            System.out.print("Output ");
            System.out.print(tableName);
            System.out.print(" records to 1) the screen or 2) a file: ");
            String output = Client.getString(br);
            output = output.toLowerCase();
            boolean screenOutput = true;
            String outputFileName = "";
            if (output.equals("2")) {
                screenOutput = false;
                System.out.print("Enter output file name: ");
                outputFileName = Client.getString(br);
            }
            try {
                long start = System.currentTimeMillis();
                char[] result = retriever.getRawRecords(dbYear, cui, lat, tableName);
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\tgetRawRecords for table '" + tableName + " with CUI='" + cui + "' with language '" + lat + "' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (screenOutput) {
                    out.println(xml);
                    break block5;
                }
                Client.writeFile(outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println("getRawRecords: DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println("getRawRecords: RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static String getString(BufferedReader br) {
        String str = null;
        try {
            str = br.readLine();
        }
        catch (IOException iex) {
            System.err.println("IOException: " + iex.getMessage());
        }
        return str;
    }

    private static Vector multiValPrompt(BufferedReader br, String prompt) {
        Vector<String> values = new Vector<String>();
        System.out.println(prompt);
        String str = null;
        while (!(str = Client.getString(br)).equals("")) {
            values.addElement(str);
            if (!str.equals("")) continue;
        }
        return values;
    }

    private static int getOperator(BufferedReader br) {
        int operator = 1;
        System.out.println("Enter matching Criteria: 1 (Exact), 2 (NormStr), 3 (NormWord),");
        System.out.println("      4 (Word), 5 (TrucateRight), 6 (Truncate Left): 7 (ApproximateMatch): ");
        String str = Client.getString(br);
        if (str.equals("1")) {
            operator = 1;
        } else if (str.equals("2")) {
            operator = 2;
        } else if (str.equals("3")) {
            operator = 3;
        } else if (str.equals("4")) {
            operator = 4;
        } else if (str.equals("5")) {
            operator = 5;
        } else if (str.equals("6")) {
            operator = 6;
        } else if (str.equals("7")) {
            operator = 7;
        }
        return operator;
    }

    private static void doRetrieveVal(KSSRetriever retriever, int type, String cui, ClientEntry entry, String arg, String cmdName) {
        block10: {
            try {
                Iterator iter = entry.sabs.iterator();
                String sab = "";
                if (iter.hasNext()) {
                    sab = (String)iter.next();
                }
                long start = System.currentTimeMillis();
                char[] result = null;
                switch (type) {
                    case 1: {
                        result = retriever.getCooccurrences(entry.dbYear, cui, entry.language, sab, arg);
                        break;
                    }
                    case 2: {
                        result = retriever.getRelations(entry.dbYear, cui, entry.sabs, entry.language, arg);
                        break;
                    }
                    case 3: {
                        result = retriever.getStringAttributes(entry.dbYear, cui, sab, arg);
                        break;
                    }
                    default: {
                        System.out.println("Invalid selection");
                        return;
                    }
                }
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\t" + cmdName + " for source '" + sab + "' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (entry.screenOutput) {
                    out.println(xml);
                    break block10;
                }
                Client.writeFile(entry.outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void doRetrieveVal(KSSRetriever retriever, int type, String cui, ClientEntry entry, String cmdName) {
        block13: {
            Iterator iter = entry.sabs.iterator();
            String sab = "";
            if (iter.hasNext()) {
                sab = (String)iter.next();
            }
            try {
                long start = System.currentTimeMillis();
                char[] result = null;
                switch (type) {
                    case 12: {
                        result = retriever.getAssocExprs(entry.dbYear, cui, sab);
                        break;
                    }
                    case 8: {
                        result = retriever.getLocator(entry.dbYear, cui);
                        break;
                    }
                    case 7: {
                        result = retriever.getConceptProperties(entry.dbYear, cui, entry.sabs, entry.language);
                        break;
                    }
                    case 4: {
                        result = retriever.getSemanticType(entry.dbYear, cui);
                        break;
                    }
                    case 5: {
                        result = retriever.getDefinition(entry.dbYear, cui, entry.sabs);
                        break;
                    }
                    case 6: {
                        result = retriever.getContext(entry.dbYear, cui, entry.sabs);
                        break;
                    }
                    default: {
                        System.out.println("Invalid selection");
                        return;
                    }
                }
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\t" + cmdName + " in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (entry.screenOutput) {
                    out.println(xml);
                    break block13;
                }
                Client.writeFile(entry.outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static Vector doRetrieveCUI(KSSRetriever retriever, String termName, ClientEntry entry) {
        Vector<String> cuis = new Vector<String>();
        Object cui = null;
        try {
            Iterator iter;
            long start = System.currentTimeMillis();
            char[] result = retriever.findCUI(entry.dbYear, termName, entry.sabs, entry.language, entry.operator);
            long end = System.currentTimeMillis();
            long interval = end - start;
            String xml = new String(result);
            ConceptIdVector vec = ConceptIdVector.getInstance(xml);
            if (vec != null && (iter = vec.iterator()).hasNext()) {
                ConceptId cid = (ConceptId)iter.next();
                cuis.add(cid.getCUI());
            }
        }
        catch (DatabaseException ex) {
            System.err.println("doRetrieveCUI: DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println("doRetrieveCUI: RemoteException-> " + ex.getMessage());
        }
        return cuis;
    }

    private Client() {
    }

    public static Client getInstance() {
        if (instance == null) {
            instance = new Client();
        }
        return instance;
    }

    class ClientEntry {
        String dbYear;
        public Vector cuisOrConNames;
        public Vector sabs;
        public String language;
        boolean cuiEntered;
        int operator;
        boolean screenOutput;
        String outputFileName;

        public void output() {
            System.out.println("CUIs/TermNames = " + this.cuisOrConNames);
            System.out.println("SABs = " + this.sabs);
            System.out.println("language = '" + this.language + "'");
            System.out.println("cuiEntered = '" + this.cuiEntered + "'");
            System.out.println("operator = '" + this.operator + "'");
        }

        public ClientEntry(Vector cuis, Vector srcs, String lang, boolean cui, int op) {
            this.cuisOrConNames = cuis;
            this.sabs = srcs;
            this.language = lang;
            this.cuiEntered = cui;
            this.operator = op;
        }

        public ClientEntry() {
        }
    }
}

