/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.example;

import gov.nih.nlm.kss.api.KSSRetrieverV2_1;
import gov.nih.nlm.kss.models.meta.concept.ConceptId;
import gov.nih.nlm.kss.models.meta.concept.ConceptIdVector;
import gov.nih.nlm.kss.util.DatabaseException;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClientV2_1 {
    private static final int AE = 0;
    private static final int SA = 1;
    private static final int CV = 2;
    private static final int VE = 3;
    private static final int BC = 4;
    private static final int CC = 5;
    private static final int LO = 6;
    private static final int LD = 7;
    private static final int CT = 8;
    private static final int RT = 9;
    private static final int STT = 10;
    private static final int LSA = 11;
    private static final int LS = 12;
    private static final int MQ = 13;
    private static final int TT = 14;
    private static PrintStream out;
    private static ClientV2_1 instance;

    private static int outputMenu(BufferedReader br) {
        System.out.println("\nUMLSKS ClientV2_1 Menu:");
        String tab = "    ";
        System.out.println(tab + " 1) Retrieve Concept");
        System.out.println(tab + " 2) Retrieve Basic Concept");
        System.out.println(tab + " 3) Retrieve Terminology");
        System.out.println(tab + " 4) Retrieve CUI");
        System.out.println(tab + " 5) Retrieve Associated Expressions");
        System.out.println(tab + " 6) Retrieve String Attributes");
        System.out.println(tab + " 7) Retrieve Locator");
        System.out.println(tab + " 8) Retrieve LUI for a Term");
        System.out.println(tab + " 9) Retrieve Term(s) for an LUI");
        System.out.println(tab + "10) Retrieve SUI for a String");
        System.out.println(tab + "11) Retrieve String(s) for an SUI");
        System.out.println(tab + "12) Retrieve List of String Attributes");
        System.out.println(tab + "13) Retrieve List of MeSH Qualifiers");
        System.out.println(tab + "14) Retrieve List of Term Types (TTYs)");
        System.out.println(tab + "15) Retrieve List of Sources");
        System.out.println(tab + "16) Retrieve Source Description");
        System.out.println(tab + "17) Retrieve List of UMLS Changes");
        System.out.println(tab + "18) Show Current UMLS Release Version");
        System.out.println(tab + "19) List UMLS Release Versions Supported");
        System.out.println(tab + "20) Suggest Spelling");
        System.out.println(tab + "21) List Available Spelling Dictionaries");
        System.out.println(tab + "22) Retrieve List of String Types (STTs)");
        System.out.println(tab + "23) Retrieve List of Relation Types");
        System.out.println(tab + "24) Retrieve List of Cooccurrence Types");
        System.out.println(tab + "'q' to Quit client");
        System.out.println();
        System.out.print("Selection: ");
        String select = ClientV2_1.getString(br);
        select = select.toLowerCase();
        if (select.equals("q")) {
            System.out.println();
            return 0;
        }
        Integer i = null;
        try {
            i = new Integer(select);
        }
        catch (NumberFormatException ex) {
            System.out.println("Either 'q' or a number must be entered");
            return ClientV2_1.outputMenu(br);
        }
        int selection = i;
        if (selection < 1 || selection > 24) {
            System.out.println("Either 'q' or a number must be entered");
            return ClientV2_1.outputMenu(br);
        }
        return selection;
    }

    public static void main(String[] args) {
        KSSRetrieverV2_1 retriever = null;
        if (args.length == 0) {
            System.out.println(" Call syntax:  ClientV2_1 <server host> <server name>");
            System.out.print(" Example:      ClientV2_1 umlsks.nlm.nih.gov ");
            System.out.println("KSSRetriever");
            return;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        try {
            String host = args[0];
            String name = "//" + host + "/" + args[1];
            retriever = (KSSRetrieverV2_1)Naming.lookup(name);
        }
        catch (RemoteException rex) {
            System.err.println("RemoteException: " + rex.getMessage());
            return;
        }
        catch (NotBoundException nbex) {
            System.err.println("NotBoundException: " + nbex.getMessage());
            return;
        }
        catch (MalformedURLException mfurl) {
            System.err.println("MalformedURLException: " + mfurl.getMessage());
            return;
        }
        boolean done = false;
        while (!done) {
            int menuChoice = ClientV2_1.outputMenu(br);
            switch (menuChoice) {
                case 0: {
                    done = true;
                    break;
                }
                case 1: {
                    ClientV2_1.requestConcept(br, retriever, 5, "concept");
                    break;
                }
                case 2: {
                    ClientV2_1.requestConcept(br, retriever, 4, "concept");
                    break;
                }
                case 3: {
                    ClientV2_1.requestTerms(br, retriever);
                    break;
                }
                case 4: {
                    ClientV2_1.requestCUI(br, retriever);
                    break;
                }
                case 5: {
                    ClientV2_1.request(br, retriever, 0, "associated expressions", "getAssocExprs");
                    break;
                }
                case 6: {
                    ClientV2_1.requestParmed(br, retriever, 1, "string attributes", "getStringAttrs");
                    break;
                }
                case 7: {
                    ClientV2_1.request(br, retriever, 6, "locators", "getLocators");
                    break;
                }
                case 8: {
                    ClientV2_1.requestLUI(br, retriever);
                    break;
                }
                case 9: {
                    ClientV2_1.requestLUITerms(br, retriever);
                    break;
                }
                case 10: {
                    ClientV2_1.requestSUI(br, retriever);
                    break;
                }
                case 11: {
                    ClientV2_1.requestSUIStrings(br, retriever);
                    break;
                }
                case 12: {
                    ClientV2_1.requestReleaseList(br, retriever, 11, "listStrAttrs");
                    break;
                }
                case 13: {
                    ClientV2_1.requestReleaseList(br, retriever, 13, "listMeSHQuals");
                    break;
                }
                case 14: {
                    ClientV2_1.requestReleaseList(br, retriever, 14, "listTermTypes");
                    break;
                }
                case 15: {
                    ClientV2_1.requestReleaseList(br, retriever, 12, "listSources");
                    break;
                }
                case 16: {
                    ClientV2_1.requestSourceDesc(br, retriever);
                    break;
                }
                case 17: {
                    ClientV2_1.requestUMLSChanges(br, retriever);
                    break;
                }
                case 18: {
                    ClientV2_1.requestNoArg(br, retriever, 2);
                    break;
                }
                case 19: {
                    ClientV2_1.requestNoArg(br, retriever, 3);
                    break;
                }
                case 20: {
                    ClientV2_1.requestSpelling(br, retriever);
                    break;
                }
                case 21: {
                    ClientV2_1.requestNoArg(br, retriever, 7);
                    break;
                }
                case 22: {
                    ClientV2_1.requestReleaseList(br, retriever, 10, "listStringTypes");
                    break;
                }
                case 23: {
                    ClientV2_1.requestReleaseList(br, retriever, 9, "listRelationTypes");
                    break;
                }
                case 24: {
                    ClientV2_1.requestReleaseList(br, retriever, 8, "listCooccurrenceTypes");
                    break;
                }
                default: {
                    done = true;
                }
            }
        }
        Object var1_1 = null;
    }

    private ClientV2_1Entry obtainDetails(BufferedReader br, String promptVal) {
        String prompt = "Request ";
        prompt = prompt + promptVal + " using 1) CUI, 2) Term Name";
        prompt = prompt + " 3) Abort. Selection: ";
        System.out.print(prompt);
        String val = ClientV2_1.getString(br);
        val = val.toLowerCase();
        if (val.equals("1")) {
            return this.obtainDetails(br, false);
        }
        if (val.equals("2")) {
            return this.obtainDetails(br, true);
        }
        return null;
    }

    private ClientV2_1Entry obtainDetails(BufferedReader br, boolean terms) {
        ClientV2_1Entry entry = new ClientV2_1Entry();
        System.out.print("Enter UMLS Release Year: ");
        entry.dbYear = ClientV2_1.getString(br);
        String prompt = "";
        if (terms) {
            prompt = "Enter Terms (eg:AIDS), one per line; empty line to end:";
            entry.cuisOrConNames = ClientV2_1.multiValPrompt(br, prompt);
            if (entry.cuisOrConNames.size() == 0) {
                return null;
            }
            entry.operator = ClientV2_1.getOperator(br);
            entry.cuiEntered = false;
        } else {
            prompt = "Enter CUIs (eg:C0001175), one per line; empty line to end:";
            entry.cuisOrConNames = ClientV2_1.multiValPrompt(br, prompt);
            if (entry.cuisOrConNames.size() == 0) {
                return null;
            }
            entry.cuiEntered = true;
        }
        entry.sabs = ClientV2_1.multiValPrompt(br, "Enter Root SABs (eg:MSH), one per line; empty line to end:");
        System.out.print("Enter the language (empty for no retriction): ");
        entry.language = ClientV2_1.getString(br);
        System.out.print("Include suppressible synonyms, if applicable (Y/N): ");
        String incSup = ClientV2_1.getString(br);
        entry.incSupps = false;
        if (incSup.toUpperCase().equals("Y")) {
            entry.incSupps = true;
        }
        System.out.print("Output contents to 1) the screen or 2) a file: ");
        String output = ClientV2_1.getString(br);
        output = output.toLowerCase();
        if (output.equals("2")) {
            entry.screenOutput = false;
            System.out.print("Enter output file name: ");
            entry.outputFileName = ClientV2_1.getString(br);
        } else {
            entry.screenOutput = true;
        }
        return entry;
    }

    private static Vector determineCUIs(KSSRetrieverV2_1 retriever, ClientV2_1Entry entry) {
        if (entry.cuiEntered) {
            return entry.cuisOrConNames;
        }
        Vector<String> cuis = new Vector<String>();
        Iterator iter = entry.cuisOrConNames.iterator();
        while (iter.hasNext()) {
            String termName = (String)iter.next();
            Vector termCUIs = ClientV2_1.doRetrieveCUI(retriever, termName, entry);
            Iterator termIter = termCUIs.iterator();
            while (termIter.hasNext()) {
                String termCUI = (String)termIter.next();
                cuis.add(termCUI);
            }
        }
        return cuis;
    }

    private static void requestConcept(BufferedReader br, KSSRetrieverV2_1 retriever, int cmdOpt, String prompt) {
        block12: {
            ClientV2_1Entry entry = ClientV2_1.getInstance().obtainDetails(br, prompt);
            if (entry == null) {
                return;
            }
            String cmdString = "";
            try {
                Iterator iter = entry.cuisOrConNames.iterator();
                StringBuffer buffer = new StringBuffer(50000);
                while (iter.hasNext()) {
                    char[] result;
                    String cuiOrCon = (String)iter.next();
                    long start = System.currentTimeMillis();
                    if (entry.cuiEntered) {
                        if (cmdOpt == 4) {
                            result = retriever.getBasicConceptProperties(entry.dbYear, cuiOrCon, entry.sabs, entry.language, entry.incSupps);
                            cmdString = "getBasicConceptProperties";
                        } else {
                            result = retriever.getConceptProperties(entry.dbYear, cuiOrCon, entry.sabs, entry.language, entry.incSupps);
                            cmdString = "getConceptProperties";
                        }
                    } else if (cmdOpt == 4) {
                        result = retriever.findBasicConcept(entry.dbYear, cuiOrCon, entry.sabs, entry.language, entry.operator, entry.incSupps);
                        cmdString = "findBasicConcept";
                    } else {
                        result = retriever.findConcept(entry.dbYear, cuiOrCon, entry.sabs, entry.language, entry.operator, entry.incSupps);
                        cmdString = "findConcept";
                    }
                    long end = System.currentTimeMillis();
                    long interval = end - start;
                    System.out.println();
                    System.out.println("\t" + cmdString + " in XML took " + interval + " milliseconds");
                    String xml = new String(result);
                    buffer.append(xml);
                }
                if (entry.screenOutput) {
                    out.println(buffer.toString());
                    break block12;
                }
                ClientV2_1.writeFile(entry.outputFileName, buffer.toString());
            }
            catch (DatabaseException ex) {
                System.err.println(cmdString + ": DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println(cmdString + ": RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void request(BufferedReader br, KSSRetrieverV2_1 retriever, int cmdOpt, String prompt, String cmdString) {
        ClientV2_1Entry entry = ClientV2_1.getInstance().obtainDetails(br, prompt);
        if (entry == null) {
            return;
        }
        Vector cuisToProcess = ClientV2_1.determineCUIs(retriever, entry);
        Iterator iter = cuisToProcess.iterator();
        while (iter.hasNext()) {
            String cui = (String)iter.next();
            ClientV2_1.doRetrieveVal(retriever, cmdOpt, cui, entry, cmdString);
        }
    }

    private static void requestSpelling(BufferedReader br, KSSRetrieverV2_1 retriever) {
        block5: {
            System.out.print("Enter Dictionary: ");
            String dict = ClientV2_1.getString(br);
            System.out.print("Enter term: ");
            String termName = ClientV2_1.getString(br);
            System.out.print("Output contents to 1) the screen or 2) a file: ");
            String output = ClientV2_1.getString(br);
            output = output.toLowerCase();
            boolean screenOutput = true;
            String outputFileName = "";
            if (output.equals("2")) {
                screenOutput = false;
                System.out.print("Enter output file name: ");
                outputFileName = ClientV2_1.getString(br);
            }
            try {
                long start = System.currentTimeMillis();
                char[] result = retriever.suggestSpelling(dict, termName);
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\tsuggestSpelling for '" + termName + "' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (screenOutput) {
                    out.println(xml);
                    break block5;
                }
                ClientV2_1.writeFile(outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println("suggestSpelling: DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println("suggestSpelling: RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void requestTerms(BufferedReader br, KSSRetrieverV2_1 retriever) {
        block14: {
            System.out.print("Enter UMLS Release Year: ");
            String dbYear = ClientV2_1.getString(br);
            String prompt = "Request term using 1) CUI, 2) Term Name";
            prompt = prompt + " 3) Abort. Selection: ";
            System.out.print(prompt);
            String val = ClientV2_1.getString(br);
            val = val.toLowerCase();
            boolean cui = true;
            if (val.equals("1")) {
                cui = true;
            } else if (val.equals("2")) {
                cui = false;
            } else {
                return;
            }
            if (cui) {
                System.out.print("Enter CUI: ");
            } else {
                System.out.print("Enter term name: ");
            }
            String term = ClientV2_1.getString(br);
            Vector sabs = ClientV2_1.multiValPrompt(br, "Enter Root SABs (eg:MSH), one per line; empty line to end:");
            System.out.print("Enter the language (empty for no retriction): ");
            String language = ClientV2_1.getString(br);
            System.out.print("Include suppressible synonyms, if applicable (Y/N): ");
            String incSup = ClientV2_1.getString(br);
            boolean incSupps = false;
            if (incSup.toUpperCase().equals("Y")) {
                incSupps = true;
            }
            System.out.print("Output contents to 1) the screen or 2) a file: ");
            String output = ClientV2_1.getString(br);
            output = output.toLowerCase();
            boolean screenOutput = true;
            String outputFileName = "";
            if (output.equals("2")) {
                screenOutput = false;
                System.out.print("Enter output file name: ");
                outputFileName = ClientV2_1.getString(br);
            }
            String cmdName = "getTerminology";
            try {
                long start = System.currentTimeMillis();
                char[] result = null;
                if (cui) {
                    result = retriever.getTerminology(dbYear, term, sabs, language, incSupps);
                } else {
                    cmdName = "getTerms";
                    result = retriever.getTerms(dbYear, term, sabs, language, incSupps);
                }
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\tgetTerms for '" + term + "' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (screenOutput) {
                    out.println(xml);
                    break block14;
                }
                ClientV2_1.writeFile(outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void requestLUI(BufferedReader br, KSSRetrieverV2_1 retriever) {
        block6: {
            System.out.print("Enter UMLS Release Year: ");
            String dbYear = ClientV2_1.getString(br);
            System.out.print("Enter Term Name: ");
            String termName = ClientV2_1.getString(br);
            Vector sabs = ClientV2_1.multiValPrompt(br, "Enter Root SABs (eg:MSH), one per line; empty line to end:");
            System.out.print("Enter the language (empty for no retriction): ");
            String language = ClientV2_1.getString(br);
            System.out.print("Include suppressible synonyms, if applicable (Y/N): ");
            String incSup = ClientV2_1.getString(br);
            boolean incSupps = false;
            if (incSup.toUpperCase().equals("Y")) {
                incSupps = true;
            }
            System.out.print("Output contents to 1) the screen or 2) a file: ");
            String output = ClientV2_1.getString(br);
            output = output.toLowerCase();
            boolean screenOutput = true;
            String outputFileName = "";
            if (output.equals("2")) {
                screenOutput = false;
                System.out.print("Enter output file name: ");
                outputFileName = ClientV2_1.getString(br);
            }
            try {
                long start = System.currentTimeMillis();
                char[] result = retriever.findLUI(dbYear, termName, sabs, language, incSupps);
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\tfindLUI for '" + termName + "' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (screenOutput) {
                    out.println(xml);
                    break block6;
                }
                ClientV2_1.writeFile(outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println("findLUI: DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println("findLUI: RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void requestLUITerms(BufferedReader br, KSSRetrieverV2_1 retriever) {
        block6: {
            System.out.print("Enter UMLS Release Year: ");
            String dbYear = ClientV2_1.getString(br);
            System.out.print("Enter LUI: ");
            String lui = ClientV2_1.getString(br);
            Vector sabs = ClientV2_1.multiValPrompt(br, "Enter Root SABs (eg:MSH), one per line; empty line to end:");
            System.out.print("Enter the language (empty for no retriction): ");
            String language = ClientV2_1.getString(br);
            System.out.print("Include suppressible synonyms, if applicable (Y/N): ");
            String incSup = ClientV2_1.getString(br);
            boolean incSupps = false;
            if (incSup.toUpperCase().equals("Y")) {
                incSupps = true;
            }
            System.out.print("Output contents to 1) the screen or 2) a file: ");
            String output = ClientV2_1.getString(br);
            output = output.toLowerCase();
            boolean screenOutput = true;
            String outputFileName = "";
            if (output.equals("2")) {
                screenOutput = false;
                System.out.print("Enter output file name: ");
                outputFileName = ClientV2_1.getString(br);
            }
            try {
                long start = System.currentTimeMillis();
                char[] result = retriever.getTermsForLUI(dbYear, lui, sabs, language, incSupps);
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\tgetTermsForLUI for '" + lui + "' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (screenOutput) {
                    out.println(xml);
                    break block6;
                }
                ClientV2_1.writeFile(outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println("getTermsForLUI: DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println("getTermsForLUI: RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void requestSUI(BufferedReader br, KSSRetrieverV2_1 retriever) {
        block5: {
            System.out.print("Enter UMLS Release Year: ");
            String dbYear = ClientV2_1.getString(br);
            System.out.print("Enter String: ");
            String str = ClientV2_1.getString(br);
            Vector sabs = ClientV2_1.multiValPrompt(br, "Enter Root SABs (eg:MSH), one per line; empty line to end:");
            System.out.print("Enter the language (empty for no retriction): ");
            String language = ClientV2_1.getString(br);
            System.out.print("Output contents to 1) the screen or 2) a file: ");
            String output = ClientV2_1.getString(br);
            output = output.toLowerCase();
            boolean screenOutput = true;
            String outputFileName = "";
            if (output.equals("2")) {
                screenOutput = false;
                System.out.print("Enter output file name: ");
                outputFileName = ClientV2_1.getString(br);
            }
            try {
                long start = System.currentTimeMillis();
                char[] result = retriever.findSUI(dbYear, str, sabs, language);
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\tfindSUI for '" + str + "' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (screenOutput) {
                    out.println(xml);
                    break block5;
                }
                ClientV2_1.writeFile(outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println("findSUI: DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println("findSUI: RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void requestSUIStrings(BufferedReader br, KSSRetrieverV2_1 retriever) {
        block5: {
            System.out.print("Enter UMLS Release Year: ");
            String dbYear = ClientV2_1.getString(br);
            System.out.print("Enter SUI: ");
            String sui = ClientV2_1.getString(br);
            Vector sabs = ClientV2_1.multiValPrompt(br, "Enter Root SABs (eg:MSH), one per line; empty line to end:");
            System.out.print("Enter the language (empty for no retriction): ");
            String language = ClientV2_1.getString(br);
            System.out.print("Output contents to 1) the screen or 2) a file: ");
            String output = ClientV2_1.getString(br);
            output = output.toLowerCase();
            boolean screenOutput = true;
            String outputFileName = "";
            if (output.equals("2")) {
                screenOutput = false;
                System.out.print("Enter output file name: ");
                outputFileName = ClientV2_1.getString(br);
            }
            try {
                long start = System.currentTimeMillis();
                char[] result = retriever.getStringsForSUI(dbYear, sui, sabs, language);
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\tgetStringsForSUI for '" + sui + "' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (screenOutput) {
                    out.println(xml);
                    break block5;
                }
                ClientV2_1.writeFile(outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println("getStringsForSUI: DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println("getStringsForSUI: RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void requestReleaseList(BufferedReader br, KSSRetrieverV2_1 retriever, int option, String methodName) {
        block14: {
            System.out.print("Enter UMLS Release Year: ");
            String dbYear = ClientV2_1.getString(br);
            System.out.print("Output contents to 1) the screen or 2) a file: ");
            String output = ClientV2_1.getString(br);
            output = output.toLowerCase();
            boolean screenOutput = true;
            String outputFileName = "";
            if (output.equals("2")) {
                screenOutput = false;
                System.out.print("Enter output file name: ");
                outputFileName = ClientV2_1.getString(br);
            }
            try {
                long start = System.currentTimeMillis();
                char[] result = null;
                switch (option) {
                    case 8: {
                        result = retriever.listCooccurrenceTypes(dbYear);
                        break;
                    }
                    case 9: {
                        result = retriever.listRelationTypes(dbYear);
                        break;
                    }
                    case 10: {
                        result = retriever.listStringTypes(dbYear);
                        break;
                    }
                    case 12: {
                        result = retriever.listSources(dbYear);
                        break;
                    }
                    case 14: {
                        result = retriever.listTermTypes(dbYear);
                        break;
                    }
                    case 13: {
                        result = retriever.listMeSHQuals(dbYear);
                        break;
                    }
                    case 11: {
                        result = retriever.listStrAttrs(dbYear);
                    }
                }
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\t" + methodName + "' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (screenOutput) {
                    out.println(xml);
                    break block14;
                }
                ClientV2_1.writeFile(outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println(methodName + ": DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println(methodName + ": RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void requestSourceDesc(BufferedReader br, KSSRetrieverV2_1 retriever) {
        block5: {
            System.out.print("Enter UMLS Release Year: ");
            String dbYear = ClientV2_1.getString(br);
            System.out.print("Enter Source Abbreviation: ");
            String src = ClientV2_1.getString(br);
            System.out.print("Output contents to 1) the screen or 2) a file: ");
            String output = ClientV2_1.getString(br);
            output = output.toLowerCase();
            boolean screenOutput = true;
            String outputFileName = "";
            if (output.equals("2")) {
                screenOutput = false;
                System.out.print("Enter output file name: ");
                outputFileName = ClientV2_1.getString(br);
            }
            try {
                long start = System.currentTimeMillis();
                char[] result = retriever.describeSource(dbYear, src);
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\tdescribeSource ' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (screenOutput) {
                    out.println(xml);
                    break block5;
                }
                ClientV2_1.writeFile(outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println("describeSource: DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println("describeSource: RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void requestUMLSChanges(BufferedReader br, KSSRetrieverV2_1 retriever) {
        block7: {
            System.out.print("Enter Specific UMLS Years separated by commas ");
            System.out.print("(or leave blank for all): ");
            String years = ClientV2_1.getString(br);
            StringTokenizer tokenizer = new StringTokenizer(years, ",");
            Vector<String> umlsyrs = new Vector<String>();
            while (tokenizer.hasMoreTokens()) {
                umlsyrs.add(tokenizer.nextToken());
            }
            System.out.print("Enter Specific CUIs separated by commas ");
            System.out.print("(or leave blank for all): ");
            String cuistr = ClientV2_1.getString(br);
            tokenizer = new StringTokenizer(cuistr, ",");
            Vector<String> cuis = new Vector<String>();
            while (tokenizer.hasMoreTokens()) {
                cuis.add(tokenizer.nextToken());
            }
            System.out.print("Output contents to 1) the screen or 2) a file: ");
            String output = ClientV2_1.getString(br);
            output = output.toLowerCase();
            boolean screenOutput = true;
            String outputFileName = "";
            if (output.equals("2")) {
                screenOutput = false;
                System.out.print("Enter output file name: ");
                outputFileName = ClientV2_1.getString(br);
            }
            try {
                long start = System.currentTimeMillis();
                char[] result = retriever.describeUMLSChanges(umlsyrs, cuis);
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\tdescribeUMLSChanges ' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (screenOutput) {
                    out.println(xml);
                    break block7;
                }
                ClientV2_1.writeFile(outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println("describeUMLSChanges: DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println("describeUMLSChanges: RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void requestNoArg(BufferedReader br, KSSRetrieverV2_1 retriever, int option) {
        block10: {
            System.out.print("Output contents to 1) the screen or 2) a file: ");
            String output = ClientV2_1.getString(br);
            output = output.toLowerCase();
            boolean screenOutput = true;
            String outputFileName = "";
            if (output.equals("2")) {
                screenOutput = false;
                System.out.print("Enter output file name: ");
                outputFileName = ClientV2_1.getString(br);
            }
            String cmdName = "describeCurrentUMLSVersion";
            try {
                char[] result;
                long start = System.currentTimeMillis();
                switch (option) {
                    case 2: {
                        result = retriever.describeCurrentUMLSVersion();
                        break;
                    }
                    case 3: {
                        result = retriever.describeUMLSVersions();
                        cmdName = "describeUMLSVersions";
                        break;
                    }
                    case 7: {
                        result = retriever.listDictionaries();
                        cmdName = "listDictionaries";
                        break;
                    }
                    default: {
                        return;
                    }
                }
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\t'" + cmdName + "' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (screenOutput) {
                    out.println(xml);
                    break block10;
                }
                ClientV2_1.writeFile(outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println(cmdName + " DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println(cmdName + " RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void writeFile(String outputFileName, String xml) {
        try {
            PrintStream fos = new PrintStream((OutputStream)new FileOutputStream(outputFileName), true, "UTF-8");
            fos.println(xml);
            fos.close();
        }
        catch (IOException ex) {
            System.out.println("IOException: " + ex.getMessage());
        }
    }

    private static void requestSemType(BufferedReader br, KSSRetrieverV2_1 retriever) {
        block5: {
            System.out.print("Enter UMLS Release Year: ");
            String dbYear = ClientV2_1.getString(br);
            System.out.print("Enter semantic type: ");
            String semtype = ClientV2_1.getString(br);
            System.out.print("Output to 1) the screen or 2) a file: ");
            String output = ClientV2_1.getString(br);
            output = output.toLowerCase();
            boolean screenOutput = true;
            String outputFileName = "";
            if (output.equals("2")) {
                screenOutput = false;
                System.out.print("Enter output file name: ");
                outputFileName = ClientV2_1.getString(br);
            }
            try {
                long start = System.currentTimeMillis();
                char[] result = retriever.findCUI(dbYear, semtype);
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\tfindCUI using semantic type '" + semtype + "' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (screenOutput) {
                    out.println(xml);
                    break block5;
                }
                ClientV2_1.writeFile(outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println("findCUI: DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println("findCUI: RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void requestSrcPair(BufferedReader br, KSSRetrieverV2_1 retriever) {
        block5: {
            System.out.print("Enter UMLS Release Year: ");
            String dbYear = ClientV2_1.getString(br);
            System.out.print("Enter source abbreviation: ");
            String src = ClientV2_1.getString(br);
            System.out.print("Enter source unique identifier: ");
            String id = ClientV2_1.getString(br);
            System.out.print("Output to 1) the screen or 2) a file: ");
            String output = ClientV2_1.getString(br);
            output = output.toLowerCase();
            boolean screenOutput = true;
            String outputFileName = "";
            if (output.equals("2")) {
                screenOutput = false;
                System.out.print("Enter output file name: ");
                outputFileName = ClientV2_1.getString(br);
            }
            try {
                long start = System.currentTimeMillis();
                char[] result = retriever.findCUI(dbYear, src, id);
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\tfindCUI using abbrev/id pair  in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (screenOutput) {
                    out.println(xml);
                    break block5;
                }
                ClientV2_1.writeFile(outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println("findCUI: DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println("findCUI: RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void requestCUI(BufferedReader br, KSSRetrieverV2_1 retriever) {
        block8: {
            System.out.println("Request CUI using 1) term name matching, ");
            System.out.print("2) semantic type, or 3) source abbrev/id pair: ");
            String cuiRequest = ClientV2_1.getString(br);
            if (cuiRequest.equals("2")) {
                ClientV2_1.requestSemType(br, retriever);
                return;
            }
            if (cuiRequest.equals("3")) {
                ClientV2_1.requestSrcPair(br, retriever);
                return;
            }
            ClientV2_1Entry entry = ClientV2_1.getInstance().obtainDetails(br, true);
            if (entry == null) {
                return;
            }
            try {
                Iterator iter = entry.cuisOrConNames.iterator();
                StringBuffer buffer = new StringBuffer(4000);
                while (iter.hasNext()) {
                    String termName = (String)iter.next();
                    long start = System.currentTimeMillis();
                    char[] result = retriever.findCUI(entry.dbYear, termName, entry.sabs, entry.language, entry.operator, entry.incSupps);
                    long end = System.currentTimeMillis();
                    long interval = end - start;
                    System.out.println();
                    System.out.println("\tfindCUI for '" + termName + "' in XML took " + interval + " milliseconds");
                    String xml = new String(result);
                    buffer.append(xml);
                }
                if (entry.screenOutput) {
                    out.println(buffer.toString());
                    break block8;
                }
                ClientV2_1.writeFile(entry.outputFileName, buffer.toString());
            }
            catch (DatabaseException ex) {
                System.err.println("findCUI: DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println("findCUI: RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void requestParmed(BufferedReader br, KSSRetrieverV2_1 retriever, int cmdOpt, String prompt, String cmdName) {
        ClientV2_1Entry entry = ClientV2_1.getInstance().obtainDetails(br, prompt);
        if (entry == null) {
            return;
        }
        System.out.print("Enter the ");
        System.out.print(prompt);
        System.out.print(" name: ");
        String arg = ClientV2_1.getString(br);
        Vector cuisToProcess = ClientV2_1.determineCUIs(retriever, entry);
        Iterator iter = cuisToProcess.iterator();
        while (iter.hasNext()) {
            String cui = (String)iter.next();
            ClientV2_1.doRetrieveVal(retriever, cmdOpt, cui, entry, arg, cmdName);
        }
    }

    private static String getString(BufferedReader br) {
        String str = null;
        try {
            str = br.readLine();
        }
        catch (IOException iex) {
            System.err.println("IOException: " + iex.getMessage());
        }
        return str;
    }

    private static Vector multiValPrompt(BufferedReader br, String prompt) {
        Vector<String> values = new Vector<String>();
        System.out.println(prompt);
        String str = null;
        while (!(str = ClientV2_1.getString(br)).equals("")) {
            values.addElement(str);
            if (!str.equals("")) continue;
        }
        return values;
    }

    private static int getOperator(BufferedReader br) {
        int operator = 1;
        System.out.println("Enter matching Criteria: 1 (Exact), 2 (NormStr), 3 (NormWord),");
        System.out.println("      4 (Word), 5 (TrucateRight), 6 (Truncate Left): 7 (ApproximateMatch): ");
        String str = ClientV2_1.getString(br);
        if (str.equals("1")) {
            operator = 1;
        } else if (str.equals("2")) {
            operator = 2;
        } else if (str.equals("3")) {
            operator = 3;
        } else if (str.equals("4")) {
            operator = 4;
        } else if (str.equals("5")) {
            operator = 5;
        } else if (str.equals("6")) {
            operator = 6;
        } else if (str.equals("7")) {
            operator = 7;
        }
        return operator;
    }

    private static void doRetrieveVal(KSSRetrieverV2_1 retriever, int type, String cui, ClientV2_1Entry entry, String arg, String cmdName) {
        block8: {
            try {
                Iterator iter = entry.sabs.iterator();
                String sab = "";
                if (iter.hasNext()) {
                    sab = (String)iter.next();
                }
                long start = System.currentTimeMillis();
                char[] result = null;
                switch (type) {
                    case 1: {
                        result = retriever.getStringAttributes(entry.dbYear, cui, entry.sabs, arg);
                        break;
                    }
                    default: {
                        System.out.println("Invalid selection");
                        return;
                    }
                }
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\t" + cmdName + " for source '" + sab + "' in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (entry.screenOutput) {
                    out.println(xml);
                    break block8;
                }
                ClientV2_1.writeFile(entry.outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static void doRetrieveVal(KSSRetrieverV2_1 retriever, int type, String cui, ClientV2_1Entry entry, String cmdName) {
        block9: {
            Iterator iter = entry.sabs.iterator();
            String sab = "";
            if (iter.hasNext()) {
                sab = (String)iter.next();
            }
            try {
                long start = System.currentTimeMillis();
                char[] result = null;
                switch (type) {
                    case 0: {
                        result = retriever.getAssocExprs(entry.dbYear, cui, entry.sabs);
                        break;
                    }
                    case 6: {
                        result = retriever.getLocators(entry.dbYear, cui);
                        break;
                    }
                    default: {
                        System.out.println("Invalid selection");
                        return;
                    }
                }
                long end = System.currentTimeMillis();
                long interval = end - start;
                System.out.println();
                System.out.println("\t" + cmdName + " in XML took " + interval + " milliseconds");
                String xml = new String(result);
                if (entry.screenOutput) {
                    out.println(xml);
                    break block9;
                }
                ClientV2_1.writeFile(entry.outputFileName, xml);
            }
            catch (DatabaseException ex) {
                System.err.println(cmdName + ": DatabaseException-> " + ex.getMessage());
            }
            catch (RemoteException ex) {
                System.err.println(cmdName + ": RemoteException-> " + ex.getMessage());
            }
        }
    }

    private static Vector doRetrieveCUI(KSSRetrieverV2_1 retriever, String termName, ClientV2_1Entry entry) {
        Vector<String> cuis = new Vector<String>();
        Object cui = null;
        try {
            Iterator iter;
            long start = System.currentTimeMillis();
            char[] result = retriever.findCUI(entry.dbYear, termName, entry.sabs, entry.language, entry.operator, entry.incSupps);
            long end = System.currentTimeMillis();
            long interval = end - start;
            String xml = new String(result);
            ConceptIdVector vec = ConceptIdVector.getInstance(xml);
            if (vec != null && (iter = vec.iterator()).hasNext()) {
                ConceptId cid = (ConceptId)iter.next();
                cuis.add(cid.getCUI());
            }
        }
        catch (DatabaseException ex) {
            System.err.println("doRetrieveCUI: DatabaseException-> " + ex.getMessage());
        }
        catch (RemoteException ex) {
            System.err.println("doRetrieveCUI: RemoteException-> " + ex.getMessage());
        }
        return cuis;
    }

    private ClientV2_1() {
    }

    public static ClientV2_1 getInstance() {
        if (instance == null) {
            instance = new ClientV2_1();
        }
        return instance;
    }

    class ClientV2_1Entry {
        String dbYear;
        public Vector cuisOrConNames;
        public Vector sabs;
        public String language;
        boolean cuiEntered;
        boolean incSupps;
        int operator;
        boolean screenOutput;
        String outputFileName;

        public void output() {
            System.out.println("CUIs/TermNames = " + this.cuisOrConNames);
            System.out.println("SABs = " + this.sabs);
            System.out.println("language = '" + this.language + "'");
            System.out.println("cuiEntered = '" + this.cuiEntered + "'");
            System.out.println("incSupps = '" + this.incSupps + "'");
            System.out.println("operator = '" + this.operator + "'");
        }

        public ClientV2_1Entry(Vector cuis, Vector srcs, String lang, boolean cui, boolean inc, int op) {
            this.cuisOrConNames = cuis;
            this.sabs = srcs;
            this.language = lang;
            this.cuiEntered = cui;
            this.incSupps = inc;
            this.operator = op;
        }

        public ClientV2_1Entry() {
        }
    }
}

