/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models;

import gov.nih.nlm.kss.models.KSStringVector;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Vector;

public class DictionaryVector
extends KSStringVector {
    public static final String XmlName = "DictionaryCollection";
    public static final String XmlStructure = "1.1";
    public static final String XmlDictName = "dictionary";

    public DictionaryVector(String xml) throws XMLException {
        super(XmlName, XmlStructure, XmlDictName);
        this.parse(xml);
    }

    public DictionaryVector(Vector dicts) {
        super(dicts, XmlName, XmlStructure, XmlDictName);
    }

    public DictionaryVector(DictionaryVector dicts) {
        super(dicts, XmlName, XmlStructure, XmlDictName);
    }

    public DictionaryVector() {
        super(XmlName, XmlStructure, XmlDictName);
    }

    public static DictionaryVector getInstance(String xml) {
        DictionaryVector vec = null;
        try {
            vec = new DictionaryVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return vec;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.DictionaryVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream output = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            DictionaryVector vec = DictionaryVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No dictionaries read");
                return;
            }
            System.out.println("Number of dictionaries: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                String entry = (String)iter.next();
                System.out.println("Entry----------------");
                output.println(entry);
                System.out.println("Entry END------------");
            }
            System.out.println("XML Version:");
            output.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

