/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public abstract class KSObject
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    public static final String XmlVersion = "1.0";
    public static final String XmlNamespace = "http://umlsks.nlm.nih.gov";
    private String nameTag = "KSObject";
    private String structure = "1.0";
    private String xmlQuery = "";
    private boolean performance = true;
    private String release = "";

    public KSObject(String xmlTag, String xmlStructVersion) {
        this.structure = xmlStructVersion;
        this.nameTag = xmlTag;
        if (System.getProperty("ShowAllEquivalenceDiffs") != null) {
            this.performance = false;
        }
    }

    public KSObject(KSObject ksobject, String xmlTag, String xmlStructVersion) {
        this.structure = xmlStructVersion;
        this.nameTag = xmlTag;
        this.release = ksobject.getRelease();
        this.xmlQuery = ksobject.getQuery();
        if (System.getProperty("ShowAllEquivalenceDiffs") != null) {
            this.performance = false;
        }
    }

    public KSObject() {
        if (System.getProperty("ShowAllEquivalenceDiffs") != null) {
            this.performance = false;
        }
    }

    protected void parse(String xml) throws XMLException {
        if (System.getProperty("ShowAllEquivalenceDiffs") != null) {
            this.performance = false;
        }
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(this.nameTag)) {
                throw new XMLException(this.nameTag + " must be the name of the first element");
            }
            Attribute attribute = root.getAttribute("version");
            if (attribute == null) {
                throw new XMLException(this.nameTag + " must have a version attribute");
            }
            String version = attribute.getValue();
            if (!version.equals(this.structure)) {
                throw new XMLException(this.nameTag + " version " + this.structure + " is only version supported");
            }
            Element relChild = root.getChild("release", namespace);
            this.release = relChild == null ? "" : XMLInterpreter.extractString(relChild);
            Element queryChild = root.getChild("query", namespace);
            this.xmlQuery = queryChild == null ? "" : this.ingestQuery(xml);
            this.parse(root, namespace);
        }
        catch (JDOMException ex) {
            System.err.println("JDOMException: " + ex.getMessage());
            ex.printStackTrace();
            throw new XMLException(ex.getMessage());
        }
    }

    private String ingestQuery(String xml) {
        String qstr = "<query>";
        int qstart = xml.indexOf(qstr);
        if (qstart == -1) {
            return "";
        }
        int qend = xml.indexOf("</query>");
        if (qend == -1) {
            return "";
        }
        qstart += qstr.length();
        qstr = xml.substring(qstart, qend);
        return qstr.trim();
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        Element queryChild;
        Element releaseChild = root.getChild("release", namespace);
        if (releaseChild != null) {
            this.release = XMLInterpreter.extractString(releaseChild);
        }
        if ((queryChild = root.getChild("query")) != null) {
            this.xmlQuery = new XMLOutputter().outputString(queryChild);
            this.xmlQuery = this.ingestQuery(this.xmlQuery);
        }
    }

    public void setXmlTag(String xmlTag) {
        this.nameTag = xmlTag;
    }

    public String getXmlTag() {
        return this.nameTag;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public String getRelease() {
        return this.release;
    }

    public void setXmlStructure(String xmlStructVersion) {
        this.structure = xmlStructVersion;
    }

    public String getXmlStructure() {
        return this.structure;
    }

    public String xmlize() {
        return this.xmlize(true);
    }

    public String xmlize(boolean doFullXMLDoc) {
        StringBuffer xml = new StringBuffer(100000);
        String tab = "      ";
        if (doFullXMLDoc) {
            xml.append("<?xml version=\"");
            xml.append(XmlVersion);
            xml.append("\" encoding=\"UTF-8\"?>\n");
            xml.append("  <");
            xml.append(this.nameTag);
            xml.append(" version=\"");
            xml.append(this.structure);
            xml.append("\">\n");
        } else {
            xml.append("    <");
            xml.append(this.nameTag);
            xml.append(">\n");
        }
        this.writeQuery(xml);
        this.writeRelease(xml);
        this.writeContents(xml);
        xml.ensureCapacity(xml.length() + 30);
        xml.append("    </");
        xml.append(this.nameTag);
        xml.append(">\n");
        return xml.toString();
    }

    protected void writeRelease(StringBuffer xml) {
        if (this.release == null || this.release.equals("")) {
            return;
        }
        xml.ensureCapacity(this.release.length() + 25);
        xml.append("      <release>");
        xml.append(this.release);
        xml.append("</release>\n");
    }

    protected void writeQuery(StringBuffer xml) {
        if (this.xmlQuery == null || this.xmlQuery.equals("")) {
            return;
        }
        xml.ensureCapacity(this.xmlQuery.length() + 25);
        xml.append("\t<query>\n\t\t");
        xml.append(this.xmlQuery);
        xml.append("\t</query>\n");
    }

    protected abstract void writeContents(StringBuffer var1);

    public Vector xmlVersions() {
        Vector<String> vec = new Vector<String>();
        vec.add(this.structure);
        return vec;
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    protected boolean doCompare(KSComparable val, PrintStream out, boolean equalsFlag) {
        if (!(val instanceof KSObject)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + val.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        KSObject comp = (KSObject)val;
        if (equalsFlag) {
            if (this.release == null && comp.getRelease() != null || this.release != null && comp.getRelease() == null || !this.release.equals(comp.getRelease())) {
                return false;
            }
            if (this.xmlQuery == null && comp.getQuery() != null || this.xmlQuery != null && comp.getQuery() == null || !this.xmlQuery.equals(comp.getQuery())) {
                return false;
            }
        }
        return true;
    }

    public void setQuery(String query) {
        int loc = query.indexOf("?>");
        String q = query;
        if (loc != -1) {
            q = query.substring(loc + 2, query.length());
        }
        this.xmlQuery = q;
    }

    public String getQuery() {
        return this.xmlQuery;
    }

    public String getKey() {
        return new Integer(this.hashCode()).toString();
    }

    public boolean performanceMode() {
        return this.performance;
    }
}

