/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.KSVector;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public abstract class KSStringVector
extends KSVector {
    private String xmlStringTag = "KSStringVector";

    public KSStringVector(Vector vector, String xmlTag, String xmlStructVersion, String strTag) {
        super(vector, xmlTag, xmlStructVersion);
        this.xmlStringTag = strTag;
    }

    public KSStringVector(Vector vector, String strTag) {
        super(vector);
        this.xmlStringTag = strTag;
    }

    public KSStringVector(KSStringVector vector, String xmlTag, String xmlStructVersion, String strTag) {
        super(vector, xmlTag, xmlStructVersion);
        this.xmlStringTag = strTag;
    }

    public KSStringVector(KSStringVector vector, String strTag) {
        super(vector);
        this.xmlStringTag = strTag;
    }

    public KSStringVector(String xmlTag, String xmlStructVersion, String strTag) {
        super(xmlTag, xmlStructVersion);
        this.xmlStringTag = strTag;
    }

    public KSStringVector() {
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        String childName = this.xmlStringTag;
        List entries = root.getChildren(childName, namespace);
        if (entries == null || entries.size() == 0) {
            return;
        }
        int i = 0;
        while (i < entries.size()) {
            Element src = (Element)entries.get(i);
            String entry = XMLInterpreter.extractString(src);
            this.add(entry);
            ++i;
        }
    }

    public void setXmlStringTag(String xmlTag) {
        this.xmlStringTag = xmlTag;
    }

    public String getXmlStringTag() {
        return this.xmlStringTag;
    }

    protected void writeContents(StringBuffer xml) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            String val = (String)iter.next();
            xml.append("   <");
            xml.append(this.xmlStringTag);
            xml.append(">");
            xml.append(Str.escape(val));
            xml.append("</");
            xml.append(this.xmlStringTag);
            xml.append(">\n");
        }
    }

    protected boolean doCompare(KSComparable val, PrintStream out, boolean equalsFlag) {
        if (!super.doCompare(val, out, equalsFlag)) {
            return false;
        }
        if (!(val instanceof KSStringVector)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + val.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        KSStringVector comp = (KSStringVector)val;
        if (comp.size() != this.size()) {
            if (out != null) {
                out.println("Vector sizes are different");
            }
            return false;
        }
        Hashtable compht = this.convert(comp);
        Enumeration compkeys = compht.keys();
        Hashtable thisht = this.convert(this);
        while (compkeys.hasMoreElements()) {
            String compkey = (String)compkeys.nextElement();
            String exp = (String)thisht.get(compkey);
            if (exp == null) {
                if (out != null) {
                    String missing = (String)compht.get(compkey);
                    out.print("Release missing from this instance: ");
                    out.println(missing);
                }
                return false;
            }
            String exp2 = (String)compht.get(compkey);
            if (!exp.equals(exp2)) {
                return false;
            }
            thisht.remove(compkey);
        }
        return true;
    }

    private Hashtable convert(Vector vector) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            String exp = (String)iter.next();
            table.put(exp, exp);
        }
        return table;
    }

    public String getKey() {
        return new Integer(this.hashCode()).toString();
    }
}

