/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.lex;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.nls.lexCheck.Lib.LexRecord;
import java.io.PrintStream;
import java.io.Serializable;

public class LexicalRecord
extends LexRecord
implements Serializable,
Xmlizable,
KSComparable {
    private static final String XmlName = "lexRecord";

    public LexicalRecord(LexRecord record) {
        this.SetAbbreviations(record.GetAbbreviations());
        this.SetAcronyms(record.GetAcronyms());
        this.SetAnnotations(record.GetAnnotations());
        this.SetBase(record.GetBase());
        this.SetCat(record.GetCategory());
        this.SetCatEntry(record.GetCatEntry());
        this.SetEui(record.GetEui());
        this.SetSignature(record.GetSignature());
        this.SetSpellingVars(record.GetSpellingVars());
    }

    public String xmlize() {
        return this.GetXml();
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof LexicalRecord)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        LexicalRecord comp = (LexicalRecord)c;
        boolean ret = true;
        String base = this.GetBase();
        if (!Str.compareStr(base, comp.GetBase())) {
            if (out != null) {
                out.println("this->base='" + base + "' is different from '" + comp.GetBase() + "'");
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        return this.GetEui();
    }
}

