/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.KSObject;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.PrintStream;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class DocEntryType
extends KSObject {
    private String value;
    private String description;
    private String subtype;
    public static final String XmlName = "entry";

    public DocEntryType() {
        super(XmlName, "1.0");
        this.value = "";
        this.description = "";
        this.subtype = "";
    }

    public DocEntryType(String value, String desc, String subtype) {
        super(XmlName, "1.0");
        this.value = value;
        this.description = desc;
        this.subtype = subtype;
    }

    protected void parse(Element entry, Namespace namespace) throws XMLException {
        Element valueChild = entry.getChild("value", namespace);
        if (valueChild == null) {
            throw new XMLException("No concept unique identifier <value> found");
        }
        this.value = XMLInterpreter.extractString(valueChild);
        Element descriptionChild = entry.getChild("description", namespace);
        if (descriptionChild == null) {
            throw new XMLException("No concept unique identifier <description> found");
        }
        this.description = XMLInterpreter.extractString(descriptionChild);
        Element subtypeChild = entry.getChild("subtype", namespace);
        if (subtypeChild == null) {
            throw new XMLException("No concept unique identifier <subtype> found");
        }
        this.subtype = XMLInterpreter.extractString(subtypeChild);
    }

    public static DocEntryType getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("entry must be the name of the first element");
            }
            DocEntryType det = new DocEntryType();
            det.parse(root, namespace);
            return det;
        }
        catch (XMLException ex) {
            throw ex;
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public String xmlize() {
        return this.xmlize(false);
    }

    protected void writeContents(StringBuffer xml) {
        String tab0 = "        ";
        String tab = "           ";
        xml.ensureCapacity(xml.length() + 200);
        xml.append(tab);
        xml.append("<value>");
        xml.append(Str.escape(this.value));
        xml.append("</value>\n");
        xml.append(tab);
        xml.append("<description>");
        xml.append(Str.escape(this.description));
        xml.append("</description>\n");
        xml.append(tab);
        xml.append("<subtype>");
        xml.append(Str.escape(this.subtype));
        xml.append("</subtype>\n");
    }

    protected boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof DocEntryType)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        DocEntryType comp = (DocEntryType)c;
        boolean ret = true;
        if (!Str.compareStr(this.value, comp.getValue())) {
            if (out != null) {
                out.println("this->Value='" + this.value + "' is different from '" + comp.getValue() + "'");
            }
            ret = false;
        }
        ret = true;
        if (!Str.compareStr(this.description, comp.getDescription())) {
            if (out != null) {
                out.println("this->Description='" + this.description + "' is different from '" + comp.getDescription() + "'");
            }
            ret = false;
        }
        ret = true;
        if (!Str.compareStr(this.subtype, comp.getSubtype())) {
            if (out != null) {
                out.println("this->Subtype='" + this.subtype + "' is different from '" + comp.getSubtype() + "'");
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        return this.value + this.subtype;
    }
}

