/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.KSVector;
import gov.nih.nlm.kss.models.meta.DocEntryType;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.PrintStream;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class DocEntryTypeVector
extends KSVector {
    public static final String XmlName = "docEntryTypeList";
    public static final String XmlStructure = "1.0";
    private String listType;

    public DocEntryTypeVector(Vector descs) {
        super(descs, XmlName, XmlStructure);
        if (descs.getClass().getName().equals(this.getClass().getName())) {
            this.listType = ((DocEntryTypeVector)descs).getListType();
        }
    }

    public DocEntryTypeVector(DocEntryTypeVector descs) {
        super(descs, XmlName, XmlStructure);
        this.listType = descs.getListType();
    }

    public DocEntryTypeVector() {
        super(XmlName, XmlStructure);
        this.listType = "";
    }

    public DocEntryTypeVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        Element typeChild = root.getChild("listType", namespace);
        if (typeChild == null) {
            throw new XMLException("No list type <listType> tag found");
        }
        this.listType = XMLInterpreter.extractString(typeChild);
        String childName = "entry";
        List descs = root.getChildren(childName, namespace);
        if (descs == null || descs.size() == 0) {
            return;
        }
        int i = 0;
        while (i < descs.size()) {
            Element edesc = (Element)descs.get(i);
            DocEntryType det = new DocEntryType();
            try {
                det.parse(edesc, namespace);
            }
            catch (XMLException ex) {
                throw new XMLException("Invalid document entry type definition");
            }
            this.add(det);
            ++i;
        }
    }

    public static DocEntryTypeVector getInstance(String xml) {
        DocEntryTypeVector aev = null;
        try {
            aev = new DocEntryTypeVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return aev;
    }

    public void writeContents(StringBuffer xml) {
        if (this.listType != null && !this.listType.equals("")) {
            xml.ensureCapacity(xml.length() + 30 + this.listType.length());
            xml.append("    <listType>");
            xml.append(Str.escape(this.listType));
            xml.append("</listType>\n");
        }
        super.writeContents(xml);
    }

    public void setListType(String listType) {
        this.listType = listType;
    }

    public String getListType() {
        return this.listType;
    }

    protected boolean doCompare(KSComparable val, PrintStream out, boolean equalsFlag) {
        if (!(val instanceof DocEntryTypeVector)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + val.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        DocEntryTypeVector comp = (DocEntryTypeVector)val;
        boolean ret = true;
        if (!Str.compareStr(this.listType, comp.getListType())) {
            if (out != null) {
                out.println("this->listType=" + this.listType + " is different from " + comp.getListType());
            }
            ret = false;
            if (this.performanceMode()) {
                return ret;
            }
        }
        return ret & super.doCompare(val, out, equalsFlag);
    }

    public String xmlize() {
        return this.xmlize(false);
    }

    public String getKey() {
        return this.listType;
    }
}

