/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.attribute;

import gov.nih.nlm.kss.models.KSVector;
import gov.nih.nlm.kss.models.meta.attribute.Attr;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class AttrVector
extends KSVector {
    public static final String XmlName = "StringAttrListing";
    public static final String XmlStructure = "1.0";

    public AttrVector(Vector srcs) {
        super(srcs, XmlName, XmlStructure);
    }

    public AttrVector(AttrVector srcs) {
        super(srcs, XmlName, XmlStructure);
    }

    public AttrVector() {
        super(XmlName, XmlStructure);
    }

    public AttrVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        String childName = "stringAttr";
        List attrs = root.getChildren(childName, namespace);
        if (attrs == null || attrs.size() == 0) {
            return;
        }
        int i = 0;
        while (i < attrs.size()) {
            Element src = (Element)attrs.get(i);
            Attr attr = new Attr(src, namespace);
            if (attr == null) {
                throw new XMLException("Invalid attr definition");
            }
            this.add(attr);
            ++i;
        }
    }

    public static AttrVector getInstance(String xml) {
        AttrVector aev = null;
        try {
            aev = new AttrVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return aev;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.meta.attribute.AttrVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream output = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            AttrVector vec = AttrVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No attributes read");
                return;
            }
            System.out.println("Number of attributes: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                Attr attr = (Attr)iter.next();
                System.out.println("Attr----------------");
                output.println(new String(attr.xmlize()));
                System.out.println("Attr END------------");
            }
            System.out.println("XML Version:");
            output.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

