/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.attribute;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.attribute.AttributeValue;
import gov.nih.nlm.kss.models.meta.source.Source;
import gov.nih.nlm.kss.util.CompareUtil;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class AttributeContext
extends XMLInterpreter
implements Serializable,
KSComparable,
Xmlizable {
    public static final String XmlName = "source";
    private String scd;
    private String type;
    private String ui;
    private Source so;
    private Vector attribs;

    public AttributeContext() {
        this.type = "";
        this.ui = "";
        this.scd = "";
        this.so = null;
        this.attribs = new Vector();
    }

    public AttributeContext(String ui, String type, String scd, Source so) {
        this.ui = ui;
        this.type = type;
        this.scd = scd;
        this.so = so;
        this.attribs = new Vector();
    }

    public AttributeContext(String scd, Source so) {
        this.ui = "";
        this.type = "";
        this.scd = scd;
        this.so = so;
        this.attribs = new Vector();
    }

    public AttributeContext(Element ac, Namespace namespace) throws XMLException {
        Element uiChild = ac.getChild("ui", namespace);
        this.ui = uiChild != null ? XMLInterpreter.extractString(uiChild) : "";
        Element typeChild = ac.getChild("type", namespace);
        this.type = typeChild != null ? XMLInterpreter.extractString(typeChild) : "";
        Element scdChild = ac.getChild("scd", namespace);
        this.scd = scdChild != null ? XMLInterpreter.extractString(scdChild) : "";
        Element sabChild = ac.getChild("sab", namespace);
        if (sabChild == null) {
            throw new XMLException("No source abbreviation <sab> found");
        }
        String sab = XMLInterpreter.extractString(sabChild);
        this.so = new Source(sab, "", "");
        List strs = ac.getChildren("attributes", namespace);
        int i = 0;
        while (i < strs.size()) {
            Element saElement = (Element)strs.get(i);
            AttributeValue t = new AttributeValue(saElement, namespace);
            if (t == null) {
                throw new XMLException("Unable to parse attribute value\n");
            }
            this.addAttrib(t);
            ++i;
        }
    }

    public static AttributeContext getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("source must be the name of the first element");
            }
            return new AttributeContext(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public String getUI() {
        return this.ui;
    }

    public void setUI(String ui) {
        this.ui = ui;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSCD() {
        return this.scd;
    }

    public void setSCD(String scd) {
        this.scd = scd;
    }

    public Source getSource() {
        return this.so;
    }

    public void setSource(Source src) {
        this.so = src;
    }

    public Vector getAttribs() {
        return this.attribs;
    }

    public void setAttribs(Vector attribs) {
        this.attribs = attribs;
    }

    public void addAttrib(AttributeValue attrib) {
        if (this.attribs == null) {
            this.attribs = new Vector();
        }
        this.attribs.addElement(attrib);
    }

    public void output() {
        PrintStream output;
        try {
            output = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            output = new PrintStream(System.out);
        }
        String tab = "         ";
        output.println("");
        output.println(tab + "UI    : " + this.getUI());
        output.println(tab + "Type  : " + this.getType());
        output.println(tab + "SoCode: " + this.getSCD());
        output.println(tab + "SAB   : " + this.so.getRSAB());
        Iterator vIter = this.getAttribs().iterator();
        while (vIter.hasNext()) {
            ((AttributeValue)vIter.next()).output();
        }
    }

    public String xmlize() {
        String tab0 = "            ";
        String tab = "               ";
        StringBuffer xml = new StringBuffer(100000);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        if (this.ui != null && !this.ui.equals("")) {
            xml.append(tab);
            xml.append("<ui>");
            xml.append(Str.escape(this.ui));
            xml.append("</ui>\n");
        }
        if (this.type != null && !this.type.equals("")) {
            xml.append(tab);
            xml.append("<type>");
            xml.append(Str.escape(this.type));
            xml.append("</type>\n");
        }
        if (this.scd != null && !this.scd.equals("")) {
            xml.append(tab);
            xml.append("<scd>");
            xml.append(Str.escape(this.scd));
            xml.append("</scd>\n");
        }
        xml.append(tab);
        xml.append("<sab>");
        xml.append(this.so.getRSAB());
        xml.append("</sab>\n");
        if (this.attribs != null) {
            Iterator vIter = this.attribs.iterator();
            while (vIter.hasNext()) {
                xml.append(((AttributeValue)vIter.next()).xmlize());
            }
        }
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
        return xml.toString();
    }

    public static String xmlize(String scd, String sab, Vector attribs) {
        AttributeContext cxt = new AttributeContext("", "", scd, new Source(sab, "", ""));
        cxt.setAttribs(attribs);
        return cxt.xmlize();
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof AttributeContext)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        AttributeContext comp = (AttributeContext)c;
        if (!Str.compareStr(this.getUI(), comp.getUI())) {
            if (out != null) {
                out.println("this->UI='" + this.getUI() + "' different from '" + comp.getUI() + "'");
            }
            return false;
        }
        if (!Str.compareStr(this.getType(), comp.getType())) {
            if (out != null) {
                out.println("this->Type='" + this.getType() + "' different from '" + comp.getType() + "'");
            }
            return false;
        }
        if (!Str.compareStr(this.scd, comp.getSCD())) {
            if (out != null) {
                out.println("this->SCD='" + this.scd + "' different from '" + comp.getSCD() + "'");
            }
            return false;
        }
        String tsab = this.getSource().getRSAB();
        String csab = comp.getSource().getRSAB();
        if (!equalsFlag) {
            tsab = CompareUtil.logicalEquivSAB(tsab);
            csab = CompareUtil.logicalEquivSAB(csab);
        }
        if (!Str.compareStr(tsab, csab)) {
            if (out != null) {
                out.println("this->RSAB='" + this.getSource().getRSAB() + "' is different from '" + comp.getSource().getRSAB() + "'");
            }
            return false;
        }
        Vector attrs = comp.getAttribs();
        if (this.attribs == null && attrs != null || this.attribs != null && attrs == null || this.attribs.size() != attrs.size()) {
            if (out != null) {
                out.println("AttributeValues vector different sizes");
            }
            return false;
        }
        Hashtable compht = this.convert(attrs);
        Enumeration compkeys = compht.keys();
        Hashtable thisht = this.convert(this.attribs);
        while (compkeys.hasMoreElements()) {
            String compkey = (String)compkeys.nextElement();
            AttributeValue val = (AttributeValue)thisht.get(compkey);
            if (val == null) {
                if (out != null) {
                    AttributeValue missing = (AttributeValue)compht.get(compkey);
                    out.println("AttributeValue missing from this instance:");
                    out.println(missing.xmlize());
                }
                return false;
            }
            AttributeValue val2 = (AttributeValue)compht.get(compkey);
            if (equalsFlag) {
                if (!val.equals(val2, out)) {
                    if (out != null) {
                        out.println("AttributeValues differ. This instance:");
                        out.println(val.xmlize());
                        out.println("Comparison instance:");
                        out.println(val2.xmlize());
                    }
                    return false;
                }
            } else if (!val.equivalent(val2, out)) {
                if (out != null) {
                    out.println("AttributeValues differ. This instance:");
                    out.println(val.xmlize());
                    out.println("Comparison instance:");
                    out.println(val2.xmlize());
                }
                return false;
            }
            thisht.remove(compkey);
        }
        return true;
    }

    private Hashtable convert(Vector vector) {
        Hashtable<String, AttributeValue> table = new Hashtable<String, AttributeValue>();
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            AttributeValue val = (AttributeValue)iter.next();
            table.put(val.getKey(), val);
        }
        return table;
    }

    public String getKey() {
        if (this.ui != null && this.type != null) {
            return this.ui + this.type + this.scd;
        }
        return this.scd;
    }
}

