/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.attribute;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.attribute.AttributeContext;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class ConceptAttribute
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    private Vector attribs;
    private String cui;
    private boolean performance;
    public static final String XmlName = "conceptAttributes";

    public ConceptAttribute() {
        this.attribs = new Vector();
        this.cui = "";
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public ConceptAttribute(ConceptAttribute ta) {
        this.attribs = new Vector();
        this.cui = "";
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public ConceptAttribute(Element cui, Namespace namespace) throws XMLException {
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
        List strs = cui.getChildren("source", namespace);
        int i = 0;
        while (i < strs.size()) {
            Element saElement = (Element)strs.get(i);
            AttributeContext t = new AttributeContext(saElement, namespace);
            if (t == null) {
                throw new XMLException("Unable to parse attribute context\n");
            }
            this.addAttrib(t);
            ++i;
        }
    }

    public static ConceptAttribute getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("conceptAttributes must be the name of the first element");
            }
            return new ConceptAttribute(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setCUI(String cui) {
        this.cui = cui;
    }

    public String getCUI() {
        return this.cui;
    }

    public Vector getAttribs() {
        return this.attribs;
    }

    public void setAttribs(Vector attribs) {
        this.attribs = attribs;
    }

    public void addAttrib(AttributeContext attrib) {
        if (this.attribs == null) {
            this.attribs = new Vector();
        }
        this.attribs.addElement(attrib);
    }

    public void output() {
        PrintStream output;
        try {
            output = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            output = new PrintStream(System.out);
        }
        String tab = "   ";
        output.println("");
        output.println("CUI: " + this.cui);
        Vector attribs = this.getAttribs();
        if (attribs == null) {
            return;
        }
        Iterator vIter = attribs.iterator();
        while (vIter.hasNext()) {
            ((AttributeContext)vIter.next()).output();
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(10000);
        String tab0 = "      ";
        String tab = "         ";
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.ensureCapacity(xml.length() + 30);
        if (this.attribs != null) {
            Iterator vIter = this.attribs.iterator();
            while (vIter.hasNext()) {
                xml.append(((AttributeContext)vIter.next()).xmlize());
            }
        }
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append("\n");
        return xml.toString();
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof ConceptAttribute)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        ConceptAttribute comp = (ConceptAttribute)c;
        boolean ret = true;
        if (!Str.compareStr(this.getCUI(), comp.getCUI())) {
            if (out != null) {
                out.println("this->CUI='" + this.getCUI() + "' is different from '" + comp.getCUI() + "'");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        Vector attrs = comp.getAttribs();
        if (this.attribs == null && attrs != null || this.attribs != null && attrs == null || this.attribs.size() != attrs.size()) {
            if (out != null) {
                out.println("AttributeContexts are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (attrs == null && this.attribs == null) {
            return ret;
        }
        Hashtable compht = this.convert(attrs);
        Enumeration compkeys = compht.keys();
        Hashtable thisht = this.convert(this.attribs);
        while (compkeys.hasMoreElements()) {
            String compkey = (String)compkeys.nextElement();
            AttributeContext val = (AttributeContext)thisht.get(compkey);
            if (val == null) {
                if (out != null) {
                    AttributeContext missing = (AttributeContext)compht.get(compkey);
                    out.println("AttributeContext missing from this instance:");
                    out.println(missing.xmlize());
                }
                ret = false;
                if (!this.performance) continue;
                return ret;
            }
            AttributeContext val2 = (AttributeContext)compht.get(compkey);
            if (equalsFlag) {
                if (!val.equals(val2, out)) {
                    ret = false;
                    if (this.performance) {
                        return ret;
                    }
                }
            } else if (!val.equivalent(val2, out)) {
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
            thisht.remove(compkey);
        }
        Enumeration thiskeys = thisht.keys();
        while (thiskeys.hasMoreElements()) {
            ret = false;
            if (this.performance) {
                return ret;
            }
            String thiskey = (String)thiskeys.nextElement();
            AttributeContext val = (AttributeContext)thisht.get(thiskey);
            if (out == null) continue;
            AttributeContext added = (AttributeContext)thisht.get(thiskey);
            out.println("AttributeContext added to this instance:");
            out.println(added.xmlize());
        }
        return ret;
    }

    private Hashtable convert(Vector vector) {
        Hashtable<String, AttributeContext> table = new Hashtable<String, AttributeContext>();
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            AttributeContext val = (AttributeContext)iter.next();
            table.put(val.getSCD() + val.getSource().getRSAB() + val.getUI(), val);
        }
        return table;
    }

    public String getKey() {
        return this.cui;
    }
}

