/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.attribute;

import gov.nih.nlm.kss.models.KSCuiVector;
import gov.nih.nlm.kss.models.meta.attribute.ConceptAttribute;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class ConceptAttributeVector
extends KSCuiVector {
    public static final String XmlName = "ConceptAttributeCollection";
    public static final String XmlStructure = "1.0";
    static /* synthetic */ Class class$gov$nih$nlm$kss$models$meta$attribute$ConceptAttributeVector;

    public ConceptAttributeVector(Vector attrs) {
        super(attrs, XmlName, XmlStructure);
    }

    public ConceptAttributeVector(ConceptAttributeVector attrs) {
        super(attrs, XmlName, XmlStructure);
    }

    public ConceptAttributeVector() {
        super(XmlName, XmlStructure);
    }

    public ConceptAttributeVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        super.parse(root, namespace);
        String childName = "conceptAttributes";
        List concepts = root.getChildren(childName, namespace);
        if (concepts != null && concepts.size() > 0) {
            int i = 0;
            while (i < concepts.size()) {
                Element conceptEle = (Element)concepts.get(i);
                ConceptAttribute concept = new ConceptAttribute(conceptEle, namespace);
                if (concept == null) {
                    throw new XMLException("Invalid concept attribute definition");
                }
                concept.setCUI(this.getCUI());
                this.add(concept);
                ++i;
            }
        }
    }

    public static ConceptAttributeVector getInstance(String xml) {
        ConceptAttributeVector cv = null;
        try {
            cv = new ConceptAttributeVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return cv;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print((class$gov$nih$nlm$kss$models$meta$attribute$ConceptAttributeVector == null ? (class$gov$nih$nlm$kss$models$meta$attribute$ConceptAttributeVector = ConceptAttributeVector.class$("gov.nih.nlm.kss.models.meta.attribute.ConceptAttributeVector")) : class$gov$nih$nlm$kss$models$meta$attribute$ConceptAttributeVector).getName());
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            ConceptAttributeVector vec = ConceptAttributeVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No concepts read");
                return;
            }
            System.out.println("Number of concept attributes: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                ConceptAttribute term = (ConceptAttribute)iter.next();
                System.out.println("ConceptAttribute----------------");
                term.output();
                System.out.println("ConceptAttribute END------------");
            }
            System.out.println("XML Version:");
            out.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

