/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.attribute;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.attribute.AttributeContext;
import gov.nih.nlm.kss.models.meta.concept.StringInfo;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class StringAttribute
extends XMLInterpreter
implements Serializable,
KSComparable,
Xmlizable {
    public static final String XmlName = "stringAttributes";
    private StringInfo stringInfo;
    private Vector attribs;
    private boolean performance;

    public StringAttribute() {
        this.stringInfo = null;
        this.attribs = new Vector();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public StringAttribute(StringInfo stringInfo) {
        this.stringInfo = stringInfo;
        this.attribs = new Vector();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public StringAttribute(Element sa, Namespace namespace) throws XMLException {
        Element suiChild;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
        if ((suiChild = sa.getChild("sui", namespace)) == null) {
            throw new XMLException("No string unique identifier <sui> found");
        }
        String sui = XMLInterpreter.extractString(suiChild);
        Element strChild = sa.getChild("str", namespace);
        if (strChild == null) {
            throw new XMLException("No string value <str> found");
        }
        String str = XMLInterpreter.extractString(strChild);
        this.stringInfo = new StringInfo(sui, "", str);
        List cxts = sa.getChildren("source", namespace);
        int i = 0;
        while (i < cxts.size()) {
            Element acElement = (Element)cxts.get(i);
            AttributeContext t = new AttributeContext(acElement, namespace);
            if (t == null) {
                throw new XMLException("Unable to parse attribute context\n");
            }
            this.addAttrib(t);
            ++i;
        }
    }

    public static StringAttribute getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("stringAttributes must be the name of the first element");
            }
            return new StringAttribute(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public String getSUI() {
        if (this.stringInfo == null) {
            return "";
        }
        return this.stringInfo.getSUI();
    }

    public String getSTR() {
        if (this.stringInfo == null) {
            return "";
        }
        return this.stringInfo.getSTR();
    }

    public StringInfo getStringInfo() {
        return this.stringInfo;
    }

    public void setStringInfo(StringInfo info) {
        this.stringInfo = info;
    }

    public Vector getAttribs() {
        return this.attribs;
    }

    public void setAttribs(Vector attribs) {
        this.attribs = attribs;
    }

    public void addAttrib(AttributeContext attrib) {
        if (this.attribs == null) {
            this.attribs = new Vector();
        }
        this.attribs.addElement(attrib);
    }

    public void output() {
        PrintStream output;
        try {
            output = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            output = new PrintStream(System.out);
        }
        String tab = "\t  ";
        output.println("");
        output.println(tab + "SUI:        " + this.getSUI());
        output.println(tab + "STR:        " + this.getSTR());
        Vector attribs = this.getAttribs();
        if (attribs != null) {
            Iterator vIter = attribs.iterator();
            while (vIter.hasNext()) {
                ((AttributeContext)vIter.next()).output();
            }
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(100000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        String tab0 = "         ";
        String tab = "            ";
        xml.ensureCapacity(xml.length() + 100);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab);
        xml.append("<sui>");
        xml.append(this.stringInfo.getSUI());
        xml.append("</sui>\n");
        xml.ensureCapacity(xml.length() + 300);
        xml.append(tab);
        xml.append("<str>");
        xml.append(Str.escape(this.stringInfo.getSTR()));
        xml.append("</str>\n");
        if (this.attribs != null) {
            Iterator vIter = this.attribs.iterator();
            while (vIter.hasNext()) {
                xml.append(((AttributeContext)vIter.next()).xmlize());
            }
        }
        xml.ensureCapacity(xml.length() + 100);
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public static void xmlize(StringBuffer xml, String sui, String str, Vector attribs) {
        StringAttribute attr = new StringAttribute(new StringInfo(sui, "", str));
        attr.setAttribs(attribs);
        String xmlstr = attr.xmlize();
        xml.append(xmlstr);
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof StringAttribute)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        StringAttribute comp = (StringAttribute)c;
        boolean ret = true;
        StringInfo cstrinfo = comp.getStringInfo();
        if (cstrinfo != null && this.stringInfo == null || cstrinfo == null && this.stringInfo != null) {
            if (out != null) {
                out.println("StringInfo doens't match");
            }
            return false;
        }
        if (this.stringInfo != null && cstrinfo != null && !this.stringInfo.equals(cstrinfo, out)) {
            return false;
        }
        Vector attrs = comp.getAttribs();
        if (this.attribs == null && attrs != null || this.attribs != null && attrs == null) {
            if (out != null) {
                out.println("AttributeContexts are different");
            }
            return false;
        }
        if (attrs == null && this.attribs == null) {
            return true;
        }
        if (this.attribs.size() != attrs.size()) {
            return false;
        }
        Hashtable compht = this.convert(attrs);
        Enumeration compkeys = compht.keys();
        Hashtable thisht = this.convert(this.attribs);
        while (compkeys.hasMoreElements()) {
            String compkey = (String)compkeys.nextElement();
            AttributeContext val = (AttributeContext)thisht.get(compkey);
            if (val == null) {
                if (out != null) {
                    AttributeContext missing = (AttributeContext)compht.get(compkey);
                    out.println("AttributeContext missing from this instance:");
                    out.println(missing.xmlize());
                }
                ret = false;
                if (!this.performance) continue;
                return ret;
            }
            AttributeContext val2 = (AttributeContext)compht.get(compkey);
            if (equalsFlag) {
                if (!val.equals(val2, out)) {
                    ret = false;
                    if (this.performance) {
                        return ret;
                    }
                }
            } else if (!val.equivalent(val2, out)) {
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
            thisht.remove(compkey);
        }
        Enumeration thiskeys = thisht.keys();
        while (thiskeys.hasMoreElements()) {
            ret = false;
            if (this.performance) {
                return ret;
            }
            String thiskey = (String)thiskeys.nextElement();
            AttributeContext val = (AttributeContext)thisht.get(thiskey);
            if (out == null) continue;
            AttributeContext added = (AttributeContext)thisht.get(thiskey);
            out.println("AttributeContext added to this instance:");
            out.println(added.xmlize());
        }
        return ret;
    }

    private Hashtable convert(Vector vector) {
        Hashtable<String, AttributeContext> table = new Hashtable<String, AttributeContext>();
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            AttributeContext val = (AttributeContext)iter.next();
            table.put(val.getKey(), val);
        }
        return table;
    }

    public String getKey() {
        return this.stringInfo.getSUI() + this.stringInfo.getSTT();
    }
}

