/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.attribute;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.attribute.StringAttribute;
import gov.nih.nlm.kss.models.meta.concept.Concept;
import gov.nih.nlm.kss.models.meta.concept.StringInfo;
import gov.nih.nlm.kss.models.meta.concept.Term;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class TermAttribute
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    private Concept con;
    private String lui = "";
    private Term term;
    private Vector attribs;
    private boolean performance;
    public static final String XmlName = "termAttributes";

    public TermAttribute() {
        this.con = null;
        this.term = null;
        this.attribs = new Vector();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public TermAttribute(Concept con, Term term) {
        this.con = con;
        this.term = term;
        this.attribs = new Vector();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public TermAttribute(TermAttribute ta) {
        this.con = ta.getCon();
        this.term = ta.getTerm();
        this.attribs = new Vector();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public TermAttribute(Element term, Namespace namespace) throws XMLException {
        Element luiChild;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
        if ((luiChild = term.getChild("lui", namespace)) == null) {
            throw new XMLException("No term unique identifier <lui> found");
        }
        this.lui = XMLInterpreter.extractString(luiChild);
        List strs = term.getChildren("stringAttributes", namespace);
        int i = 0;
        while (i < strs.size()) {
            Element saElement = (Element)strs.get(i);
            StringAttribute t = new StringAttribute(saElement, namespace);
            if (t == null) {
                throw new XMLException("Unable to parse string attribute\n");
            }
            this.addAttrib(t);
            ++i;
        }
    }

    public static TermAttribute getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("termAttributes must be the name of the first element");
            }
            return new TermAttribute(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public Concept getCon() {
        return this.con;
    }

    public void setCon(Concept c1) {
        this.con = c1;
        if (c1 != null) {
            this.term = c1.getTerm(this.lui);
        }
    }

    public Term getTerm() {
        return this.term;
    }

    public void setTerm(Term t1) {
        this.term = t1;
    }

    public String getLUI() {
        if (this.term == null) {
            return this.lui;
        }
        return this.term.getLUI();
    }

    public Vector getAttribs() {
        return this.attribs;
    }

    public void setAttribs(Vector attribs) {
        this.attribs = attribs;
    }

    public void addAttrib(StringAttribute attrib) {
        if (this.attribs == null) {
            this.attribs = new Vector();
        }
        this.attribs.addElement(attrib);
    }

    public void output() {
        PrintStream output;
        try {
            output = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            output = new PrintStream(System.out);
        }
        String tab = "   ";
        output.println("");
        output.println(tab + "LUI:        " + this.getLUI());
        Vector attribs = this.getAttribs();
        if (attribs == null) {
            return;
        }
        Iterator vIter = attribs.iterator();
        while (vIter.hasNext()) {
            ((StringAttribute)vIter.next()).output();
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(10000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        TermAttribute.xmlize(xml, this.getLUI(), this.getAttribs());
    }

    protected static void xmlize(StringBuffer xml, String lui, Vector attribs) {
        String tab0 = "      ";
        String tab = "         ";
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab);
        xml.append("<lui>");
        xml.append(lui);
        xml.append("</lui>\n");
        if (attribs != null) {
            Iterator vIter = attribs.iterator();
            while (vIter.hasNext()) {
                ((StringAttribute)vIter.next()).xmlize(xml);
            }
        }
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append("\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof TermAttribute)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        TermAttribute comp = (TermAttribute)c;
        boolean ret = true;
        if (!Str.compareStr(this.getLUI(), comp.getLUI())) {
            if (out != null) {
                out.println("this->LUI='" + this.getLUI() + "' is different from '" + comp.getLUI() + "'");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        Vector attrs = comp.getAttribs();
        if (this.attribs == null && attrs != null || this.attribs != null && attrs == null || this.attribs.size() != attrs.size()) {
            if (out != null) {
                out.println("StringAttributes are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (attrs == null && this.attribs == null) {
            return ret;
        }
        Hashtable compht = this.convert(attrs);
        Enumeration compkeys = compht.keys();
        Hashtable thisht = this.convert(this.attribs);
        while (compkeys.hasMoreElements()) {
            String compkey = (String)compkeys.nextElement();
            StringAttribute val = (StringAttribute)thisht.get(compkey);
            if (val == null) {
                if (out != null) {
                    StringAttribute missing = (StringAttribute)compht.get(compkey);
                    out.println("StringAttribute missing from this instance:");
                    out.println(missing.xmlize());
                }
                ret = false;
                if (!this.performance) continue;
                return ret;
            }
            StringAttribute val2 = (StringAttribute)compht.get(compkey);
            if (equalsFlag) {
                if (!val.equals(val2, out)) {
                    ret = false;
                    if (this.performance) {
                        return ret;
                    }
                }
            } else if (!val.equivalent(val2, out)) {
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
            thisht.remove(compkey);
        }
        Enumeration thiskeys = thisht.keys();
        while (thiskeys.hasMoreElements()) {
            ret = false;
            if (this.performance) {
                return ret;
            }
            String thiskey = (String)thiskeys.nextElement();
            StringAttribute val = (StringAttribute)thisht.get(thiskey);
            if (out == null) continue;
            StringAttribute added = (StringAttribute)thisht.get(thiskey);
            out.println("StringAttribute added to this instance:");
            out.println(added.xmlize());
        }
        return ret;
    }

    private Hashtable convert(Vector vector) {
        Hashtable<String, StringAttribute> table = new Hashtable<String, StringAttribute>();
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            StringAttribute val = (StringAttribute)iter.next();
            StringInfo si = val.getStringInfo();
            if (si == null) continue;
            table.put(si.getSUI(), val);
        }
        return table;
    }

    public String getKey() {
        return this.lui;
    }
}

