/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.concept;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.util.CompareUtil;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class ConceptId
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    private String cui;
    private String cn;
    public static final String XmlName = "conceptId";

    public ConceptId() {
        this.cui = "";
        this.cn = "";
    }

    public ConceptId(String cui, String cn) {
        this.cui = cui;
        this.cn = cn;
    }

    public ConceptId(Element concept, Namespace namespace) throws XMLException {
        Element cuiChild = concept.getChild("cui", namespace);
        if (cuiChild == null) {
            throw new XMLException("No concept unique identifier found");
        }
        this.cui = XMLInterpreter.extractString(cuiChild);
        Element cnChild = concept.getChild("cn", namespace);
        if (cnChild == null) {
            throw new XMLException("No concept name found");
        }
        this.cn = XMLInterpreter.extractString(cnChild);
    }

    public static ConceptId getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("conceptId must be  the name of the first element");
            }
            return new ConceptId(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setCUI(String cui) {
        this.cui = cui;
    }

    public String getCUI() {
        return this.cui;
    }

    public void setCN(String cn) {
        this.cn = cn;
    }

    public String getCN() {
        return this.cn;
    }

    public String toString() {
        return this.xmlize();
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        out.println("CUI:      " + this.cui);
        out.println("Name:     " + this.cn);
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(100000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        String tab0 = "   ";
        String tab = "      ";
        xml.ensureCapacity(xml.length() + 380);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab);
        xml.append("<cui>");
        xml.append(this.cui);
        xml.append("</cui>\n");
        xml.append(tab);
        xml.append("<cn>");
        xml.append(Str.escape(this.getCN()));
        xml.append("</cn>\n");
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof ConceptId)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        ConceptId comp = (ConceptId)c;
        boolean ret = true;
        if (!Str.compareStr(this.cui, comp.getCUI())) {
            if (out != null) {
                out.println("this->CUI='" + this.cui + "' is different from '" + comp.getCUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(CompareUtil.logicalEquivCN(this.cn), CompareUtil.logicalEquivCN(comp.getCN()))) {
            if (out != null) {
                out.println("this->CN='" + this.cn + "' is different from '" + comp.getCN() + "'");
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        return this.cui + this.cn;
    }
}

