/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.concept;

import gov.nih.nlm.kss.models.KSVector;
import gov.nih.nlm.kss.models.meta.concept.ConceptId;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class ConceptIdVector
extends KSVector {
    public static final String XmlName = "ConceptIdCollection";
    public static final String XmlStructure = "1.0";

    public ConceptIdVector(Vector ids) {
        super(ids, XmlName, XmlStructure);
    }

    public ConceptIdVector(ConceptIdVector ids) {
        super(ids, XmlName, XmlStructure);
    }

    public ConceptIdVector() {
        super(XmlName, XmlStructure);
    }

    public ConceptIdVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        String childName = "conceptId";
        List ids = root.getChildren(childName, namespace);
        if (ids == null || ids.size() == 0) {
            return;
        }
        int i = 0;
        while (i < ids.size()) {
            Element idEle = (Element)ids.get(i);
            ConceptId id = new ConceptId(idEle, namespace);
            if (id == null) {
                throw new XMLException("Invalid concept id definition");
            }
            this.add(id);
            ++i;
        }
    }

    public static ConceptIdVector getInstance(String xml) {
        ConceptIdVector cv = null;
        try {
            cv = new ConceptIdVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return cv;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.meta.concept.ConceptIdVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            ConceptIdVector vec = ConceptIdVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No ids read");
                return;
            }
            System.out.println("Number of ids: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                ConceptId id = (ConceptId)iter.next();
                System.out.println("ConceptId----------------");
                id.output();
                System.out.println("ConceptId END------------");
            }
            System.out.println("XML Version:");
            out.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

