/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.concept;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.util.CompareUtil;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class Definition
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    public static final String XmlName = "definition";
    private String sab;
    private String def;
    private String aui;
    private String atui;
    private String satui;

    public Definition() {
        this.sab = "";
        this.def = "";
        this.aui = "";
        this.atui = "";
        this.satui = "";
    }

    public Definition(String sab, String def) {
        this.sab = sab;
        this.def = def;
    }

    public Definition(Element defn, Namespace namespace) throws XMLException {
        Element satuiChild;
        Element atuiChild;
        Element sabChild = defn.getChild("sab", namespace);
        if (sabChild == null) {
            throw new XMLException("No source abbreviation <sab> found");
        }
        this.sab = XMLInterpreter.extractString(sabChild);
        Element defChild = defn.getChild("def", namespace);
        if (defChild == null) {
            throw new XMLException("No definition <def> found");
        }
        this.def = XMLInterpreter.extractString(defChild);
        Element auiChild = defn.getChild("aui", namespace);
        if (auiChild != null) {
            this.aui = XMLInterpreter.extractString(auiChild);
        }
        if ((atuiChild = defn.getChild("atui", namespace)) != null) {
            this.atui = XMLInterpreter.extractString(atuiChild);
        }
        if ((satuiChild = defn.getChild("satui", namespace)) != null) {
            this.satui = XMLInterpreter.extractString(satuiChild);
        }
    }

    public static Definition getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("definition must be the name of the first element");
            }
            return new Definition(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setSAB(String sab) {
        this.sab = sab;
    }

    public String getSAB() {
        return this.sab;
    }

    public void setDEF(String def) {
        this.def = def;
    }

    public String getDEF() {
        return this.def;
    }

    public void setAUI(String aui) {
        this.aui = aui;
    }

    public String getAUI() {
        return this.aui;
    }

    public void setATUI(String atui) {
        this.atui = atui;
    }

    public String getATUI() {
        return this.atui;
    }

    public void setSATUI(String satui) {
        this.satui = satui;
    }

    public String getSATUI() {
        return this.satui;
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        out.println("SAB:      " + this.sab);
        out.println("DEF:      " + this.def);
        out.println("AUI:      " + this.aui);
        out.println("ATUI:     " + this.atui);
        out.println("SATUI:    " + this.satui);
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(10000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        String tab0 = "      ";
        String tab = "         ";
        xml.ensureCapacity(xml.length() + 4000);
        xml.append(tab0);
        xml.append("<definition>\n");
        xml.append(tab);
        xml.append("<sab>");
        xml.append(this.sab);
        xml.append("</sab>\n");
        xml.append(tab);
        xml.append("<def>");
        xml.append(Str.escape(this.def));
        xml.append("</def>\n");
        if (this.aui != null && !this.aui.equals("")) {
            xml.append(tab);
            xml.append("<aui>");
            xml.append(Str.escape(this.aui));
            xml.append("</aui>\n");
        }
        if (this.atui != null && !this.atui.equals("")) {
            xml.append(tab);
            xml.append("<atui>");
            xml.append(Str.escape(this.atui));
            xml.append("</atui>\n");
        }
        if (this.satui != null && !this.satui.equals("")) {
            xml.append(tab);
            xml.append("<satui>");
            xml.append(Str.escape(this.satui));
            xml.append("</satui>\n");
        }
        xml.append(tab0);
        xml.append("</definition>\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof Definition)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        Definition comp = (Definition)c;
        boolean ret = true;
        String lsab = this.sab;
        String csab = comp.getSAB();
        if (!equalsFlag) {
            lsab = CompareUtil.logicalEquivSAB(this.sab);
            csab = CompareUtil.logicalEquivSAB(csab);
        }
        if (!Str.compareStr(lsab, csab)) {
            if (out != null) {
                out.println("this->SAB='" + this.sab + "' is different from '" + comp.getSAB() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.def, comp.getDEF())) {
            if (out != null) {
                out.println("this->DEF='" + this.def + "' is different from '" + comp.getDEF() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.getAUI(), comp.getAUI())) {
            if (out != null) {
                out.println("this->AUI='" + this.aui + "' is different from '" + comp.getAUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.getATUI(), comp.getATUI())) {
            if (out != null) {
                out.println("this->ATUI='" + this.atui + "' is different from '" + comp.getATUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.getSATUI(), comp.getSATUI())) {
            if (out != null) {
                out.println("this->SATUI='" + this.satui + "' is different from '" + comp.getSATUI() + "'");
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        if (this.aui != null) {
            return CompareUtil.logicalEquivSAB(this.sab) + this.def + this.aui;
        }
        return CompareUtil.logicalEquivSAB(this.sab) + this.def;
    }
}

