/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.concept;

import gov.nih.nlm.kss.models.KSCuiVector;
import gov.nih.nlm.kss.models.meta.concept.Definition;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class DefinitionVector
extends KSCuiVector {
    public static final String XmlName = "DefinitionCollection";
    public static final String XmlStructure = "1.0";

    public DefinitionVector() {
        super(XmlName, XmlStructure);
    }

    public DefinitionVector(Vector defs) {
        super(defs, XmlName, XmlStructure);
    }

    public DefinitionVector(DefinitionVector defs) {
        super(defs, XmlName, XmlStructure);
    }

    public DefinitionVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        super.parse(root, namespace);
        String childName = "definition";
        List defs = root.getChildren(childName, namespace);
        if (defs == null || defs.size() == 0) {
            return;
        }
        int i = 0;
        while (i < defs.size()) {
            Element defEle = (Element)defs.get(i);
            Definition def = new Definition(defEle, namespace);
            if (def == null) {
                throw new XMLException("Invalid def definition");
            }
            this.add(def);
            ++i;
        }
    }

    public static DefinitionVector getInstance(String xml) {
        DefinitionVector ac = null;
        try {
            ac = new DefinitionVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return ac;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.meta.concept.DefinitionVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            DefinitionVector vec = DefinitionVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No definitions read");
                return;
            }
            System.out.println("Number of definitions: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                Definition definitions = (Definition)iter.next();
                System.out.println("Definition----------------");
                definitions.output();
                System.out.println("Definition END------------");
            }
            System.out.println("XML Version:");
            out.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

