/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.concept;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class SemType
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    public static final String XmlName = "semanticType";
    private String tui;
    private String sty;
    private String atui;

    public SemType() {
        this.tui = "";
        this.sty = "";
        this.atui = "";
    }

    public SemType(String tui, String sty) {
        this.tui = tui;
        this.sty = sty;
        this.atui = "";
    }

    public SemType(Element semtype, Namespace namespace) throws XMLException {
        Element tuiChild = semtype.getChild("tui", namespace);
        if (tuiChild == null) {
            throw new XMLException("No term unique identifier <tui> found");
        }
        this.tui = XMLInterpreter.extractString(tuiChild);
        Element styChild = semtype.getChild("sty", namespace);
        if (styChild == null) {
            throw new XMLException("No semantic type name <sty> found");
        }
        this.sty = XMLInterpreter.extractString(styChild);
        Element atuiChild = semtype.getChild("atui", namespace);
        if (atuiChild != null) {
            this.atui = XMLInterpreter.extractString(atuiChild);
        }
    }

    public static SemType getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("semanticType must be the name of the first element");
            }
            return new SemType(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setTUI(String tui) {
        this.tui = tui;
    }

    public String getTUI() {
        return this.tui;
    }

    public void setSTY(String sty) {
        this.sty = sty;
    }

    public String getSTY() {
        return this.sty;
    }

    public void setATUI(String atui) {
        this.atui = atui;
    }

    public String getATUI() {
        return this.atui;
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        out.println("TUI:      " + this.tui);
        out.println("STY:      " + this.sty);
        out.println("ATUI:     " + this.atui);
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(100000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        String tab0 = "      ";
        String tab = "         ";
        xml.ensureCapacity(xml.length() + 380);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab);
        xml.append("<tui>");
        xml.append(this.tui);
        xml.append("</tui><sty>");
        xml.append(Str.escape(this.sty));
        xml.append("</sty>");
        if (this.atui != null && !this.atui.equals("")) {
            xml.append("<atui>");
            xml.append(this.atui);
            xml.append("</atui>");
        }
        xml.append("\n");
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String sty;
        if (!(c instanceof SemType)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        SemType comp = (SemType)c;
        boolean ret = true;
        String tui = this.getTUI();
        if (!Str.compareStr(tui, comp.getTUI())) {
            if (out != null) {
                out.println("this->TUI='" + tui + "' is different from '" + comp.getTUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(sty = this.getSTY(), comp.getSTY())) {
            if (out != null) {
                out.println("this->STY='" + sty + "' is different from '" + comp.getSTY() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.getATUI(), comp.getATUI())) {
            if (out != null) {
                out.println("this->ATUI='" + this.getATUI() + "' is different from '" + comp.getATUI() + "'");
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        return this.tui;
    }
}

