/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.concept;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class SourceInfo
extends XMLInterpreter
implements Serializable,
KSComparable,
Xmlizable {
    private String aui;
    private String tty;
    private String saui;
    private String scui;
    private String sdui;
    private boolean suppressible;
    public static final String XmlName = "srcinfo";

    public SourceInfo() {
        this.aui = "";
        this.tty = "";
        this.saui = "";
        this.scui = "";
        this.sdui = "";
        this.suppressible = false;
    }

    public SourceInfo(SourceInfo src) {
        this.aui = src.getAUI();
        this.tty = src.getTTY();
        this.saui = src.getSAUI();
        this.scui = src.getSCUI();
        this.sdui = src.getSDUI();
        this.suppressible = src.getSuppressible();
    }

    public SourceInfo(String aui, String tty, String saui, String scui, String sdui) {
        this.aui = aui;
        this.tty = tty;
        this.saui = saui;
        this.scui = scui;
        this.sdui = sdui;
        this.suppressible = false;
    }

    public SourceInfo(Element source, Namespace namespace) throws XMLException {
        Element auiChild = source.getChild("aui", namespace);
        this.aui = auiChild == null ? "" : XMLInterpreter.extractString(auiChild);
        Element ttyChild = source.getChild("tty", namespace);
        if (ttyChild == null) {
            throw new XMLException("No term type <tty> found");
        }
        this.tty = XMLInterpreter.extractString(ttyChild);
        Element sauiChild = source.getChild("saui", namespace);
        this.saui = sauiChild == null ? "" : XMLInterpreter.extractString(sauiChild);
        Element scuiChild = source.getChild("scui", namespace);
        this.scui = scuiChild == null ? "" : XMLInterpreter.extractString(scuiChild);
        Element sduiChild = source.getChild("sdui", namespace);
        this.sdui = sduiChild == null ? "" : XMLInterpreter.extractString(sduiChild);
        Element suppressChild = source.getChild("suppressible", namespace);
        this.suppressible = suppressChild != null;
    }

    public static SourceInfo getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("srcinfo must be the name of the first element");
            }
            return new SourceInfo(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setAUI(String aui) {
        this.aui = aui;
    }

    public String getAUI() {
        return this.aui;
    }

    public void setTTY(String tty) {
        this.tty = tty;
    }

    public String getTTY() {
        return this.tty;
    }

    public void setSAUI(String saui) {
        this.saui = saui;
    }

    public String getSAUI() {
        return this.saui;
    }

    public void setSCUI(String scui) {
        this.scui = scui;
    }

    public String getSCUI() {
        return this.scui;
    }

    public void setSDUI(String sdui) {
        this.sdui = sdui;
    }

    public String getSDUI() {
        return this.sdui;
    }

    public void setSuppressible(boolean suppressible) {
        this.suppressible = suppressible;
    }

    public boolean getSuppressible() {
        return this.suppressible;
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        String soTab = "         ";
        out.println(soTab + "AUI:    " + this.aui);
        out.println(soTab + "TTY:    " + this.tty);
        out.println(soTab + "SAUI:    " + this.saui);
        out.println(soTab + "SCUI:    " + this.scui);
        out.println(soTab + "SDUI:    " + this.sdui);
        if (this.suppressible) {
            out.println(soTab + "Suppressible");
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(100000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        String tab0 = "             ";
        String tab1 = "                ";
        xml.ensureCapacity(xml.length() + 250);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        if (this.aui != null && !this.aui.equals("")) {
            xml.append(tab1);
            xml.append("<aui>");
            xml.append(this.aui);
            xml.append("</aui>\n");
        }
        if (this.tty != null && !this.tty.equals("")) {
            xml.append(tab1);
            xml.append("<tty>");
            xml.append(this.tty);
            xml.append("</tty>\n");
        }
        if (this.saui != null && !this.saui.equals("")) {
            xml.append(tab1);
            xml.append("<saui>");
            xml.append(Str.escape(this.saui));
            xml.append("</saui>\n");
        }
        if (this.scui != null && !this.scui.equals("")) {
            xml.append(tab1);
            xml.append("<scui>");
            xml.append(this.scui);
            xml.append("</scui>\n");
        }
        if (this.sdui != null && !this.sdui.equals("")) {
            xml.append(tab1);
            xml.append("<sdui>");
            xml.append(this.sdui);
            xml.append("</sdui>\n");
        }
        if (this.suppressible) {
            xml.append(tab1);
            xml.append("<suppressible/>\n");
        }
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String str;
        if (!(c instanceof SourceInfo)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        SourceInfo comp = (SourceInfo)c;
        boolean ret = true;
        String laui = this.aui;
        String caui = comp.getAUI();
        if (!Str.compareStr(laui, caui)) {
            if (out != null) {
                out.println("this->AUI='" + this.aui + "' is different from '" + comp.getAUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.tty, str = comp.getTTY())) {
            if (out != null) {
                out.println("this->TTY='" + this.tty + "' different from '" + str + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.saui, str = comp.getSAUI())) {
            if (out != null) {
                out.println("this->SAUI='" + this.saui + "' different from '" + str + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.scui, str = comp.getSCUI())) {
            if (out != null) {
                out.println("this->SCUI='" + this.scui + "' different from '" + str + "'");
            }
            ret = false;
        }
        if (this.suppressible != comp.getSuppressible()) {
            if (out != null) {
                out.println("this->suppressible='" + this.suppressible + "' different from '" + comp.getSuppressible() + "'");
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        return this.aui + this.tty + this.saui + this.scui;
    }
}

