/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.concept;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class TermType
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    private String tty;
    private String desc;
    public static final String XmlName = "termType";

    public TermType() {
        this.tty = "";
        this.desc = "";
    }

    public TermType(String tty, String desc) {
        this.tty = tty;
        this.desc = desc;
    }

    public TermType(Element term, Namespace namespace) throws XMLException {
        Element ttyChild = term.getChild("tty", namespace);
        if (ttyChild == null) {
            throw new XMLException("No lexical/term unique identifier found");
        }
        this.tty = XMLInterpreter.extractString(ttyChild);
        Element tnChild = term.getChild("desc", namespace);
        if (tnChild == null) {
            throw new XMLException("No term name found");
        }
        this.desc = XMLInterpreter.extractString(tnChild);
    }

    public static TermType getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("termType must be  the name of the first element");
            }
            return new TermType(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setTypeDesc(String desc) {
        this.desc = desc;
    }

    public void setTTY(String tty) {
        this.tty = tty;
    }

    public String getTTY() {
        return this.tty;
    }

    public String getTypeDesc() {
        return this.desc;
    }

    public String toString() {
        return this.xmlize();
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        out.println("TTY:             " + this.tty);
        out.println("Description:     " + this.desc);
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(1000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        String tab0 = "   ";
        String tab = "      ";
        xml.ensureCapacity(xml.length() + 380);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab);
        xml.append("<tty>");
        xml.append(this.tty);
        xml.append("</tty>\n");
        xml.append(tab);
        xml.append("<desc>");
        xml.append(Str.escape(this.getTypeDesc()));
        xml.append("</desc>\n");
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String desc;
        if (!(c instanceof TermType)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        TermType comp = (TermType)c;
        boolean ret = true;
        String tty = this.getTTY();
        if (!Str.compareStr(tty, comp.getTTY())) {
            if (out != null) {
                out.println("this->TTY=" + tty + " is different from " + comp.getTTY());
            }
            ret = false;
        }
        if (!Str.compareStr(desc = this.getTypeDesc(), comp.getTypeDesc())) {
            if (out != null) {
                out.println("this->Description=" + desc + " is different from " + comp.getTypeDesc());
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        return this.tty;
    }
}

