/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.context;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.context.StringCxt;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class Context
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    public static final String XmlName = "context";
    private String sui;
    private Vector cxt;
    private boolean performance = false;

    public Context() {
        this.sui = "";
        this.cxt = null;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public Context(String sui, Vector cxt) {
        this.sui = sui;
        this.cxt = cxt;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public Context(String sui) {
        this.sui = sui;
        this.cxt = new Vector();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public Context(Element cxt, Namespace namespace) throws XMLException {
        Element suiChild;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
        if ((suiChild = cxt.getChild("sui", namespace)) == null) {
            throw new XMLException("No string unique identifier <sui> found");
        }
        this.sui = XMLInterpreter.extractString(suiChild);
        List strs = cxt.getChildren("stringCxt", namespace);
        Vector vec = new Vector();
        int i = 0;
        while (i < strs.size()) {
            Element scxtElement = (Element)strs.get(i);
            StringCxt t = new StringCxt(scxtElement, namespace);
            if (t == null) {
                throw new XMLException("Unable to parse string context\n");
            }
            this.addCXT(t);
            ++i;
        }
    }

    public static Context getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("context must be the name of the first element");
            }
            return new Context(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void addCXT(StringCxt cxt) {
        if (this.cxt == null) {
            this.cxt = new Vector();
        }
        this.cxt.addElement(cxt);
    }

    public void setCXT(Vector cxt) {
        this.cxt = cxt;
    }

    public Vector getCXT() {
        return this.cxt;
    }

    public void setSUI(String sui) {
        this.sui = sui;
    }

    public String getSUI() {
        return this.sui;
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        String tab = "   ";
        out.println(tab + "SUI:      " + this.sui);
        out.println(tab + "Context: ");
        Vector cxt = this.getCXT();
        if (cxt != null) {
            Iterator vIter = cxt.iterator();
            while (vIter.hasNext()) {
                ((StringCxt)vIter.next()).output();
            }
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(100000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        String tab0 = "      ";
        String tab = "         ";
        xml.ensureCapacity(xml.length() + 50);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab);
        xml.append("<sui>");
        xml.append(this.sui);
        xml.append("</sui>\n");
        Iterator vIter = this.cxt.iterator();
        while (vIter.hasNext()) {
            ((StringCxt)vIter.next()).xmlize(xml);
        }
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof Context)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        Context comp = (Context)c;
        boolean ret = true;
        String cval = comp.getSUI();
        String sui = this.getSUI();
        if (!Str.compareStr(sui, cval)) {
            if (out != null) {
                out.println("this->sui='" + sui + "' is different from '" + cval + "'");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        Vector ccxt = comp.getCXT();
        if (this.cxt == null && ccxt != null || this.cxt != null && ccxt == null) {
            if (out != null) {
                out.println("StringCxts are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (this.cxt == null && ccxt == null) {
            return ret;
        }
        if (this.cxt.size() != ccxt.size()) {
            if (out != null) {
                out.println("StringCxts are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        Hashtable compht = this.convert(ccxt);
        Enumeration compkeys = compht.keys();
        Hashtable thisht = this.convert(this.cxt);
        while (compkeys.hasMoreElements()) {
            String compkey = (String)compkeys.nextElement();
            StringCxt val = (StringCxt)thisht.get(compkey);
            if (val == null) {
                if (out != null) {
                    StringCxt missing = (StringCxt)compht.get(compkey);
                    out.println("StringCxt missing from this instance:");
                    out.println(missing.xmlize());
                }
                ret = false;
                if (!this.performance) continue;
                return ret;
            }
            StringCxt val2 = (StringCxt)compht.get(compkey);
            if (equalsFlag) {
                if (!val.equals(val2, out)) {
                    ret = false;
                    if (this.performance) {
                        return ret;
                    }
                }
            } else if (!val.equivalent(val2, out)) {
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
            thisht.remove(compkey);
        }
        Enumeration thiskeys = thisht.keys();
        while (thiskeys.hasMoreElements()) {
            ret = false;
            if (this.performance) {
                return ret;
            }
            String thiskey = (String)thiskeys.nextElement();
            StringCxt val = (StringCxt)thisht.get(thiskey);
            if (out == null) continue;
            StringCxt added = (StringCxt)thisht.get(thiskey);
            out.println("StringCxt added to this instance:");
            out.println(added.xmlize());
        }
        return ret;
    }

    private Hashtable convert(Vector vector) {
        Hashtable<String, StringCxt> table = new Hashtable<String, StringCxt>();
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            StringCxt val = (StringCxt)iter.next();
            table.put(val.getKey(), val);
        }
        return table;
    }

    public String getKey() {
        return this.sui;
    }
}

