/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.context;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.util.CompareUtil;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class CxtMember
extends XMLInterpreter
implements Serializable,
KSComparable,
Xmlizable {
    public static final String XmlName = "cxtMember";
    private String cxs;
    private String cui2;
    private String aui2;
    private String rank;
    private String hcd;
    private String rel;
    private String xc;
    private boolean performance = false;

    public CxtMember() {
        this.init("", "", "", "Unknown", "", "", "");
    }

    public CxtMember(String cxs, String cui2, String rank, String hcd, String rel, String xc) {
        this.init(cxs, cui2, "", rank, hcd, rel, xc);
    }

    public CxtMember(String cxs, String cui2, String aui2, String rank, String hcd, String rel, String xc) {
        this.init(cxs, cui2, aui2, rank, hcd, rel, xc);
    }

    private void init(String cxs, String cui2, String aui2, String rank, String hcd, String rel, String xc) {
        this.cxs = cxs;
        this.cui2 = cui2;
        this.aui2 = aui2;
        this.rank = rank;
        this.hcd = hcd;
        this.rel = rel;
        this.xc = xc;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public CxtMember(Element cxt, Namespace namespace) throws XMLException {
        Element cxsChild;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
        if ((cxsChild = cxt.getChild("cxs", namespace)) == null) {
            throw new XMLException("No source context name value <cxs> found");
        }
        this.cxs = XMLInterpreter.extractString(cxsChild);
        Element cui2Child = cxt.getChild("cui2", namespace);
        if (cui2Child == null) {
            throw new XMLException("No source concept identifier value <cui2> found");
        }
        this.cui2 = XMLInterpreter.extractString(cui2Child);
        Element aui2Child = cxt.getChild("aui2", namespace);
        this.aui2 = aui2Child != null ? XMLInterpreter.extractString(aui2Child) : "";
        Element rankChild = cxt.getChild("rank", namespace);
        this.rank = rankChild == null ? "Unknown" : XMLInterpreter.extractString(rankChild);
        Element hcdChild = cxt.getChild("hcd", namespace);
        if (hcdChild == null) {
            throw new XMLException("No hierarchical code value <hcd> found");
        }
        this.hcd = XMLInterpreter.extractString(hcdChild);
        Element relChild = cxt.getChild("rel", namespace);
        if (relChild == null) {
            throw new XMLException("No relationship value <rel> found");
        }
        this.rel = XMLInterpreter.extractString(relChild);
        Element xcChild = cxt.getChild("xc", namespace);
        if (xcChild == null) {
            throw new XMLException("No has children flag value <xc> found");
        }
        this.xc = XMLInterpreter.extractString(xcChild);
    }

    public static CxtMember getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("cxtMember must be the name of the first element");
            }
            return new CxtMember(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public boolean equals(String cxs, String cui2, String rank, String hcd, String rel, String xc) {
        CxtMember memb = new CxtMember(cxs, cui2, rank, hcd, rel, xc);
        return this.equals(memb);
    }

    public boolean equals(KSComparable cxt) {
        return this.equals(cxt, null);
    }

    public boolean equals(KSComparable cxt, PrintStream out) {
        return this.doCompare(cxt, out, true);
    }

    public boolean equivalent(KSComparable cxt) {
        return this.equivalent(cxt, null);
    }

    public boolean equivalent(KSComparable cxt, PrintStream out) {
        return this.doCompare(cxt, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof CxtMember)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        CxtMember cxt = (CxtMember)c;
        boolean ret = true;
        String lcxs = this.cxs;
        String ccxs = cxt.getCXS();
        if (!equalsFlag) {
            lcxs = CompareUtil.logicalEquivCXS(lcxs);
            ccxs = CompareUtil.logicalEquivCXS(ccxs);
        }
        if (!Str.compareStr(lcxs, ccxs)) {
            if (out != null) {
                out.println("this->CXS=" + this.cxs + " is different from " + cxt.getCXS());
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (!Str.compareStr(this.cui2, cxt.getCUI2())) {
            if (out != null) {
                out.println("this->CUI2=" + this.cui2 + " is different from " + cxt.getCUI2());
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (!Str.compareStr(this.aui2, cxt.getAUI2())) {
            if (out != null) {
                out.println("this->AUI2=" + this.aui2 + " is different from " + cxt.getAUI2());
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (!Str.compareStr(this.rank, cxt.getRank())) {
            if (out != null) {
                out.println("this->Rank=" + this.rank + " is different from " + cxt.getRank());
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (!Str.compareStr(this.hcd, cxt.getHCD())) {
            if (out != null) {
                out.println("this->HCD=" + this.hcd + " is different from " + cxt.getHCD());
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (!Str.compareStr(this.rel, cxt.getREL())) {
            if (out != null) {
                out.println("this->REL=" + this.rel + " is different from " + cxt.getREL());
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (!Str.compareStr(this.xc, cxt.getXC())) {
            if (out != null) {
                out.println("this->XC=" + this.xc + " is different from " + cxt.getXC());
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        return ret;
    }

    public String getCXS() {
        return this.cxs;
    }

    public void setCXS(String cxs) {
        this.cxs = cxs;
    }

    public String getCUI2() {
        return this.cui2;
    }

    public void setCUI2(String cui2) {
        this.cui2 = cui2;
    }

    public String getAUI2() {
        return this.aui2;
    }

    public void setAUI2(String aui2) {
        this.aui2 = aui2;
    }

    public String getRank() {
        return this.rank;
    }

    public void setRank(String rank) {
        this.rank = rank;
    }

    public String getHCD() {
        return this.hcd;
    }

    public void setHCD(String hcd) {
        this.hcd = hcd;
    }

    public String getREL() {
        return this.rel;
    }

    public void setREL(String rel) {
        this.rel = rel;
    }

    public String getXC() {
        return this.xc;
    }

    public void setXC(String xc) {
        this.xc = xc;
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        String tab = "\t\t\t";
        out.println(tab + this.cxs + " [" + this.hcd + "] " + this.rel);
    }

    public String xmlize() {
        return CxtMember.xmlize(this.cxs, this.cui2, this.aui2, this.rank, this.hcd, this.rel, this.xc);
    }

    public static String xmlize(String cxs, String cui2, String rank, String hcd, String rel, String xc) {
        CxtMember mbr = new CxtMember(cxs, cui2, rank, hcd, rel, xc);
        mbr.setAUI2("");
        return mbr.xmlize();
    }

    private static String xmlize(String cxs, String cui2, String aui2, String rank, String hcd, String rel, String xc) {
        StringBuffer xml = new StringBuffer(1000);
        CxtMember.xmlize(xml, cxs, cui2, aui2, rank, hcd, rel, xc);
        return xml.toString();
    }

    public static String xmlize(StringBuffer xml, String cxs, String cui2, String rank, String hcd, String rel, String xc) {
        return CxtMember.xmlize(xml, cxs, cui2, "", rank, hcd, rel, xc);
    }

    private static String xmlize(StringBuffer xml, String cxs, String cui2, String aui2, String rank, String hcd, String rel, String xc) {
        String tab0 = "                  ";
        String tab = "                     ";
        xml.ensureCapacity(xml.length() + 450);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        String mcxs = cxs;
        if (cxs == null) {
            mcxs = "";
        }
        xml.append(tab);
        xml.append("<cxs>");
        xml.append(Str.escape(mcxs));
        xml.append("</cxs>\n");
        String mcui2 = cui2;
        if (cui2 == null) {
            mcui2 = "";
        }
        xml.append(tab);
        xml.append("<cui2>");
        xml.append(mcui2);
        xml.append("</cui2>\n");
        if (aui2 != null && !aui2.equals("")) {
            xml.append(tab);
            xml.append("<aui2>");
            xml.append(aui2);
            xml.append("</aui2>\n");
        }
        String mrank = rank;
        if (rank == null) {
            mrank = "";
        }
        xml.append(tab);
        xml.append("<rank>");
        xml.append(mrank);
        xml.append("</rank>\n");
        String mhcd = hcd;
        if (hcd == null) {
            mhcd = "";
        }
        xml.append(tab);
        xml.append("<hcd>");
        xml.append(mhcd);
        xml.append("</hcd>\n");
        String mrel = rel;
        if (rel == null) {
            mrel = "";
        }
        xml.append(tab);
        xml.append("<rel>");
        xml.append(mrel);
        xml.append("</rel>\n");
        String mxc = xc;
        if (xc == null) {
            mxc = "";
        }
        xml.append(tab);
        xml.append("<xc>");
        xml.append(mxc);
        xml.append("</xc>\n");
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
        return xml.toString();
    }

    public String getKey() {
        return CompareUtil.logicalEquivCXS(this.cxs) + this.cui2 + this.aui2 + this.hcd;
    }
}

