/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.context;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.context.CxtMember;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class SourceCxt
extends XMLInterpreter
implements Serializable,
KSComparable,
Xmlizable {
    public static final String XmlName = "sourceCxt";
    private String cxn;
    private CxtMember ccp;
    private Vector anc;
    private Vector sib;
    private Vector chd;
    private Vector des;
    private boolean performance = false;

    public SourceCxt() {
        this.cxn = null;
        this.ccp = null;
        this.anc = new Vector();
        this.sib = new Vector();
        this.chd = new Vector();
        this.des = new Vector();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    private void processCCP(Element ccp, Namespace namespace) throws XMLException {
        Element cxtMember = ccp.getChild("cxtMember", namespace);
        this.ccp = new CxtMember(cxtMember, namespace);
        this.cxn = this.ccp.getCXS();
    }

    private void processRelatives(Element relative, Namespace namespace, Vector vector) throws XMLException {
        List cxtMembers = relative.getChildren("cxtMember", namespace);
        int i = 0;
        while (i < cxtMembers.size()) {
            Element member = (Element)cxtMembers.get(i);
            CxtMember memb = new CxtMember(member, namespace);
            if (memb == null) {
                throw new XMLException("Unable to parse the relative\n");
            }
            vector.add(memb);
            ++i;
        }
    }

    public SourceCxt(Element cxt, Namespace namespace) throws XMLException {
        Element dess;
        Element chds;
        Element sibs;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
        this.anc = new Vector();
        this.sib = new Vector();
        this.chd = new Vector();
        this.des = new Vector();
        Element ccp = cxt.getChild("ccp", namespace);
        if (ccp != null) {
            this.processCCP(ccp, namespace);
        } else {
            this.cxn = "";
        }
        Element ancs = cxt.getChild("anc", namespace);
        if (ancs != null) {
            this.processRelatives(ancs, namespace, this.anc);
        }
        if ((sibs = cxt.getChild("sib", namespace)) != null) {
            this.processRelatives(sibs, namespace, this.sib);
        }
        if ((chds = cxt.getChild("chd", namespace)) != null) {
            this.processRelatives(chds, namespace, this.chd);
        }
        if ((dess = cxt.getChild("des", namespace)) != null) {
            this.processRelatives(dess, namespace, this.des);
        }
    }

    public static SourceCxt getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("sourceCxt must be the name of the first element");
            }
            return new SourceCxt(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setCCP(String cxs, String cui2, String rank, String hcd, String rel, String xc) {
        this.setCCP(cxs, cui2, "", rank, hcd, rel, xc);
    }

    public void setCCP(String cxs, String cui2, String aui, String rank, String hcd, String rel, String xc) {
        this.ccp = new CxtMember(cxs, cui2, aui, rank, hcd, rel, xc);
    }

    public void addANC(String cxs, String cui2, String rank, String hcd, String rel, String xc) {
        this.addANC(cxs, cui2, "", rank, hcd, rel, xc);
    }

    public void addANC(String cxs, String cui2, String aui2, String rank, String hcd, String rel, String xc) {
        if (this.anc == null) {
            this.anc = new Vector();
        }
        CxtMember comp = new CxtMember(cxs, cui2, aui2, rank, hcd, rel, xc);
        Iterator iter = this.anc.iterator();
        while (iter.hasNext()) {
            if (!((CxtMember)iter.next()).equals(comp)) continue;
            return;
        }
        this.anc.addElement(comp);
    }

    public void addSIB(String cxs, String cui2, String rank, String hcd, String rel, String xc) {
        this.addSIB(cxs, cui2, "", rank, hcd, rel, xc);
    }

    public void addSIB(String cxs, String cui2, String aui2, String rank, String hcd, String rel, String xc) {
        if (this.sib == null) {
            this.sib = new Vector();
        }
        CxtMember comp = new CxtMember(cxs, cui2, aui2, rank, hcd, rel, xc);
        Iterator iter = this.sib.iterator();
        while (iter.hasNext()) {
            if (!((CxtMember)iter.next()).equals(comp)) continue;
            return;
        }
        this.sib.addElement(comp);
    }

    public void addCHD(String cxs, String cui2, String rank, String hcd, String rel, String xc) {
        this.addCHD(cxs, cui2, "", rank, hcd, rel, xc);
    }

    public void addCHD(String cxs, String cui2, String aui2, String rank, String hcd, String rel, String xc) {
        if (this.chd == null) {
            this.chd = new Vector();
        }
        CxtMember comp = new CxtMember(cxs, cui2, aui2, rank, hcd, rel, xc);
        Iterator iter = this.chd.iterator();
        while (iter.hasNext()) {
            if (!((CxtMember)iter.next()).equals(comp)) continue;
            return;
        }
        this.chd.addElement(comp);
    }

    public void addDES(String cxs, String cui2, String rank, String hcd, String rel, String xc) {
        this.addDES(cxs, cui2, "", rank, hcd, rel, xc);
    }

    public void addDES(String cxs, String cui2, String aui2, String rank, String hcd, String rel, String xc) {
        if (this.des == null) {
            this.des = new Vector();
        }
        CxtMember comp = new CxtMember(cxs, cui2, aui2, rank, hcd, rel, xc);
        Iterator iter = this.des.iterator();
        while (iter.hasNext()) {
            if (!((CxtMember)iter.next()).equals(comp)) continue;
            return;
        }
        this.des.addElement(comp);
    }

    public String getCXN() {
        return this.cxn;
    }

    public void setCXN(String c) {
        this.cxn = c;
    }

    public CxtMember getCCP() {
        return this.ccp;
    }

    public Vector getANC() {
        return this.anc;
    }

    public Vector getSIB() {
        return this.sib;
    }

    public Vector getCHD() {
        return this.chd;
    }

    public Vector getDES() {
        return this.des;
    }

    public void output() {
        Iterator vIter;
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        String tab = "         ";
        if (this.getCCP() != null) {
            out.println(tab + "Concept: " + this.getCCP().getCXS());
        } else {
            out.println(tab + "Null Concept: ");
        }
        out.println(tab + "Ancestors: ");
        if (this.getANC() != null) {
            vIter = this.getANC().iterator();
            String anctab = tab + "   ";
            CxtMember cxtMemb = null;
            while (vIter.hasNext()) {
                cxtMemb = (CxtMember)vIter.next();
                out.println(anctab + cxtMemb.getCXS() + " [" + cxtMemb.getHCD() + "] ");
                anctab = anctab + " ";
            }
        } else {
            out.println(tab + tab + "None");
        }
        out.println(tab + "Children:");
        if (this.getCHD() != null) {
            vIter = this.getCHD().iterator();
            while (vIter.hasNext()) {
                ((CxtMember)vIter.next()).output();
            }
        } else {
            out.println(tab + tab + "None");
        }
        out.println(tab + "Siblings:");
        if (this.getSIB() != null) {
            vIter = this.getSIB().iterator();
            while (vIter.hasNext()) {
                ((CxtMember)vIter.next()).output();
            }
        } else {
            out.println(tab + tab + "None");
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(100000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        String tab0 = "            ";
        String tab = "               ";
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab);
        if (this.ccp != null) {
            xml.append("<ccp>\n");
            xml.append(this.ccp.xmlize());
            xml.append(tab);
            xml.append("</ccp>\n");
        }
        SourceCxt.xmlizeVector(xml, "<anc>", this.anc, "</anc>");
        SourceCxt.xmlizeVector(xml, "<chd>", this.chd, "</chd>");
        SourceCxt.xmlizeVector(xml, "<sib>", this.sib, "</sib>");
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    protected static void xmlizeVector(StringBuffer xml, String start, Vector v, String stop) {
        String tab = "               ";
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab);
        xml.append(start);
        xml.append("\n");
        if (v != null) {
            Iterator vIter = v.iterator();
            CxtMember cxtMemb = null;
            while (vIter.hasNext()) {
                cxtMemb = (CxtMember)vIter.next();
                String tmp = cxtMemb.xmlize();
                xml.ensureCapacity(xml.length() + tmp.length());
                xml.append(tmp);
            }
        }
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab);
        xml.append(stop);
        xml.append("\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof SourceCxt)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        SourceCxt comp = (SourceCxt)c;
        boolean ret = true;
        if (!Str.compareStr(this.cxn, comp.getCXN())) {
            if (out != null) {
                out.println("this->CXN='" + this.cxn + "' is different from '" + comp.getCXN() + "'");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        CxtMember cccp = comp.getCCP();
        if (this.ccp != null && cccp == null || this.ccp == null && cccp != null) {
            ret = false;
            if (this.performance) {
                return ret;
            }
        } else if (this.ccp != null && cccp != null) {
            if (equalsFlag) {
                if (!this.ccp.equals(comp.getCCP())) {
                    if (out != null) {
                        out.println("this->CCP is different from comparison instance");
                    }
                    ret = false;
                    if (this.performance) {
                        return ret;
                    }
                }
            } else if (!this.ccp.equivalent(comp.getCCP())) {
                if (out != null) {
                    out.println("this->CCP is different from comparison instance");
                }
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
        }
        if (!this.compare(this.anc, comp.getANC(), out, equalsFlag)) {
            if (out != null) {
                out.println("this->Ancestors are different from comparison instance");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (!this.compare(this.sib, comp.getSIB(), out, equalsFlag)) {
            if (out != null) {
                out.println("this->siblings are different from comparison instance");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (!this.compare(this.chd, comp.getCHD(), out, equalsFlag)) {
            if (out != null) {
                out.println("this->children are different from comparison instance");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (!this.compare(this.des, comp.getDES(), out, equalsFlag)) {
            if (out != null) {
                out.println("this->descendants are different from comparison instance");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        return ret;
    }

    private boolean compare(Vector thisvec, Vector comp, PrintStream out, boolean equalsFlag) {
        if (thisvec == null && comp != null || thisvec != null && comp == null) {
            if (out != null) {
                out.println("CxtMembers are different");
            }
            return false;
        }
        if (thisvec == null && comp == null) {
            return true;
        }
        boolean ret = true;
        if (comp.size() != thisvec.size()) {
            if (out != null) {
                out.println("CxtMember sizes are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        Hashtable compht = this.convert(comp);
        Enumeration compkeys = compht.keys();
        Hashtable thisht = this.convert(thisvec);
        while (compkeys.hasMoreElements()) {
            String compkey = (String)compkeys.nextElement();
            CxtMember exp = (CxtMember)thisht.get(compkey);
            if (exp == null) {
                if (out != null) {
                    CxtMember missing = (CxtMember)compht.get(compkey);
                    out.println("CxtMember missing from this instance:");
                    out.println(missing.xmlize());
                }
                ret = false;
                if (!this.performance) continue;
                return ret;
            }
            CxtMember exp2 = (CxtMember)compht.get(compkey);
            if (equalsFlag) {
                if (!exp.equals(exp2, out)) {
                    ret = false;
                    if (this.performance) {
                        return ret;
                    }
                }
            } else if (!exp.equivalent(exp2, out)) {
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
            thisht.remove(compkey);
        }
        Enumeration thiskeys = thisht.keys();
        while (thiskeys.hasMoreElements()) {
            ret = false;
            if (this.performance) {
                return ret;
            }
            String thiskey = (String)thiskeys.nextElement();
            CxtMember val = (CxtMember)thisht.get(thiskey);
            if (out == null) continue;
            CxtMember added = (CxtMember)thisht.get(thiskey);
            out.println("CxtMember added to this instance:");
            out.println(added.xmlize());
        }
        return ret;
    }

    private Hashtable convert(Vector vector) {
        Hashtable<String, CxtMember> table = new Hashtable<String, CxtMember>();
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            CxtMember exp = (CxtMember)iter.next();
            table.put(exp.getKey(), exp);
        }
        return table;
    }

    public String getKey() {
        if (this.cxn == null && this.ccp == null) {
            return "BlankCXN";
        }
        if (this.cxn == null) {
            return this.ccp.getCUI2();
        }
        if (this.ccp == null) {
            return this.cxn;
        }
        return this.cxn + this.ccp.getCUI2();
    }
}

