/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.context;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.context.SourceCxt;
import gov.nih.nlm.kss.util.CompareUtil;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class StringCxt
extends XMLInterpreter
implements Serializable,
KSComparable,
Xmlizable {
    public static final String XmlName = "stringCxt";
    private String sab;
    private String scd;
    private String aui;
    private Vector cxt;
    private boolean performance = false;

    public StringCxt() {
        this.sab = "";
        this.scd = "";
        this.aui = "";
        this.cxt = null;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public StringCxt(String sab, String scd, Vector cxt) {
        this.sab = sab;
        this.scd = scd;
        this.aui = "";
        this.cxt = cxt;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public StringCxt(String sab, String scd, String aui, Vector cxt) {
        this.sab = sab;
        this.scd = scd;
        this.aui = aui;
        this.cxt = cxt;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public StringCxt(String sab, String scd) {
        this.sab = sab;
        this.scd = scd;
        this.aui = "";
        this.cxt = new Vector();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public StringCxt(Element cxt, Namespace namespace) throws XMLException {
        Element sabChild;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
        if ((sabChild = cxt.getChild("sab", namespace)) == null) {
            throw new XMLException("No source abbreviation value <sab> found");
        }
        this.sab = XMLInterpreter.extractString(sabChild);
        Element scdChild = cxt.getChild("scd", namespace);
        if (scdChild == null) {
            throw new XMLException("No source concept id <scd> found");
        }
        this.scd = XMLInterpreter.extractString(scdChild);
        Element auiChild = cxt.getChild("aui", namespace);
        this.aui = auiChild != null ? XMLInterpreter.extractString(auiChild) : "";
        List srcs = cxt.getChildren("sourceCxt", namespace);
        int i = 0;
        while (i < srcs.size()) {
            Element srcElement = (Element)srcs.get(i);
            SourceCxt t = new SourceCxt(srcElement, namespace);
            if (t == null) {
                throw new XMLException("Unable to parse source context\n");
            }
            this.addCXT(t);
            ++i;
        }
    }

    public static StringCxt getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("stringCxt must be the name of the first element");
            }
            return new StringCxt(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setCXT(Vector cxt) {
        this.cxt = cxt;
    }

    public Vector getCXT() {
        return this.cxt;
    }

    public void addCXT(SourceCxt cxt) {
        if (this.cxt == null) {
            this.cxt = new Vector();
        }
        this.cxt.addElement(cxt);
    }

    public void setSAB(String sab) {
        this.sab = sab;
    }

    public String getSAB() {
        return this.sab;
    }

    public void setSCD(String scd) {
        this.scd = scd;
    }

    public String getSCD() {
        return this.scd;
    }

    public void setAUI(String aui) {
        this.aui = aui;
    }

    public String getAUI() {
        return this.aui;
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        String tab = "      ";
        out.println(tab + "SAB:      " + this.sab);
        out.println(tab + "SCD:      " + this.scd);
        out.println(tab + "AUI:      " + this.aui);
        out.println(tab + "Context: ");
        Iterator vIter = this.getCXT().iterator();
        while (vIter.hasNext()) {
            ((SourceCxt)vIter.next()).output();
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(100000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        Vector cxt;
        String tab0 = "         ";
        String tab = "            ";
        xml.ensureCapacity(xml.length() + 90);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab);
        xml.append("<sab>");
        xml.append(this.sab);
        xml.append("</sab>\n");
        xml.append(tab);
        xml.append("<scd>");
        xml.append(this.scd);
        xml.append("</scd>\n");
        if (this.aui != null && !this.aui.equals("")) {
            xml.append(tab);
            xml.append("<aui>");
            xml.append(this.aui);
            xml.append("</aui>\n");
        }
        if ((cxt = this.getCXT()) != null) {
            Iterator vIter = cxt.iterator();
            while (vIter.hasNext()) {
                ((SourceCxt)vIter.next()).xmlize(xml);
            }
        }
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String cval;
        if (!(c instanceof StringCxt)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        StringCxt comp = (StringCxt)c;
        boolean ret = true;
        String lsab = this.sab;
        String csab = comp.getSAB();
        if (!equalsFlag) {
            lsab = CompareUtil.logicalEquivSAB(lsab);
            csab = CompareUtil.logicalEquivSAB(csab);
        }
        if (!Str.compareStr(lsab, csab)) {
            if (out != null) {
                out.println("this->SAB='" + this.sab + "' is different from '" + comp.getSAB() + "'");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (!Str.compareStr(this.scd, cval = comp.getSCD())) {
            if (out != null) {
                out.println("this->scd='" + this.scd + "' is different from '" + cval + "'");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (!Str.compareStr(this.aui, cval = comp.getAUI())) {
            if (out != null) {
                out.println("this->aui='" + this.aui + "' is different from '" + cval + "'");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        Vector cxts = comp.getCXT();
        if (this.cxt == null && cxts != null || this.cxt != null && cxts == null) {
            if (out != null) {
                out.println("SourceCxts are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (this.cxt == null && cxts == null) {
            return ret;
        }
        if (this.cxt.size() != cxts.size()) {
            if (out != null) {
                out.println("SourceCxts are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        Hashtable compht = this.convert(cxts);
        Enumeration compkeys = compht.keys();
        Hashtable thisht = this.convert(this.cxt);
        while (compkeys.hasMoreElements()) {
            String compkey = (String)compkeys.nextElement();
            SourceCxt val = (SourceCxt)thisht.get(compkey);
            if (val == null) {
                if (out != null) {
                    SourceCxt missing = (SourceCxt)compht.get(compkey);
                    out.println("SourceCxt missing from this instance:");
                    out.println(missing.xmlize());
                }
                ret = false;
                if (!this.performance) continue;
                return ret;
            }
            SourceCxt val2 = (SourceCxt)compht.get(compkey);
            if (equalsFlag) {
                if (!val.equals(val2, out)) {
                    ret = false;
                    if (this.performance) {
                        return ret;
                    }
                }
            } else if (!val.equivalent(val2, out)) {
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
            thisht.remove(compkey);
        }
        Enumeration thiskeys = thisht.keys();
        while (thiskeys.hasMoreElements()) {
            ret = false;
            if (this.performance) {
                return ret;
            }
            String thiskey = (String)thiskeys.nextElement();
            SourceCxt val = (SourceCxt)thisht.get(thiskey);
            if (out == null) continue;
            SourceCxt added = (SourceCxt)thisht.get(thiskey);
            out.println("SourceCxt added to this instance:");
            out.println(added.xmlize());
        }
        return ret;
    }

    private Hashtable convert(Vector vector) {
        Hashtable<String, SourceCxt> table = new Hashtable<String, SourceCxt>();
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            SourceCxt val = (SourceCxt)iter.next();
            table.put(val.getKey(), val);
        }
        return table;
    }

    public String getKey() {
        return CompareUtil.logicalEquivSAB(this.sab) + this.scd + this.aui;
    }
}

