/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.cooccurrence;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class CooccurrenceType
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    private String cot;
    private String desc;
    public static final String XmlName = "coocType";

    public CooccurrenceType() {
        this.cot = "";
        this.desc = "";
    }

    public CooccurrenceType(String cot, String desc) {
        this.cot = cot;
        this.desc = desc;
    }

    public CooccurrenceType(Element cooc, Namespace namespace) throws XMLException {
        Element cotChild = cooc.getChild("cot", namespace);
        if (cotChild == null) {
            throw new XMLException("No cooccurrence type found");
        }
        this.cot = XMLInterpreter.extractString(cotChild);
        Element descChild = cooc.getChild("desc", namespace);
        if (descChild == null) {
            throw new XMLException("No cooccurrence description found");
        }
        this.desc = XMLInterpreter.extractString(descChild);
    }

    public static CooccurrenceType getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("coocType must be  the name of the first element");
            }
            return new CooccurrenceType(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setCOT(String cot) {
        this.cot = cot;
    }

    public String getCOT() {
        return this.cot;
    }

    public void setTypeDesc(String desc) {
        this.desc = desc;
    }

    public String getTypeDesc() {
        return this.desc;
    }

    public String toString() {
        return this.xmlize();
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        out.println("COT:             " + this.cot);
        out.println("Description:     " + this.desc);
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(1000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        String tab0 = "   ";
        String tab = "      ";
        xml.ensureCapacity(xml.length() + 380);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab);
        xml.append("<cot>");
        xml.append(this.cot);
        xml.append("</cot>\n");
        xml.append(tab);
        xml.append("<desc>");
        xml.append(Str.escape(this.getTypeDesc()));
        xml.append("</desc>\n");
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String desc;
        if (!(c instanceof CooccurrenceType)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        CooccurrenceType comp = (CooccurrenceType)c;
        boolean ret = true;
        String cot = this.getCOT();
        if (!Str.compareStr(cot, comp.getCOT())) {
            out.println("this->COT=" + cot + " is different from " + comp.getCOT());
            ret = false;
        }
        if (!Str.compareStr(desc = this.getTypeDesc(), comp.getTypeDesc())) {
            out.println("this->Description=" + desc + " is different from " + comp.getTypeDesc());
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        return this.cot;
    }
}

