/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.cooccurrence;

import gov.nih.nlm.kss.models.KSVector;
import gov.nih.nlm.kss.models.meta.cooccurrence.CooccurrenceType;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class CooccurrenceTypeVector
extends KSVector {
    public static final String XmlName = "CooccurrenceTypeCollection";
    public static final String XmlStructure = "1.0";

    public CooccurrenceTypeVector(Vector ids) {
        super(ids, XmlName, XmlStructure);
    }

    public CooccurrenceTypeVector(KSVector ids) {
        super(ids, XmlName, XmlStructure);
    }

    public CooccurrenceTypeVector(CooccurrenceTypeVector ids) {
        super(ids, XmlName, XmlStructure);
    }

    public CooccurrenceTypeVector() {
        super(XmlName, XmlStructure);
    }

    public CooccurrenceTypeVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        String childName = "coocType";
        List ids = root.getChildren(childName, namespace);
        if (ids == null || ids.size() == 0) {
            return;
        }
        int i = 0;
        while (i < ids.size()) {
            Element idEle = (Element)ids.get(i);
            CooccurrenceType id = new CooccurrenceType(idEle, namespace);
            if (id == null) {
                throw new XMLException("Invalid cooccurrence type definition");
            }
            this.add(id);
            ++i;
        }
    }

    public static CooccurrenceTypeVector getInstance(String xml) {
        CooccurrenceTypeVector cv = null;
        try {
            cv = new CooccurrenceTypeVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return cv;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.meta.cooccurrence.CooccurrenceTypeVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            CooccurrenceTypeVector vec = CooccurrenceTypeVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No types read");
                return;
            }
            System.out.println("Number of types: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                CooccurrenceType id = (CooccurrenceType)iter.next();
                System.out.println("CooccurrenceType----------------");
                id.output();
                System.out.println("CooccurrenceType END------------");
            }
            System.out.println("XML Version:");
            out.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

