/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.cooccurrence;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.util.ConstantSettings;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class MeSHQualifier
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    private String code;
    private String name;
    public static final String XmlName = "meshQual";
    private static boolean initialized = false;
    private static HashMap hashMap = new HashMap();

    public MeSHQualifier() {
        this.code = "";
        this.name = "";
    }

    public MeSHQualifier(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public MeSHQualifier(Element source, Namespace namespace) throws XMLException {
        Element codeChild = source.getChild("code", namespace);
        if (codeChild == null) {
            throw new XMLException("No source code <code> found");
        }
        this.code = XMLInterpreter.extractString(codeChild);
        Element nameChild = source.getChild("name", namespace);
        if (nameChild == null) {
            throw new XMLException("No description <name> found");
        }
        this.name = XMLInterpreter.extractString(nameChild);
    }

    public static MeSHQualifier getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("meshQual must be the name of the first element");
            }
            return new MeSHQualifier(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    private static void init() throws Exception {
        String s;
        if (initialized) {
            return;
        }
        initialized = true;
        String fileName = ConstantSettings.getMeSHQualifierFileName();
        FileReader fr = new FileReader(fileName);
        BufferedReader br = new BufferedReader(fr);
        StringTokenizer st = null;
        String qualifCode = null;
        String qualifName = null;
        while ((s = br.readLine()) != null) {
            void var3_6;
            st = new StringTokenizer((String)var3_6, "|");
            if (st.hasMoreTokens()) {
                qualifCode = st.nextToken();
                qualifName = st.nextToken();
            }
            hashMap.put(qualifCode, new MeSHQualifier(qualifCode, qualifName));
        }
    }

    public static void dumpHashMap() {
        Set set = hashMap.entrySet();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            Map.Entry me = i.next();
            System.out.print(me.getKey() + ": ");
            System.out.println(((MeSHQualifier)me.getValue()).getName());
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(2500);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        String tab0 = " ";
        String tab1 = "     ";
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab1);
        xml.append("<code>");
        xml.append(Str.escape(this.code));
        xml.append("</code>\n");
        xml.append(tab1);
        xml.append("<name>");
        xml.append(Str.escape(this.name));
        xml.append("</name>\n");
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String name;
        if (!(c instanceof MeSHQualifier)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        MeSHQualifier comp = (MeSHQualifier)c;
        boolean ret = true;
        String code = this.getCode();
        if (!Str.compareStr(code, comp.getCode())) {
            if (out != null) {
                out.println("this->Code='" + code + "' is different from '" + comp.getCode() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(name = this.getName(), comp.getName())) {
            if (out != null) {
                out.println("this->Name='" + name + "' is different from '" + comp.getName() + "'");
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        return this.code;
    }
}

