/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.cooccurrence;

import gov.nih.nlm.kss.models.KSVector;
import gov.nih.nlm.kss.models.meta.cooccurrence.MeSHQualifier;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class MeSHQualifierVector
extends KSVector {
    public static final String XmlName = "MeSHQualifierCollection";
    public static final String XmlStructure = "1.0";

    public MeSHQualifierVector(Vector quals) {
        super(quals, XmlName, XmlStructure);
    }

    public MeSHQualifierVector(MeSHQualifierVector quals) {
        super(quals, XmlName, XmlStructure);
    }

    public MeSHQualifierVector() {
        super(XmlName, XmlStructure);
    }

    public MeSHQualifierVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        String childName = "meshQual";
        List meshQualifiers = root.getChildren(childName, namespace);
        if (meshQualifiers == null || meshQualifiers.size() == 0) {
            return;
        }
        int i = 0;
        while (i < meshQualifiers.size()) {
            Element qual = (Element)meshQualifiers.get(i);
            MeSHQualifier meshQualifier = new MeSHQualifier(qual, namespace);
            if (meshQualifier == null) {
                throw new XMLException("Invalid meshQualifier definition");
            }
            this.add(meshQualifier);
            ++i;
        }
    }

    public static MeSHQualifierVector getInstance(String xml) {
        MeSHQualifierVector aev = null;
        try {
            aev = new MeSHQualifierVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return aev;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.meta.cooccurrence.MeSHQualifierVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            MeSHQualifierVector vec = MeSHQualifierVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No meshQualifiers read");
                return;
            }
            System.out.println("Number of meshQualifiers: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                MeSHQualifier meshQualifier = (MeSHQualifier)iter.next();
                System.out.println("MeSHQualifier----------------");
                out.println(meshQualifier.xmlize());
                System.out.println("MeSHQualifier END------------");
            }
            System.out.println("XML Version:");
            out.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

