/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.cooccurrence;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.cooccurrence.QualifierFrequency;
import gov.nih.nlm.kss.util.XMLException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class QualifierFrequencyVector
extends Vector
implements Serializable,
KSComparable,
Xmlizable {
    private boolean performance = false;

    public QualifierFrequencyVector(Vector qfs) {
        super(qfs);
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public QualifierFrequencyVector() {
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    private QualifierFrequencyVector(String xml) throws XMLException {
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
        throw new XMLException("QualifierFrequencyVectory XML Constructor not implemented");
    }

    private static QualifierFrequencyVector getInstance(String xml) {
        QualifierFrequencyVector aev = null;
        try {
            aev = new QualifierFrequencyVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return aev;
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(1000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            xml.append(((QualifierFrequency)iter.next()).xmlize());
        }
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof QualifierFrequencyVector)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        QualifierFrequencyVector comp = (QualifierFrequencyVector)c;
        boolean ret = true;
        if (comp.size() != this.size()) {
            if (out != null) {
                out.println("QualifierFrequencyVector sizes are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        Hashtable compht = this.convert(comp);
        Enumeration compkeys = compht.keys();
        Hashtable thisht = this.convert(this);
        while (compkeys.hasMoreElements()) {
            String compkey = (String)compkeys.nextElement();
            QualifierFrequency exp = (QualifierFrequency)thisht.get(compkey);
            if (exp == null) {
                if (out != null) {
                    QualifierFrequency missing = (QualifierFrequency)compht.get(compkey);
                    out.println("QualifierFrequency missing from this instance:");
                    out.println(missing.xmlize());
                }
                ret = false;
                if (!this.performance) continue;
                return ret;
            }
            QualifierFrequency exp2 = (QualifierFrequency)compht.get(compkey);
            if (equalsFlag) {
                if (!exp.equals(exp2, out)) {
                    ret = false;
                    if (this.performance) {
                        return ret;
                    }
                }
            } else if (!exp.equivalent(exp2, out)) {
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
            thisht.remove(compkey);
        }
        Enumeration thiskeys = thisht.keys();
        while (thiskeys.hasMoreElements()) {
            ret = false;
            if (this.performance) {
                return ret;
            }
            String thiskey = (String)thiskeys.nextElement();
            QualifierFrequency val = (QualifierFrequency)thisht.get(thiskey);
            if (out == null) continue;
            QualifierFrequency added = (QualifierFrequency)thisht.get(thiskey);
            out.println("QualifierFrequency added to this instance:");
            out.println(added.xmlize());
        }
        return ret;
    }

    private Hashtable convert(QualifierFrequencyVector vector) {
        Hashtable<String, QualifierFrequency> table = new Hashtable<String, QualifierFrequency>();
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            QualifierFrequency exp = (QualifierFrequency)iter.next();
            table.put(exp.getKey(), exp);
        }
        return table;
    }

    public String getKey() {
        return new Integer(this.hashCode()).toString();
    }
}

