/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.deltas;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.models.meta.deltas.ConceptDelta;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class ReleaseDelta
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    private String release;
    private Vector changes;
    public static final String XmlName = "releaseDelta";
    private boolean performance = false;

    public ReleaseDelta() {
        this.changes = null;
        this.release = "";
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public ReleaseDelta(String release, Vector deltas) {
        this.changes = deltas;
        this.release = release;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public ReleaseDelta(Element releaseDelta, Namespace namespace) throws XMLException {
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
        this.changes = new Vector();
        Element yrChild = releaseDelta.getChild("release", namespace);
        if (yrChild == null) {
            throw new XMLException("No UMLS release <release> found");
        }
        this.release = XMLInterpreter.extractString(yrChild);
        String childName = "change";
        List deltas = releaseDelta.getChildren(childName, namespace);
        if (deltas == null || deltas.size() == 0) {
            return;
        }
        int i = 0;
        while (i < deltas.size()) {
            Element delta = (Element)deltas.get(i);
            ConceptDelta d = new ConceptDelta(delta, namespace);
            if (d == null) {
                throw new XMLException("Invalid concept delta expression definition");
            }
            this.changes.add(d);
            ++i;
        }
    }

    public static ReleaseDelta getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("releaseDelta must be the name of the first element");
            }
            return new ReleaseDelta(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public String getRelease() {
        return this.release;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public Vector getDeltas() {
        return this.changes;
    }

    public void setDeltas(Vector deltas) {
        this.changes = deltas;
    }

    public void addDelta(ConceptDelta delta) {
        if (this.changes == null) {
            this.changes = new Vector();
        }
        this.changes.addElement(delta);
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(5000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        ReleaseDelta.xmlize(xml, this.release, this.changes);
    }

    protected static String xmlize(StringBuffer xml, String release, Vector deltas) {
        String tab0 = "    ";
        String tab = "        ";
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab);
        xml.ensureCapacity(xml.length() + 30);
        xml.append("<release>");
        xml.append(release);
        xml.append("</release>\n");
        Iterator iter = deltas.iterator();
        while (iter.hasNext()) {
            ConceptDelta delta = (ConceptDelta)iter.next();
            delta.xmlize(xml);
        }
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
        return xml.toString();
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof ReleaseDelta)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        ReleaseDelta comp = (ReleaseDelta)c;
        boolean ret = true;
        if (!Str.compareStr(this.release, comp.getRelease())) {
            if (out != null) {
                out.println("this->release=" + this.release + " is different from " + comp.getRelease());
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        Vector cchanges = comp.getDeltas();
        if (this.changes == null && cchanges != null || this.changes != null && cchanges == null) {
            if (out != null) {
                out.println("ConceptDeltas are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (cchanges == null && this.changes == null) {
            return ret;
        }
        if (this.changes.size() != cchanges.size()) {
            if (out != null) {
                out.println("ConceptDeltas sizes are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        Hashtable compht = this.convert(cchanges);
        Enumeration compkeys = compht.keys();
        Hashtable thisht = this.convert(this.changes);
        while (compkeys.hasMoreElements()) {
            String compkey = (String)compkeys.nextElement();
            ConceptDelta val = (ConceptDelta)thisht.get(compkey);
            if (val == null) {
                if (out != null) {
                    ConceptDelta missing = (ConceptDelta)compht.get(compkey);
                    out.println("ConceptDelta missing from this instance:");
                    out.println(missing.xmlize());
                }
                ret = false;
                if (!this.performance) continue;
                return ret;
            }
            ConceptDelta val2 = (ConceptDelta)compht.get(compkey);
            if (equalsFlag) {
                if (!val.equals(val2, out)) {
                    ret = false;
                    if (this.performance) {
                        return ret;
                    }
                }
            } else if (!val.equivalent(val2, out)) {
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
            thisht.remove(compkey);
        }
        Enumeration thiskeys = thisht.keys();
        while (thiskeys.hasMoreElements()) {
            ret = false;
            if (this.performance) {
                return ret;
            }
            String thiskey = (String)thiskeys.nextElement();
            ConceptDelta val = (ConceptDelta)thisht.get(thiskey);
            if (out == null) continue;
            ConceptDelta added = (ConceptDelta)thisht.get(thiskey);
            out.println("ConceptDelta added to this instance:");
            out.println(added.xmlize());
        }
        return ret;
    }

    private Hashtable convert(Vector vector) {
        Hashtable<String, ConceptDelta> table = new Hashtable<String, ConceptDelta>();
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            ConceptDelta val = (ConceptDelta)iter.next();
            table.put(val.getKey(), val);
        }
        return table;
    }

    public String getKey() {
        return this.release;
    }
}

