/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.meshentry;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class MeSHEntry
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    public static final String XmlName = "MeSHEntry";
    private String sui;
    private String lui;
    private String aui;
    private String str;
    private String tty;
    private String scd;
    private boolean performance = false;

    public MeSHEntry() {
        this.str = "";
        this.sui = "";
        this.lui = "";
        this.aui = "";
        this.str = "";
        this.tty = "";
        this.scd = "";
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public MeSHEntry(String sui, String lui, String str, String sab, String tty, String scd) {
        this.sui = sui;
        this.lui = lui;
        this.str = str;
        this.tty = tty;
        this.scd = scd;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public MeSHEntry(String sui, String lui, String str, String tty, String scd) {
        this.sui = sui;
        this.lui = lui;
        this.str = str;
        this.tty = tty;
        this.scd = scd;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public MeSHEntry(Element entry, Namespace namespace) throws XMLException {
        Element suiChild;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
        if ((suiChild = entry.getChild("sui", namespace)) == null) {
            throw new XMLException("No string unique identifier <sui> found");
        }
        this.sui = XMLInterpreter.extractString(suiChild);
        Element luiChild = entry.getChild("lui", namespace);
        if (luiChild == null) {
            throw new XMLException("No lexical unique identifier <lui> found");
        }
        this.lui = XMLInterpreter.extractString(luiChild);
        Element auiChild = entry.getChild("aui", namespace);
        this.aui = auiChild != null ? XMLInterpreter.extractString(auiChild) : "";
        Element strChild = entry.getChild("str", namespace);
        if (strChild == null) {
            throw new XMLException("No string <str> found");
        }
        this.str = XMLInterpreter.extractString(strChild);
        Element ttyChild = entry.getChild("tty", namespace);
        if (ttyChild == null) {
            throw new XMLException("No term type <tty> found");
        }
        this.tty = XMLInterpreter.extractString(ttyChild);
        Element scdChild = entry.getChild("scd", namespace);
        if (scdChild == null) {
            throw new XMLException("No source code value <scd> found");
        }
        this.scd = XMLInterpreter.extractString(scdChild);
    }

    public static MeSHEntry getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("MeSHEntry must be the name of the first element");
            }
            return new MeSHEntry(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setSUI(String sui) {
        this.sui = sui;
    }

    public String getSUI() {
        return this.sui;
    }

    public void setLUI(String lui) {
        this.lui = lui;
    }

    public String getLUI() {
        return this.lui;
    }

    public void setAUI(String aui) {
        this.aui = aui;
    }

    public String getAUI() {
        return this.aui;
    }

    public void setSTR(String str) {
        this.str = str;
    }

    public String getSTR() {
        return this.str;
    }

    public void setSAB(String sab) {
    }

    public String getSAB() {
        return "MSH";
    }

    public void setTTY(String tty) {
        this.tty = tty;
    }

    public String getTTY() {
        return this.tty;
    }

    public void setSCD(String scd) {
        this.scd = scd;
    }

    public String getSCD() {
        return this.scd;
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        out.println("");
        out.println("SUI:      " + this.sui);
        out.println("LUI:      " + this.lui);
        out.println("AUI:      " + this.aui);
        out.println("STR:      " + this.str);
        out.println("TTY:      " + this.tty);
        out.println("SCD:      " + this.scd);
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(1000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        String tab0 = "      ";
        String tab = "         ";
        xml.ensureCapacity(xml.length() + 500);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab);
        xml.append("<lui>");
        xml.append(this.lui);
        xml.append("</lui>\n");
        xml.append(tab);
        xml.append("<sui>");
        xml.append(Str.escape(this.sui));
        xml.append("</sui>\n");
        if (this.aui != null && !this.aui.equals("")) {
            xml.append(tab);
            xml.append("<aui>");
            xml.append(this.aui);
            xml.append("</aui>\n");
        }
        xml.append(tab);
        xml.append("<str>");
        xml.append(Str.escape(this.str));
        xml.append("</str>\n");
        xml.append(tab);
        xml.append("<tty>");
        xml.append(Str.escape(this.tty));
        xml.append("</tty>\n");
        xml.append(tab);
        xml.append("<scd>");
        xml.append(this.scd);
        xml.append("</scd>\n");
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public static void xmlize(StringBuffer xml, String sui, String lui, String str, String tty, String scd) {
        String tab0 = "      ";
        String tab = "         ";
        xml.ensureCapacity(xml.length() + 500);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab);
        xml.append("<sui>");
        xml.append(Str.escape(sui));
        xml.append("</sui>\n");
        xml.append(tab);
        xml.append("<lui>");
        xml.append(lui);
        xml.append("</lui>\n");
        xml.append(tab);
        xml.append("<str>");
        xml.append(Str.escape(str));
        xml.append("</str>\n");
        xml.append(tab);
        xml.append("<tty>");
        xml.append(Str.escape(tty));
        xml.append("</tty>\n");
        xml.append(tab);
        xml.append("<scd>");
        xml.append(scd);
        xml.append("</scd>\n");
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public static void xmlize(StringBuffer xml, String sui, String lui, String str, String sab, String tty, String scd) {
        MeSHEntry.xmlize(xml, sui, lui, str, tty, scd);
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String scd;
        String tty;
        String str;
        String aui;
        String lui;
        if (!(c instanceof MeSHEntry)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        MeSHEntry comp = (MeSHEntry)c;
        boolean ret = true;
        String sui = this.getSUI();
        if (!Str.compareStr(sui, comp.getSUI())) {
            if (out != null) {
                out.println("this->SUI='" + sui + "' is different from '" + comp.getSUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(lui = this.getLUI(), comp.getLUI())) {
            if (out != null) {
                out.println("this->LUI='" + lui + "' is different from '" + comp.getLUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(aui = this.getAUI(), comp.getAUI())) {
            if (out != null) {
                out.println("this->AUI='" + aui + "' is different from '" + comp.getAUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(str = this.getSTR(), comp.getSTR())) {
            if (out != null) {
                out.println("this->STR='" + str + "' is different from '" + comp.getSTR() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(tty = this.getTTY(), comp.getTTY())) {
            if (out != null) {
                out.println("this->TTY='" + tty + "' is different from '" + comp.getTTY() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(scd = this.getSCD(), comp.getSCD())) {
            if (out != null) {
                out.println("this->SCD='" + scd + "' is different from '" + comp.getSCD() + "'");
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        if (this.aui == null) {
            return this.sui + this.lui;
        }
        return this.sui + this.lui + this.aui;
    }
}

