/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.meshentry;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class MeSHInfo
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    public static final String XmlName = "MeSHInfo";
    private String dui;
    private Vector terms;
    private boolean performance = false;

    public MeSHInfo() {
        this.dui = "";
        this.terms = new Vector();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public MeSHInfo(String dui) {
        this.dui = dui;
        this.terms = new Vector();
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public MeSHInfo(String dui, Vector terms) {
        this.dui = dui;
        this.terms = terms;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
    }

    public MeSHInfo(Element entry, Namespace namespace) throws XMLException {
        Element duiChild;
        if (System.getProperty("PerformanceEnhanced") != null) {
            this.performance = true;
        }
        if ((duiChild = entry.getChild("dui", namespace)) == null) {
            throw new XMLException("No string unique identifier <dui> found");
        }
        this.dui = XMLInterpreter.extractString(duiChild);
        List termList = entry.getChildren("term", namespace);
        if (termList == null || termList.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < termList.size()) {
            Element termEle = (Element)termList.get(i);
            this.addTerm(XMLInterpreter.extractString(termEle));
            ++i;
        }
    }

    public static MeSHInfo getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("MeSHInfo must be the name of the first element");
            }
            return new MeSHInfo(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public void setDUI(String dui) {
        this.dui = dui;
    }

    public String getDUI() {
        return this.dui;
    }

    public void setTerms(Vector terms) {
        this.terms = terms;
    }

    public Vector getTerms() {
        return this.terms;
    }

    public void addTerm(String term) {
        if (this.terms == null) {
            this.terms = new Vector();
        }
        this.terms.add(term);
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        out.println("");
        out.println("DUI:      " + this.dui);
        if (this.terms != null) {
            Iterator iter = this.terms.iterator();
            int i = 1;
            while (iter.hasNext()) {
                out.println("Term " + i++ + ": " + (String)iter.next());
            }
        }
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(1000);
        this.xmlize(xml);
        return xml.toString();
    }

    public void xmlize(StringBuffer xml) {
        MeSHInfo.xmlize(xml, this.dui, this.terms);
    }

    public static void xmlize(StringBuffer xml, String dui, Vector terms) {
        String tab0 = "      ";
        String tab = "         ";
        xml.ensureCapacity(xml.length() + 80);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        xml.append(tab);
        xml.append("<dui>");
        xml.append(Str.escape(dui));
        xml.append("</dui>\n");
        if (terms != null) {
            Iterator iter = terms.iterator();
            xml.ensureCapacity(xml.length() + 200 * terms.size());
            while (iter.hasNext()) {
                String term = (String)iter.next();
                xml.append(tab);
                xml.append("<term>");
                xml.append(Str.escape(term));
                xml.append("</term>\n");
            }
        }
        xml.ensureCapacity(xml.length() + 30);
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        if (!(c instanceof MeSHInfo)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        MeSHInfo comp = (MeSHInfo)c;
        boolean ret = true;
        String dui = this.getDUI();
        if (!Str.compareStr(dui, comp.getDUI())) {
            if (out != null) {
                out.println("this->DUI='" + dui + "' is different from '" + comp.getDUI() + "'");
            }
            ret = false;
        }
        Vector vars = comp.getTerms();
        if (this.terms == null && vars != null || this.terms != null && vars == null) {
            if (out != null) {
                out.println("TermVariants are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        if (this.terms == null && vars == null) {
            return ret;
        }
        if (this.terms.size() != vars.size()) {
            if (out != null) {
                out.println("Terms are different");
            }
            ret = false;
            if (this.performance) {
                return ret;
            }
        }
        Hashtable compht = this.convert(vars);
        Enumeration compkeys = compht.keys();
        Hashtable thisht = this.convert(this.terms);
        while (compkeys.hasMoreElements()) {
            String compkey = (String)compkeys.nextElement();
            String val = (String)thisht.get(compkey);
            if (val == null) {
                if (out != null) {
                    String missing = (String)compht.get(compkey);
                    out.println("String missing from this instance:" + missing);
                }
                ret = false;
                if (!this.performance) continue;
                return ret;
            }
            String val2 = (String)compht.get(compkey);
            if (!val.equals(val2)) {
                ret = false;
                if (this.performance) {
                    return ret;
                }
            }
            thisht.remove(compkey);
        }
        Enumeration thiskeys = thisht.keys();
        while (thiskeys.hasMoreElements()) {
            ret = false;
            if (this.performance) {
                return ret;
            }
            String thiskey = (String)thiskeys.nextElement();
            String val = (String)thisht.get(thiskey);
            if (out == null) continue;
            String added = (String)thisht.get(thiskey);
            out.println("String added to this instance:" + added);
        }
        return ret;
    }

    private Hashtable convert(Vector vector) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            String val = (String)iter.next();
            table.put(val, val);
        }
        return table;
    }

    public String getKey() {
        return this.dui;
    }
}

