/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.relation;

import gov.nih.nlm.kss.models.KSComparable;
import gov.nih.nlm.kss.models.Xmlizable;
import gov.nih.nlm.kss.util.Str;
import gov.nih.nlm.kss.util.XMLException;
import gov.nih.nlm.kss.util.XMLInterpreter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class RelSource
extends XMLInterpreter
implements Serializable,
Xmlizable,
KSComparable {
    private String cui;
    private String cn;
    private String aui;
    private String type;
    private String rel;
    private String rui;
    private String rela;
    private String srui;
    private boolean directed;
    private String autogen;
    public static final String XmlName = "relSource";

    public RelSource() {
        this.cui = "";
        this.cn = "";
        this.aui = "";
        this.type = "";
        this.rel = "";
        this.rui = "";
        this.rela = "";
        this.srui = "";
        this.directed = false;
        this.autogen = "";
    }

    public RelSource(Element relation, Namespace namespace) throws XMLException {
        Element dirChild;
        Element sruiChild;
        Element relaChild;
        Element ruiChild;
        Element relChild;
        Element typeChild;
        Element cuiChild = relation.getChild("cui", namespace);
        if (cuiChild == null) {
            throw new XMLException("No concept unique identifier for concept 2 <cui> found");
        }
        this.cui = XMLInterpreter.extractString(cuiChild);
        Element cnChild = relation.getChild("cn", namespace);
        if (cnChild == null) {
            throw new XMLException("No concept unique identifier for concept 2 <cn> found");
        }
        this.cn = XMLInterpreter.extractString(cnChild);
        Element auiChild = relation.getChild("aui", namespace);
        if (auiChild != null) {
            this.aui = XMLInterpreter.extractString(auiChild);
        }
        if ((typeChild = relation.getChild("type", namespace)) != null) {
            this.type = XMLInterpreter.extractString(typeChild);
        }
        if ((relChild = relation.getChild("rel", namespace)) != null) {
            this.rel = XMLInterpreter.extractString(relChild);
        }
        if ((ruiChild = relation.getChild("rui", namespace)) != null) {
            this.rui = XMLInterpreter.extractString(ruiChild);
        }
        if ((relaChild = relation.getChild("rela", namespace)) != null) {
            this.rela = XMLInterpreter.extractString(relaChild);
        }
        if ((sruiChild = relation.getChild("srui", namespace)) != null) {
            this.srui = XMLInterpreter.extractString(sruiChild);
        }
        if ((dirChild = relation.getChild("directed", namespace)) != null) {
            this.directed = true;
        }
        Element autogenChild = relation.getChild("autogen", namespace);
        this.autogen = null;
        if (autogenChild != null) {
            this.autogen = XMLInterpreter.extractString(autogenChild);
        }
    }

    public static RelSource getInstance(String xml) throws XMLException {
        String nsName = System.getProperty("KSSNamespaceName");
        String nsURL = System.getProperty("KSSNamespaceURL");
        if (nsName == null) {
            nsName = "";
        }
        if (nsURL == null) {
            nsURL = "";
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(new StringReader(xml));
            Element root = doc.getRootElement();
            Namespace namespace = Namespace.getNamespace(nsName, nsURL);
            if (!root.getName().equals(XmlName)) {
                throw new XMLException("relSource must be the name of the first element");
            }
            return new RelSource(root, namespace);
        }
        catch (JDOMException ex) {
            throw new XMLException(ex.getMessage());
        }
    }

    public String getCUI() {
        return this.cui;
    }

    public void setCUI(String cui) {
        this.cui = cui;
    }

    public String getCN() {
        return this.cn;
    }

    public void setCN(String cn) {
        this.cn = cn;
    }

    public String getAUI() {
        return this.aui;
    }

    public void setAUI(String aui) {
        this.aui = aui;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRel() {
        return this.rel;
    }

    public void setRel(String rel) {
        this.rel = rel;
    }

    public String getRUI() {
        return this.rui;
    }

    public void setRUI(String rui) {
        this.rui = rui;
    }

    public void setRelA(String rela) {
        this.rela = rela;
    }

    public String getRelA() {
        return this.rela;
    }

    public void setSRUI(String srui) {
        this.srui = srui;
    }

    public String getSRUI() {
        return this.srui;
    }

    public void setDirectionality(boolean dir) {
        this.directed = dir;
    }

    public boolean getDirectionality() {
        return this.directed;
    }

    public void setAutoGen(String autogen) {
        this.autogen = autogen;
    }

    public String getAutoGen() {
        return this.autogen;
    }

    public void output() {
        PrintStream out;
        try {
            out = new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (Exception ex) {
            out = new PrintStream(System.out);
        }
        out.println("");
        out.println("CUI:      " + this.cui);
        out.println("Name:     " + this.cn);
        out.println("AUI:      " + this.aui);
        out.println("TYPE:     " + this.type);
        out.println("Rel:      " + this.rel);
        out.println("RUI:      " + this.rui);
        out.println("RelA:     " + this.rela);
        out.println("SRUI:     " + this.srui);
        out.println("Directed: " + this.directed);
        out.println("Autogen'd:" + this.autogen);
    }

    public String xmlize() {
        StringBuffer xml = new StringBuffer(1000);
        String tab0 = "         ";
        String tab = "            ";
        xml.ensureCapacity(xml.length() + 1000);
        xml.append(tab0);
        xml.append("<");
        xml.append(XmlName);
        xml.append(">\n");
        String mcui = this.cui;
        if (mcui == null) {
            mcui = "";
        }
        xml.append(tab);
        xml.append("<cui>");
        xml.append(mcui);
        xml.append("</cui>\n");
        String mcn = this.cn;
        if (mcn == null) {
            mcn = "";
        }
        xml.append(tab);
        xml.append("<cn>");
        xml.append(Str.escape(mcn));
        xml.append("</cn>\n");
        if (this.aui != null && !this.aui.equals("")) {
            xml.append(tab);
            xml.append("<aui>");
            xml.append(Str.escape(this.aui));
            xml.append("</aui>\n");
        }
        if (this.type != null && !this.type.equals("")) {
            xml.append(tab);
            xml.append("<type>");
            xml.append(Str.escape(this.type));
            xml.append("</type>\n");
        }
        if (this.rel != null && !this.rel.equals("")) {
            xml.append(tab);
            xml.append("<rel>");
            xml.append(this.rel);
            xml.append("</rel>\n");
        }
        if (this.rui != null && !this.rui.equals("")) {
            xml.append(tab);
            xml.append("<rui>");
            xml.append(this.rui);
            xml.append("</rui>\n");
        }
        if (this.rela != null && !this.rela.equals("")) {
            xml.append(tab);
            xml.append("<rela>");
            xml.append(this.rela);
            xml.append("</rela>\n");
        }
        if (this.srui != null && !this.srui.equals("")) {
            xml.append(tab);
            xml.append("<srui>");
            xml.append(this.srui);
            xml.append("</srui>\n");
        }
        if (this.directed) {
            xml.append(tab);
            xml.append("<directed/>\n");
        }
        if (this.autogen != null && !this.autogen.equals("")) {
            xml.append(tab);
            xml.append("<autogen>");
            xml.append(this.autogen);
            xml.append("</autogen>\n");
        }
        xml.append(tab0);
        xml.append("</");
        xml.append(XmlName);
        xml.append(">\n");
        return xml.toString();
    }

    public boolean equals(KSComparable comp) {
        return this.equals(comp, null);
    }

    public boolean equals(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, true);
    }

    public boolean equivalent(KSComparable comp) {
        return this.equivalent(comp, null);
    }

    public boolean equivalent(KSComparable comp, PrintStream out) {
        return this.doCompare(comp, out, false);
    }

    private boolean doCompare(KSComparable c, PrintStream out, boolean equalsFlag) {
        String autogen;
        if (!(c instanceof RelSource)) {
            if (out != null) {
                out.println("Attempting to compare instances from different class hierarchies: ");
                out.println("\t" + c.getClass().getName() + " and " + this.getClass().getName());
            }
            return false;
        }
        RelSource comp = (RelSource)c;
        boolean ret = true;
        if (!Str.compareStr(this.cui, comp.getCUI())) {
            if (out != null) {
                out.println("this->CUI='" + this.cui + "' is different from '" + comp.getCUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.aui, comp.getAUI())) {
            if (out != null) {
                out.println("this->AUI='" + this.aui + "' is different from '" + comp.getAUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.type, comp.getType())) {
            if (out != null) {
                out.println("this->Type='" + this.type + "' is different from '" + comp.getType() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.rel, comp.getRel())) {
            if (out != null) {
                out.println("this->REL='" + this.rel + "' is different from '" + comp.getRel() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.rui, comp.getRUI())) {
            if (out != null) {
                out.println("this->RUI='" + this.rui + "' is different from '" + comp.getRUI() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.rela, comp.getRelA())) {
            if (out != null) {
                out.println("this->RELA='" + this.rela + "' is different from '" + comp.getRelA() + "'");
            }
            ret = false;
        }
        if (!Str.compareStr(this.srui, comp.getSRUI())) {
            if (out != null) {
                out.println("this->SRUI='" + this.srui + "' is different from '" + comp.getSRUI() + "'");
            }
            ret = false;
        }
        if (this.directed != comp.getDirectionality()) {
            if (out != null) {
                out.println("this->directionality='" + this.directed + "' is different from '" + comp.getDirectionality() + "'");
            }
            ret = false;
        }
        if (equalsFlag && !Str.compareStr(autogen = this.getAutoGen(), comp.getAutoGen())) {
            if (out != null) {
                out.println("this->AutoGen='" + autogen + "' is different from '" + comp.getAutoGen() + "'");
            }
            ret = false;
        }
        return ret;
    }

    public String getKey() {
        return this.cui + this.aui + this.rel + this.rui + this.rela + this.srui;
    }
}

