/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.kss.models.meta.relation;

import gov.nih.nlm.kss.models.KSCuiVector;
import gov.nih.nlm.kss.models.meta.relation.RelSource;
import gov.nih.nlm.kss.models.meta.relation.Relation;
import gov.nih.nlm.kss.util.XMLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class RelationVector
extends KSCuiVector {
    public static final String XmlName = "RelationCollection";
    public static final String XmlStructure = "2.0";

    public RelationVector(Vector rels) {
        super(rels, XmlName, XmlStructure);
    }

    public RelationVector(RelationVector rels) {
        super(rels, XmlName, XmlStructure);
    }

    public RelationVector() {
        super(XmlName, XmlStructure);
    }

    public RelationVector(String xml) throws XMLException {
        super(XmlName, XmlStructure);
        this.parse(xml);
    }

    protected void parse(Element root, Namespace namespace) throws XMLException {
        super.parse(root, namespace);
        String childName = "relation";
        List relations = root.getChildren(childName, namespace);
        if (relations == null || relations.size() == 0) {
            return;
        }
        int i = 0;
        while (i < relations.size()) {
            Element rel = (Element)relations.get(i);
            Relation relation = new Relation(this.getCUI(), rel, namespace);
            if (relation == null) {
                throw new XMLException("Invalid relation definition");
            }
            this.add(relation);
            ++i;
        }
        Element firstRel = (Element)relations.get(0);
        List relSrcs = firstRel.getChildren("relSource", namespace);
        if (relSrcs == null || relSrcs.size() == 0) {
            this.processOldRelations();
        }
    }

    private void processOldRelations() {
        int size = this.size();
        Vector vec = new Vector();
        int i = 0;
        while (i < size) {
            vec.add(this.remove(0));
            ++i;
        }
        Hashtable<String, Relation> relSrcBySAB = new Hashtable<String, Relation>();
        Iterator iter = vec.iterator();
        while (iter.hasNext()) {
            Relation rel = (Relation)iter.next();
            Vector relSrcs = rel.getRelSources();
            if (relSrcs == null) continue;
            Iterator iter2 = relSrcs.iterator();
            while (iter2.hasNext()) {
                RelSource rsrc = (RelSource)iter2.next();
                Relation srel = (Relation)relSrcBySAB.get(rel.getSAB());
                if (srel == null) {
                    srel = new Relation();
                    srel.setAUI(rel.getAUI());
                    srel.setType(rel.getType());
                    srel.setSAB(rel.getSAB());
                    srel.setSL(rel.getSL());
                }
                srel.addRelSource(rsrc);
                relSrcBySAB.put(srel.getSAB(), srel);
            }
        }
        Enumeration e = relSrcBySAB.keys();
        while (e.hasMoreElements()) {
            String sab = (String)e.nextElement();
            Relation r = (Relation)relSrcBySAB.get(sab);
            if (r == null) continue;
            this.add(r);
        }
    }

    public static RelationVector getInstance(String xml) {
        RelationVector aev = null;
        try {
            aev = new RelationVector(xml);
        }
        catch (XMLException ex) {
            System.err.println("XMLException: " + ex.getMessage());
            return null;
        }
        return aev;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("Usage: java ");
            System.out.print("gov.nih.nlm.kss.models.meta.relation.RelationVector");
            System.out.println(" <XML_URI> ");
            return;
        }
        String name = "";
        String url = "";
        System.setProperty("KSSNamespaceName", name);
        System.setProperty("KSSNamespaceURL", url);
        String filename = args[0];
        try {
            BufferedReader fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));
            PrintStream out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            StringBuffer xml = new StringBuffer(50000);
            String s = "";
            while (s != null) {
                s = fis.readLine();
                if (s == null) continue;
                xml.append(s);
            }
            RelationVector vec = RelationVector.getInstance(xml.toString());
            if (vec == null) {
                System.out.println("No relations read");
                return;
            }
            System.out.println("Number of relations: " + vec.size());
            Iterator iter = vec.iterator();
            while (iter.hasNext()) {
                Relation relation = (Relation)iter.next();
                System.out.println("Relation----------------");
                relation.output();
                System.out.println("Relation END------------");
            }
            System.out.println("XML Version:");
            out.println(vec.xmlize());
        }
        catch (FileNotFoundException ex) {
            System.out.println("Unable to load file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println("Unable to read file '" + filename + "'");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

